﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<UserCategory>" %>
<%  int? categoryID = (int?)ViewData["categoryID"];
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User();
    string userCategoryItemKey = ViewData.GetString("userCategoryItemKey", string.Empty);
    if (TempData["statusMessageData"] != null)
    {
        StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("statusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
        if (statusMessageData.MessageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();',2000)</script>"));
        }
        TempData["statusMessageData"] = null;
    }
%>
<spb:Script runat="server" ID="jquery_form" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
    ForceLoad="true" SetExpireDays="30">
</spb:Script>
<form id="EditUserCategory" class="tn-helper-reset nyroModal" action="<%=SPBUrlHelper.Action("CreateUpdateUserCategory","UserDomain",new RouteValueDictionary{{"userDomainName",userDomainName},{"userCategoryItemKey",userCategoryItemKey},{"categoryID",categoryID}}) %>"
method="post">
<div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
        <% 
            if (userCategoryItemKey.Equals(UserCategoryItemKeys.Instance().File()))
            {
                if (string.IsNullOrEmpty(Model.CategoryName))
                    Response.Write("新建文件夹");
                else
                    Response.Write("编辑文件夹");
            }
            else
            {
                if (string.IsNullOrEmpty(Model.CategoryName))
                    Response.Write(GetResourceString("Common_NewUserCategory"));
                else
                    Response.Write(GetResourceString("Title_EditUserCategory", applicationID));
            }%>
    </h4>
    <div class="tn-form-row">
        <label class="tn-form-label">
            <%if (userCategoryItemKey.Equals(UserCategoryItemKeys.Instance().File()))
                  Response.Write("文件夹名称");
              else
                  Response.Write(GetResourceString("Label_UserCategoryName", applicationID));%><%=GetResourceString("Common_Colon") %></label>
        <input type="text" name="categoryName" id="categoryName" value="<%=Model.CategoryName %>"
            class="tn-textbox tn-input-medium tn-border-gray" style="width: 200px" maxlength="100" />
        <div class="tn-text-note">
            <%=string.Format(GetResourceString("Description_Pattern_UserCategoryNameLengthLimit", applicationID),20)%></div>
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            <%=GetResourceString("Label_Description")%><%=GetResourceString("Common_Colon") %></label>
        <input type="text" name="description" id="description" value="<%=Model.Description %>"
            class="tn-textbox tn-input-medium tn-border-gray" style="width: 200px" maxlength="100" />
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            <%=GetResourceString("Label_OrderNO")%><%=GetResourceString("Common_Colon") %>
        </label>
        <input type="text" name="displayOrder" id="displayOrder" value="<%=Model.DisplayOrder%>"
            class="tn-textbox tn-input-medium tn-border-gray" style="width: 200px" maxlength="100" />
    </div>
    <div class="tn-form-row tn-form-row-button ">
        <label class="tn-form-label">
        </label>
        <%=SPBHtmlHelper.Instance().SubmitButton("newUserTagSubmitButton", GetResourceString("Button_OK"),ButtonSizes.Default,null,null)%>
        <%=SPBHtmlHelper.Instance().Button("cancelButton", GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Default, new RouteValueDictionary { { "class", "nyroModalClose" } },null)%>
    </div>
</div>
</form>

<script type="text/javascript">
    $(document).ready(function() {
        $("#EditUserCategory").validate({
            rules: {
                categoryName: { required: true, rangelength: [1, 20] },
                displayOrder: { digits: true },
                description: { maxBlength: "100" }
            },
            messages: {
                categoryName: { required: "<%=GetResourceString("Validate_CategoryName_Required",applicationID)%>", rangelength: "类别名称在1到20个字内" },
                displayOrder: { digits: "<%=GetResourceString("Validate_DisplayOrder_Digits",applicationID)%>" },
                description: "<%=string.Format(GetResourceString("Validate_Pattern_Description_Maxlength", applicationID),100)%>"
            }
        });
        $("#newUserTagSubmitButton").click(function() {
            if (!$("#EditUserCategory").valid()) {
                return false;
            }
        });
    }); 
</script>

