﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<UserCategory>>" %>
<% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   string userCategoryItemKey = ViewData.GetString("userCategoryItemKey", string.Empty);
   int applicationID = ApplicationIDs.Instance().User();
   string categoryNameUrlPattern = ViewData.GetString("categoryNameUrlPattern", string.Empty);
   List<UserCategory> userCategoryList = (List<UserCategory>)ViewData.Model; %>
<div id="ManageUserCategories">
    <div class="tn-filter-controls tn-helper-clearfix tn-border-gray tn-border-bottom">
        <%=SPBHtmlHelper.Instance().LinkButton("newCategoryModal", userCategoryItemKey.Equals(UserCategoryItemKeys.Instance().File())?"新建文件夹":GetResourceString("Common_NewUserCategory"), SPBUrlHelper.Action("Control_EditUserCategory", "UserDomain", new RouteValueDictionary { { "userDomainName", userDomainName }, { "userCategoryItemKey", userCategoryItemKey } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText)%>
        <div class="tn-blank10">
        </div>
    </div>
    <div class="tn-grid">
        <table class="tn-table-grid">
            <tr class="tn-table-grid-header">
                <th class="tn-border-gray tn-border-bottom tn-text-note">
                    <% if (userCategoryItemKey.Equals(UserCategoryItemKeys.Instance().File()))
                           Response.Write("文件夹名称");
                       else
                           Response.Write(GetResourceString("Label_UserCategoryName", applicationID));%>
                </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note">
                    <%=GetResourceString("Label_OrderNO")%>
                </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note">
                    <%=GetResourceString("Label_ItemCount",applicationID)%>
                </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note">
                    <%=GetResourceString("Label_CreateDate",applicationID)%>
                </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note">
                    <%=GetResourceString("Label_Actions")%>
                </th>
            </tr>
            <% if (ViewData.Model != null && ViewData.Model.Count > 0)
               {
                   foreach (UserCategory userCategory in userCategoryList)
                   {
                       if (userCategory != null)
                       {
            %>
            <tr class="tn-table-grid-row">
                <td class="tn-border-gray tn-border-bottom tn-width-category tn-nowrap">
                    <a href="<%=string.Format(WebUtils.UrlDecode(categoryNameUrlPattern),userCategory.CategoryID) %>">
                        <%=HtmlUtils.TrimHtml(userCategory.CategoryName,20)%>
                    </a>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                    <%=userCategory.DisplayOrder %>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                    <%=userCategory.ItemCount%>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-datetime tn-nowrap">
                    <%=Formatter.FormatDate(userCategory.DateCreated,true) %>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-action2 tn-nowrap">
                    <span class="tn-action">
                        <a class="EditTheUserCategory tn-action-text" href="<%=SPBUrlHelper.Action("Control_EditUserCategory", "UserDomain", new RouteValueDictionary { { "userDomainName", userDomainName }, { "userCategoryItemKey", userCategoryItemKey }, { "categoryID", userCategory.CategoryID } })%>">
                            <%=GetResourceString("Action_Edit")%></a></span>
                    <span class="tn-action">
                        <a class="tn-action-text" href="javascript:;" onclick="if (confirm('<%=GetResourceString("Message_UserCategoryDeleteConfirm",applicationID)%>')) { $('#ManageUserCategories').load('<%=SPBUrlHelper.Action("DeleteUserCategory","UserDomain",new RouteValueDictionary{{"userDomainName",userDomainName},{"userCategoryItemKey",userCategoryItemKey},{"categoryID",userCategory.CategoryID}}) %>',{ date1: new Date() } )}">
                            <%=GetResourceString("Action_Delete")%>
                        </a>
                    </span>
                </td>
            </tr>
            <%}
                   }
               } %>
        </table>
    </div>

    <script type="text/javascript">
        $(document).ready(function() {

            $('#newCategoryModal').nyroModal({
                resizeable: true,
                height: 300,
                width: 400,
                endRemove: function(elts, settings) {
                    window.location.reload();
                }
            });

            $('a.EditTheUserCategory').each(function(i) {
                $(this).nyroModal({
                    resizeable: true,
                    height: 300,
                    width: 400,
                    endRemove: function(elts, settings) {
                        window.location.reload();
                    }
                });
            });
        }); 
    </script>

</div>
