﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   int applicationID = ApplicationIDs.Instance().User();
   string userTagItemKey = ViewData.GetString("userTagItemKey", string.Empty);
   if (TempData["statusMessageData"] != null)
   {
       StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("statusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
       Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
       if (statusMessageData.MessageType == StatusMessageType.Success)
       {
           //关闭模式窗口
           Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
       }
       TempData["statusMessageData"] = null;
   }
%>
<spb:Script runat="server" ID="jquery_form" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
    ForceLoad="true" SetExpireDays="30">
</spb:Script>
<form id="EditUserTagForm" class="tn-helper-reset nyroModal" action="<%=SPBUrlHelper.Action("CreateUserTag","UserDomain",new RouteValueDictionary{{"userDomainName",userDomainName},{"userTagItemKey",userTagItemKey}}) %>"
method="post">
<div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
        <%=GetResourceString("Title_CreateUserTag", applicationID)%>
    </h4>
    <div class="tn-form-row">
        <label class="tn-form-label">
            <%=GetResourceString("Label_UserTagName",applicationID)%><%=GetResourceString("Common_Colon") %></label>
        <input type="text" name="tagName" id="tagName" class="tn-textbox tn-input-long tn-border-gray"
            value="<%=TempData.GetString("errorTagNames", string.Empty) %>" style="width: 200px" maxlength="100" />
    </div>
    <div class="tn-form-row">
       可以一次输入多个标签，标签之间 请用「逗号 ,」或「分号 ;」
    </div>
    <div class="tn-form-row tn-form-row-button">
        <label class="tn-form-label">
        </label>
        <%=SPBHtmlHelper.Instance().SubmitButton("postButton",GetResourceString("Button_OK"),ButtonSizes.Default,null,null) %>
        <%=SPBHtmlHelper.Instance().CancelButton( new RouteValueDictionary { { "class", "nyroModalClose" } })%>
    </div>
</div>
</form>

<script type="text/javascript">

$("#postButton").click(function() {
            if (!$("#EditUserTagForm").valid()) {
                return false;
            }
        });
    $(document).ready(function() {
        $("#EditUserTagForm").validate({
            rules: {
                tagName: {required:true,rangelength:[1,16]}
            },
            messages: {
                tagName: {required:"<%=GetResourceString("Validate_TagName_Required",applicationID)%>",rangelength:"<%=GetResourceString("Validate_TagName_Rangelength", applicationID)%>"}
            }
        });

    }); 
</script>

