﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<ICollection<UserTag>>" %>
<% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   string userTagItemKey = ViewData.GetString("userTagItemKey", string.Empty);
   string tagNameUrlPattern = ViewData.GetString("tagNameUrlPattern", string.Empty);
   int applicationID = ApplicationIDs.Instance().User();
%>
<div id="ManageUserTags">
    <div class="tn-filter-controls tn-helper-clearfix tn-border-gray tn-border-bottom">
        <%=SPBHtmlHelper.Instance().LinkButton("newTagModal", GetResourceString("Action_CreateNewTag", ApplicationIDs.Instance().File()), SPBUrlHelper.Action("Control_EditUserTag", "UserDomain", new RouteValueDictionary { { "userDomainName", userDomainName }, { "userTagItemKey", userTagItemKey } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText)%>
        <div class="tn-blank10">
        </div>
    </div>
    <table class="tn-table-grid">
        <tr class="tn-table-grid-header">
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_UserTagName",applicationID)%>
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_ItemCount", applicationID)%>
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_UserTagShareCount", ApplicationIDs.Instance().User())%>
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_CreateDate", applicationID)%>
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_Actions")%>
            </th>
        </tr>
        <%if (Model != null && Model.Count > 0)
          {
              foreach (UserTag userTag in Model)
              {
                  if (userTag != null)
                  {%>
        <tr class="tn-table-grid-row">
            <td class="tn-border-gray tn-border-bottom tn-width-auto">
                <a href="<%=string.Format(WebUtils.UrlDecode(tagNameUrlPattern),WebUtils.UrlEncode(userTag.TagName)) %>">
                    <%=StringUtils.Trim(userTag.TagName,15)%></a>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                <%=userTag.ItemCount%>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                <%=userTag.UserCount%>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
                <%=Formatter.FormatDate(userTag.DateCreated,false) %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-action1 tn-nowrap">
                <span class="tn-action"><a href="javascript:;" class="tn-action-text" onclick="if (confirm('<%=GetResourceString("Message_UserTagDeleteConfirm",applicationID)%>')) { $('#ManageUserTags').load('<%=SPBUrlHelper.Action("DeleteUserTag","UserDomain",new RouteValueDictionary{{"userDomainName",userDomainName},{"userTagItemKey",userTagItemKey},{"tagName",WebUtils.UrlEncode(userTag.TagName)}}) %>',{ date: new Date() } )}">
                    <%=GetResourceString("Action_Delete")%>
                </a></span>
            </td>
        </tr>
        <%}
              }
          } %>
    </table>

    <script type="text/javascript">
        $(document).ready(function() {
            $('#newTagModal').nyroModal({
                resizeable: true,
                height: 300,
                width: 400,
                endRemove: function(elts, settings) {
                    $('#ManageUserTags').parent().load('<%=SPBUrlHelper.Action("Control_ManageUserTags","UserDomain",new RouteValueDictionary{{"userDomainName",userDomainName},{"userTagItemKey",userTagItemKey}}) %>');
                }
            });

            $('a.EditTheUserTag').each(function(i) {
                $(this).nyroModal({
                    resizeable: true,
                    height: 300,
                    width: 400,
                    endRemove: function(elts, settings) {
                        $('#ManageUserTags').parent().load('<%=SPBUrlHelper.Action("Control_ManageUserTags","UserDomain",new RouteValueDictionary{{"userDomainName",userDomainName},{"userTagItemKey",userTagItemKey}}) %>');
                    }
                });
            });
        }); 
    </script>

</div>
