﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<EventThread>>" %>
<%  int EventApplicationID = ApplicationIDs.Instance().Event(); %>
     
 <div  class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <%if (Model.TotalRecords> 0)
      { %>
        <ul class="tn-list tn-helper-reset spb-events-list">
         <% 
            Dictionary<int, string> eventSiteCategories = ViewData["EventSiteCategories"] as Dictionary<int, string>;
            foreach (EventThread thread in ViewData.Model.Records)
            {
         %>
           <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
               <div class="tn-list-item-area-left"> <%=SPBHtmlHelper.Instance().ShowEventLogo(thread, true, "_blank", EventPhotoTypes.Thumbnail)%></div>
               <div class="tn-list-item-area-main">
                            <div class="tn-list-item-row tn-list-item-heading">
                              <h5 class="tn-helper-reset"><a target="_blank" href="<%=SiteUrls.Instance().ShowEvent(thread.EventID) %>" title="<%=thread.EventName %>"> <%=thread.EventName %></a><cite class="tn-category">【<% if (eventSiteCategories != null&& !string.IsNullOrEmpty(eventSiteCategories[thread.EventID]) )  %>
                               <a target="_blank" href="<%=SPBUrlHelper.Action("Search", "ChannelEvent", new RouteValueDictionary { { "siteCategoryID", thread.SiteCategoryID }, { "areaCode", null } })%>" title="<%=string.Format(GetResourceString("Description_Pattern_CheckAllEvent", EventApplicationID),eventSiteCategories[thread.EventID]) %>"> <%=eventSiteCategories[thread.EventID]%></a></cite>】</h5>
                            </div>
                            <div class="tn-list-item-row">
                              <div class="tn-info-part">
                                <dl>
                                  <dt class="tn-text-note"><%=GetResourceString("Label_Time",EventApplicationID)%><%=GetResourceString("Common_Colon")%></dt>
                                  <dd><span class="tn-date"><%=EventDateFormatter.FormatDate(thread.StartTime,thread.EndTime,false)%></span></dd>
                                </dl>
                                <dl>
                                  <dt class="tn-text-note"><%=GetResourceString("Label_Place", EventApplicationID)%><%=GetResourceString("Common_Colon")%></dt>
                                  <dd><a class="tn-location" href="<%=SiteUrls.Instance().ListEventsByAreaCode(thread.AreaCode) %>"><%=Formatter.FormatArea(thread.AreaCode,1,2)%></a> <%=Formatter.FormatArea(thread.AreaCode,false)%></dd>
                                </dl>
                                <dl>
                                  <dt class="tn-text-note"><%=GetResourceString("Label_ReleaseUser", EventApplicationID)%><%=GetResourceString("Common_Colon")%></dt>
                                  <dd><a href="<%=SiteUrls.Instance().UserChannelHome(thread.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>" title="<%=string.Format(GetResourceString("Description_Pattern_ViewUserDomain"),thread.Sponsor) %>"> <%=thread.Sponsor %></a></dd>
                                </dl>
                              </div>
                            </div>
                            <div class="tn-list-item-row spb-event-count"> <span class="tn-action"><span class="tn-action-text"><%=thread.HitTimes %><%= GetResourceString("Label_Scan",EventApplicationID)%></span> </span><span class="tn-action"><span class="tn-action-text"><%=thread.MemberCount %><%=GetResourceString("Label_Attend",EventApplicationID)%></span> </span><span class="tn-action"><span class="tn-action-text"><%=thread.FaviteCount %><%=GetResourceString("Label_Attention",EventApplicationID)%></span> </span><span class="tn-action"><a class="tn-action-text" href="#"><%=thread.PhotoCount %><%=GetResourceString("Label_Photos", EventApplicationID)%></a> </span><span class="tn-action"><a class="tn-action-text" href="#"><%=thread.PostCount %><%=GetResourceString("Label_Messages", EventApplicationID)%></a> </span> </div>
                 </div>
           </li>
          <%} %>           
      </ul>
        <div class="tn-pagination tn-helper-align-center"> <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11,
             SPBUrlHelper.Action("Control_ListMyFriendCreateEvents", "UserDomainEvent", new RouteValueDictionary { { "userDomainName", Html.GetParameterFromRouteDateOrQueryString("UserDomainName") }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
             <div class="tn-page-results tn-text-note"><%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
        </div>
      <%}  
         %>
  </div>
</div>
 <script type="text/javascript">
     function pageIndexChange(url) {
         $('#ListMyEvents').load(url);
     }
</script>
