﻿<%@ Control Language="C#"  Inherits="SpaceBuilder.Web.SPBViewUserControl" %>

<% List<UserCategory> userCategories = (List<UserCategory>)ViewData.Model;
   int currentCategoryID = ViewData.GetInt("currentCategoryID",0);
   if (currentCategoryID == 0)
   {
       currentCategoryID = TempData.GetInt("selectedCategoryID", 0);
   }
        string cssClass = ViewData.GetString("cssClass",string.Empty);
   string controlName = ViewData.GetString("controlName", "galleryCategoryDropdownList"); %>
<span id="fileUserCategoryDropdownListDiv">
<% if(userCategories!=null && userCategories.Count>0) { %>
<select name="<%=controlName %>" id="<%=controlName %>" class=<%=cssClass %>>
  <option value="0"><%=GetResourceString("Common_PleaseChoose")%></option>
    <% foreach (UserCategory userCategory in userCategories)
       {%>
        <option <% if (userCategory.CategoryID == currentCategoryID) Response.Write(" selected=\"selected\" "); %> value="<%=userCategory.CategoryID %>">
          <%=userCategory.CategoryName %>
        </option>
   <% } %>
</select>
<% TempData.Remove("currentCategoryIDInDropDownlist");
   } %>
<% string currentUserDomainName=Html.GetParameterFromRouteDateOrQueryString("userDomainName");  %>
<a href="<%=SPBUrlHelper.Action("Control_EditUserCategory", "UserDomain", new RouteValueDictionary { { "userDomainName", currentUserDomainName }, { "userCategoryItemKey", UserCategoryItemKeys.Instance().File() } })%>" id="newfileUserCategoryDropdownListDivCategoyModelIn" ><%=GetResourceString("Action_NewFolder",ApplicationIDs.Instance().File())%></a>

<script type="text/javascript">

$(document).ready(function() {
    $('#newfileUserCategoryDropdownListDivCategoyModelIn').nyroModal({
        resizeable: true,
        endRemove: function(elts, settings) {
            $('#fileUserCategoryDropdownListDiv').load('<%=SPBUrlHelper.Action("Control_FileCategoryDropdownList","File",new RouteValueDictionary{{"userDomainName",currentUserDomainName},{"controlName",controlName},{"cssClass",cssClass}}) %>');
        }
    });
    })
    
</script>
</span>