﻿<%@ Control Language="C#"  Inherits="SpaceBuilder.Web.SPBViewUserControl<List<UserCategory>>" %>
<% string userDomainName = (string)ViewData["userDomainName"];
   bool isManager = (bool)ViewData["isManager"]; %>
<% List<UserCategory> userCategories = (List<UserCategory>)ViewData.Model; %>

<div id="userCategoryList">
 <div class="tn-box tn-widget tn-widget-content tn-corner-all">
        <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
            <span class="tn-helper-right">
               <% if (isManager)
             { %>
           <a  href="<%=SPBUrlHelper.Action("ManageFileCategories","File",new RouteValueDictionary{{"userDomainName",userDomainName},{"pageIndex",0}}) %>"> <%=GetResourceString("Action_Manage")%></a>
          <%} %></span>
            <h3 class="tn-helper-reset">
                文件夹</h3>
        </div>
        <div class="tn-box-content tn-widget-content tn-corner-bottom">
            <ul class="tn-helper-reset tn-list">
                <% if (userCategories != null)
                       {
                           foreach (UserCategory userCategory in userCategories)
                           {  %>
                <li>
                    <a href="<%=SPBUrlHelper.Action("ListFilesByUserCategory","File",new RouteValueDictionary{{"userDomainName",userDomainName},{"categoryID",userCategory.CategoryID},{"pageIndex",0}}) %>" title="<%=string.Format(GetResourceString("Description_Pattern_SeeCategoryFile",ApplicationIDs.Instance().File()),userCategory.CategoryName,userCategory.ItemCount) %>"> <%=userCategory.CategoryName%></a><em class="tn-text-note">(<%=userCategory.ItemCount%>)</em>
                </li>
                <%}
                       } %>
                       </ul>
                <% if (isManager)
                   {%>
                   <div class="tn-blank10"></div>
             <%=SPBHtmlHelper.Instance().LinkButton("newCategoryModalBlock", "新建文件夹", SPBUrlHelper.Action("Control_EditUserCategory", "UserDomain", new RouteValueDictionary { { "userDomainName", userDomainName }, { "userCategoryItemKey", UserCategoryItemKeys.Instance().File() } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText)%>
                <%} %>
        </div>
    </div>
  <script type="text/javascript">
    $(document).ready(function() {
        $('#newCategoryModalBlock').nyroModal({
            resizeable: true,
            height: 300,
            width: 400,
            endRemove: function(elts, settings) {
                $('#userCategoryList').load('<%=SPBUrlHelper.Action("Control_ListFileUserCategories","File",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>');
            }
        });
        })
  </script>
</div>
<div class="tn-blank10"> </div>
                           