﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<FileThread>>" %>
<spb:Script runat="server" ID="jquery_form" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
    SetExpireDays="30" />
<div id="manageFilesDiv">
    <div class="tn-box tn-widget tn-widget-content tn-corner-all">
        <% string title = HtmlUtils.TrimHtml(ViewData.GetString("title", GetResourceString("Title_FileList", ApplicationIDs.Instance().File())), 30);
        %>
        <%if (!string.IsNullOrEmpty(title))
          {%>
        <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
            <h3 class="tn-helper-reset">
                <%=title%></h3>
        </div>
        <%} %>
        <div class="tn-box-content tn-widget-content tn-corner-all">
            <%
                PagingDataSet<FileThread> files = (PagingDataSet<FileThread>)ViewData.Model;
                string summaryUrl = ViewData.GetString("summaryUrl", string.Empty);
                string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
                int categoryID = ViewData.GetInt("categoryID", 0);
                int currentDomainUserID = ViewData.GetInt("currentDomainUserID", 0);
                bool isManager = ViewData.GetBool("isManager", false);
                string tagName = ViewData.GetString("tagName", string.Empty);
                int returnToPageIndex = ViewData.Model.PageIndex;
                if (ViewData.Model.TotalRecords == ViewData.Model.PageSize * (returnToPageIndex - 1) + 1)
                {
                    returnToPageIndex = ViewData.Model.PageIndex - 1;
                }
            %>
            <div class="tn-list-header">
                <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
                    <span class="tn-helper-right">
                        <%=GetResourceString("Label_Display")%><%=GetResourceString("Common_Colon") %>
                        <span class="tn-action tn-action-text-icon">
                            <%=SPBHtmlHelper.Instance().Icon(IconTypes.BrowseDetail) %>
                            <a href="javascript:;" class="tn-action-text" id="actionSummary">
                                <%=GetResourceString("Action_Summary")%></a></span> <span class="tn-action tn-action-text-icon tn-text-note tn-selected">
                                    <%=SPBHtmlHelper.Instance().Icon(IconTypes.BrowseList) %><a href="javascript:;" class="tn-action-text">
                                        <%=GetResourceString("Action_List")%></a></span></span>
                </div>
            </div>
            <div id="loading" style="display: none" class=" tn-loading">
            </div>
            <table class="tn-table-grid">
                <tr class="tn-table-grid-header">
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        <%=GetResourceString("Label_FileName",ApplicationIDs.Instance().File())%>
                    </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        <%=GetResourceString("Label_FileSize",ApplicationIDs.Instance().File())%>
                    </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        <%=GetResourceString("Label_PostDate")%>
                    </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        <%=GetResourceString("Label_DownLoadNum",ApplicationIDs.Instance().File())%>
                    </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        <%=GetResourceString("Label_Actions")%>
                    </th>
                </tr>
                <%foreach (FileThread file in files.Records)
                  { %>
                <tr class="tn-table-grid-row">
                    <td class="tn-border-gray tn-border-bottom tn-width-auto">
                        <%=SPBHtmlHelper.Instance().ContentTypeThumbnail(file.FileName, ContentTypeThumbnailSize.Small) %>
                        &nbsp; <a target="_blank" href="<%=SiteUrls.Instance().ShowFile(file.ThreadID) %>"
                            title="<%=file.Subject %>">
                            <% if (string.IsNullOrEmpty(file.Subject))
                                   Response.Write(HtmlUtils.TrimHtml(file.FileName, 23));
                               else
                                   Response.Write(HtmlUtils.TrimHtml(file.Subject, 23));  %>
                        </a>
                        <% if (file.UserCategory != null)
                           { %>
                        <a href="<%=SPBUrlHelper.Action("ListFilesByUserCategory", "File", new RouteValueDictionary { { "userDomainName", Html.GetParameterFromRouteDateOrQueryString("UserDomainName") }, { "categoryID", file.UserCategoryID } })%>">
                            【<%=HtmlUtils.TrimHtml(file.UserCategory.CategoryName,11)%>】</a>
                        <%} %>
                        <%
                            switch (file.PrivacyStatus)
                            {
                                case PrivacyStatuses.NeedPassword:
                        %>
                        <%=SPBHtmlHelper.Instance().Icon(IconTypes.Key, GetResourceString("Enum_PrivacyStatuses_NeedPassword"), new RouteValueDictionary { { "class", "tn-icon-inline" } })%>
                        <%
                            break;
                                case PrivacyStatuses.OnlyFriend:
                        %>
                        <%=SPBHtmlHelper.Instance().Icon(IconTypes.Limit, GetResourceString("Enum_PrivacyStatuses_OnlyFriend"), new RouteValueDictionary { { "class", "tn-icon-inline" } })%>
                        <%
                            break;
                                case PrivacyStatuses.Privacy:
                        %>
                        <%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, GetResourceString("Enum_PrivacyStatuses_Privacy"), new RouteValueDictionary { { "class", "tn-icon-inline" } })%>
                        <%
                            break;
                            case PrivacyStatuses.Public:
                            break;
                            default:
                            break;
                            } %>
                        <%if (file.Price > 0)
                          { %>
                        <em class="tn-text-note">
                            <%=SPBHtmlHelper.Instance().Icon(IconTypes.Coins) %><%=file.Price %>
                        </em>
                        <%} %>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                        <%=file.Attachment.Friendlylength%>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
                        <%=Formatter.FormatDate(file.PostDate,false) %>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                        <%=file.DownloadCount%>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                        <%if (isManager)
                          {%>
                         <span class="tn-action"><a class="tn-action-text" href="<%=SPBUrlHelper.Action("EditFile", "File", new RouteValueDictionary { { "userDomainName",WebUtils.UrlEncode(Html.GetParameterFromRouteDateOrQueryString("UserDomainName")) }, { "threadID", file.ThreadID } })%>">
                            <%=GetResourceString("Action_Edit")%>
                        </a></span><span class="tn-action"><a class="tn-action-text" onclick=" if (confirm('<%=GetResourceString("Message_DeleteFile",ApplicationIDs.Instance().File()) %>')) { $('#manageFilesDiv').parent().load('<%=SPBUrlHelper.Action("DeleteFile","File",new RouteValueDictionary{{"ThreadID",file.ThreadID},{"userDomainName",userDomainName},{"categoryID",categoryID},{"tagName",tagName},{"pageIndex",returnToPageIndex},{"inShowFile",false},{"isSummaryFiles",false}}) %>' )}"
                            href="javascript:;">
                            <%=GetResourceString("Action_Delete")%></a> </span><span class="tn-action"><a class="tn-action-text"
                                href="<%=SiteUrls.Instance().ShowFile(file.ThreadID) %>">
                                <%=GetResourceString("Label_DownLoad",ApplicationIDs.Instance().File())%></a></span>
                        <%} else{%>
                         <span class="tn-action">
                         <a target="_blank" href="<%=SiteUrls.Instance().ShowFile(file.ThreadID) %>" class="tn-action-text">
                                <%=GetResourceString("Label_DownLoad",ApplicationIDs.Instance().File())%></a>
                        
                        
                        </span>
                        <%} %>
                    </td>
                </tr>
                <%} %>
            </table>
            <div class="tn-pagination tn-helper-align-center">
                <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, files.TotalRecords, files.PageSize, files.PageIndex, 7, SPBUrlHelper.Action("Control_ListFiles","File",new RouteValueDictionary{{"userDomainName",userDomainName},{"categoryID",categoryID},{"tagName",WebUtils.UrlEncode(tagName)},{"pageIndex","{0}"}}), "pageIndexChange")%>
            </div>

            <script type="text/javascript">
                $(document).ready(function() {

                    $('.volumeMenu').toggle(function() { $('.volumeMenu').not($(this)).attr('class', 'toolbarItem volumeMenu'); setTopbarItemClass($(this)); }, function() { $('.volumeMenu').not($(this)).attr('class', 'toolbarItem volumeMenu'); setTopbarItemClass($(this)); });

                    $("#actionSummary").click(function() {
                        showLoading();
                        $("#manageFilesDiv").parent().load("<%=summaryUrl %>");
                    });

                })

                function showLoading() {
                    $("#loading").show();
                    $("table.tn-table-grid").hide();
                    $("div.tn-pagination").hide();
                    //            $("#batchControlPanel").hide();
                }

                function setTopbarItemClass(currentLi) {
                    if (currentLi.attr('class') != 'toolbarItem volumeMenu') {
                        currentLi.attr('class', 'toolbarItem volumeMenu');
                    }
                    else {
                        currentLi.attr('class', 'toolbarItem volumeMenu current');
                    }
                }
                function pageIndexChange(url) {
                    $('#manageFilesDiv').parent().load(url);
                }               
            </script>

        </div>
    </div>
</div>
