﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl< PagingDataSet<FileDownLoadRecord>>" %>
<% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   Dictionary<int, FileThread> filesDictionary = ViewData["filesDictionary"] as Dictionary<int, FileThread>;
%>
<div id="manageFilesDiv">
    <div class="tn-box tn-widget tn-widget-content tn-corner-all">
        <div class="tn-box-content tn-widget-content tn-corner-bottom">
            <%if (Model.Records.Count > 0)
              { %>
            <table class="tn-table-grid">
                <tr class="tn-table-grid-header">
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        <%=GetResourceString("Label_FileName", ApplicationIDs.Instance().File())%>
                    </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        <%--<%=GetResourceString("Label_UploadPeople", ApplicationIDs.Instance().File())%>--%>
                    </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        <%=GetResourceString("Label_UploadPeople", ApplicationIDs.Instance().File())%>
                    </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        <%=GetResourceString("Label_FileSize", ApplicationIDs.Instance().File())%>
                    </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                       下载日期
                    </th>
                </tr>
                <%foreach (FileDownLoadRecord fileDownRecord in Model.Records)
                  {  
                %>
                <tr class="tn-table-grid-row">
                    <td class="tn-border-gray tn-border-bottom">
                        <%=SPBHtmlHelper.Instance().ContentTypeThumbnail(filesDictionary[fileDownRecord.ThreadID].FileName, ContentTypeThumbnailSize.Small)%>
                        &nbsp;
                        <% 
                            string fileName = string.Empty;
                            if (string.IsNullOrEmpty(filesDictionary[fileDownRecord.ThreadID].Subject))
                                fileName = filesDictionary[fileDownRecord.ThreadID].FileName;
                            else
                                fileName = filesDictionary[fileDownRecord.ThreadID].Subject;%>
                        <a href="<%=SiteUrls.Instance().ShowFile(fileDownRecord.ThreadID) %>" title="<%=fileName %>">
                            <%=HtmlUtils.TrimHtml(fileName,23) %>
                        </a>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                        <%=SPBHtmlHelper.Instance().Icon(IconTypes.Coins)%><%=fileDownRecord.Price%>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                        <%User user = Users.GetUser(filesDictionary[fileDownRecord.ThreadID].Attachment.UserID, false);
                          if (user != null)
                          {%>
                        <a href="<%=SiteUrls.Instance().UserChannelHome(user.UserID,ApplicationIDs.Instance().File()) %>"
                            title="<%=user.DisplayName %>">
                            <%=SPBHtmlHelper.Instance().UserDisplayName(user) %>
                        </a>
                        <%}%>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                        <%=filesDictionary[fileDownRecord.ThreadID].Attachment.Friendlylength%>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                        <%=Formatter.FormatDate(fileDownRecord.DateCreated,true )%>
                    </td>
                </tr>
                <%} %>
            </table>
            <div class="tn-pagination tn-helper-align-center">
                <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex, 7, SPBUrlHelper.Action("Control_ListFilesByDownload", "File", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
            </div>

            <script type="text/javascript">
                function pageIndexChange(url) {
                    $('#manageFilesDiv').parent().load(url);
                }               
            </script>

            <%}
              else
              {
                  Response.Write(GetResourceString("Message_FileUploadNo", ApplicationIDs.Instance().File()));%>
            <%} %>
        </div>
    </div>
</div>
