﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<FileSection>>" %>
<%int applicationID = ApplicationIDs.Instance().File(); %>
<div id="listFriendsFileThreadsControlDiv">
    <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-files-list">
        <div class="tn-box-content tn-widget-content tn-corner-all">
            <div class="tn-list-header">
                <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
                    <h3 class="tn-helper-reset">
                        <%=GetResourceString("Title_FriendsFile",ApplicationIDs.Instance().File())%></h3>
                </div>
            </div>
            <div>
                <ul class="tn-list tn-helper-reset">
                    <% 
                        if (ViewData.Model != null && ViewData.Model.Records.Count > 0)
                        { %>
                    <%foreach (FileSection fileSection in ViewData.Model.Records)
                      {
                          if (fileSection != null)
                          {
                              FileThread fileThread = FileThreads.GetThread(fileSection.MostRecentThreadID, false);
                              if (fileThread == null)
                                  continue;
                              
                    %>
                    <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
                        <% if (fileThread.UserFeaturedImageAttachmentID > 0)
                           { %>
                        <div class="tn-list-item-area-left">
                            <a href="<%= SiteUrls.Instance().ShowFile(fileThread.ThreadID) %>">
                                <img height="100" width="100" src="<%=SiteUrls.Instance().FileFeaturedImageUrl(fileThread.UserFeaturedImageAttachmentID, FileFeaturedImageTypes.Title)%>"></a></div>
                        <%} %>
                        <div class="tn-list-item-area-main">
                            <div class="tn-list-item-row tn-list-item-heading">
                                <h5 class="tn-helper-reset">
                                    <%=SPBHtmlHelper.Instance().ContentTypeThumbnail(fileThread.FileName, ContentTypeThumbnailSize.Small)%><a
                                        href="<%=SiteUrls.Instance().ShowFile(fileThread.ThreadID) %>">
                                        <%= StringUtils.Trim(fileThread.Subject, 25)%></a>
                                </h5>
                            </div>
                            <div class="tn-list-item-row">
                                <a href="<%=SiteUrls.Instance().UserChannelHome(fileSection.OwnerUserID,applicationID) %>">
                                    <%=fileThread.Author %></a> <em class="tn-text-note tn-count"><%=GetResourceString("Label_UploadFor", applicationID)%><%=GetResourceString("Common_Colon") %><%=Formatter.FormatDate(fileThread.PostDate) %></em>
                                <em class="tn-text-note tn-count">
                                    <%=GetResourceString("Label_Size", applicationID)%><%=GetResourceString("Common_Colon") %><%=fileThread.Attachment.Friendlylength %></em>
                                <em class="tn-text-note tn-count"><%=GetResourceString("Label_DownLoadCount", applicationID)%><%=GetResourceString("Common_Colon") %><%=fileThread.DownloadCount %></em>
                            </div>
                            <div class="tn-list-item-row tn-list-item-summary">
                                <p class="tn-helper-reset">
                                    <%=HtmlUtils.TrimHtml(fileSection.MostRecentThreadSummary,160) %>
                                </p>
                            </div>
                        </div>
                    </li>
                    <%}
                      } %>
                    <%} %>
                </ul>
                <div class="tn-pagination tn-helper-align-center">
                    <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 7, SPBUrlHelper.Action("Control_ListFriendsFileThreads", "File", new RouteValueDictionary { { "userDomainName", Html.GetParameterFromRouteDateOrQueryString("userDomainName") }, { "pageIndex", "{0}" } }), "summaryfriendsFileThreadPageIndexChange")%>
                </div>

                <script type="text/javascript">
                    function summaryfriendsFileThreadPageIndexChange(url) {
                        $('#listFriendsFileThreadsControlDiv').load(url);
                    }
                </script>

            </div>
        </div>
    </div>
</div>
