﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% int pageIndex = 0;
   if (!string.IsNullOrEmpty(Html.GetParameterFromRouteDateOrQueryString("pageIndex")))
       pageIndex = int.Parse(Html.GetParameterFromRouteDateOrQueryString("pageIndex"));
   PagingDataSet<FileComment> comments = (PagingDataSet<FileComment>)ViewData.Model;
   string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   ApprovalStatuses? nowStatus = null;
   if (ViewData["approvalStatus"] != null)
       nowStatus = (ApprovalStatuses)ViewData["approvalStatus"];
   int applicationID = ApplicationIDs.Instance().File();
   int i = 0;
%>
<spb:Script ID="jquery_form" runat="server" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
    SetExpireDays="30" />
<div id="manageFileCommentsDiv">
    <div class="tn-box tn-widget tn-widget-content tn-corner-all">
        <div class="tn-box-content tn-widget-content tn-corner-bottom">
            <form id="manageFileCommentsForm" method="post" action="">
            <div class="tn-filter-controls tn-helper-clearfix tn-border-gray tn-border-bottom">
                <%=SPBHtmlHelper.Instance().LinkButton("buttonApprove", GetResourceString("Button_Approve"), ButtonSizes.Default, HighlightStyles.Default, new RouteValueDictionary { { "onclick", "setBlogStatue('approve')" } }, null)%>
                <%=SPBHtmlHelper.Instance().LinkButton("buttonNoApprove", GetResourceString("Button_NoApprove"), ButtonSizes.Default, HighlightStyles.Default, new RouteValueDictionary { { "onclick", "setBlogStatue('noApprove')" } }, null)%>
                <%=SPBHtmlHelper.Instance().LinkButton("actionDelete", GetResourceString("Action_Delete"), ButtonSizes.Default, HighlightStyles.Default, new RouteValueDictionary { { "onclick", "setBlogStatue('delete')" } }, null)%>
                <% if (ViewData["approvalStatus"] == null)
                   {%>
                <%=SPBHtmlHelper.Instance().ApproveStatusDropDownList("approveDropDownList", null, "tn-dropdownlist", "GetCommentsByApproveStatus()")%>
                <%}
                   else
                   {%>
                <%=SPBHtmlHelper.Instance().ApproveStatusDropDownList("approveDropDownList", (ApprovalStatuses)ViewData["approvalStatus"], "tn-dropdownlist", "GetCommentsByApproveStatus()")%>
                <%} %>
                <div class="tn-blank10">
                </div>
            </div>
            <div class="tn-grid">
                <table class="tn-table-grid">
                    <tr class="tn-table-grid-header">
                        <th class="tn-border-gray tn-border-bottom tn-text-note">
                            <input type="checkbox" id="TopCheckBox" class="tn-checkbox" onclick="checkAll(this,'fileCommentsCheckBoxGroup')" />
                        </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note">
                            <%=GetResourceString("Label_Body")%>
                        </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note">
                            <%=GetResourceString("Label_IfApproval")%>
                        </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note">
                            <%=GetResourceString("Label_CommentUser")%>
                        </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note">
                            <%=GetResourceString("Label_CommentDate") %>
                        </th>
                    </tr>
                    <% foreach (FileComment comment in comments.Records)
                       {
                           i++; %>
                    <tr class="tn-table-grid-row">
                        <td class="tn-border-gray tn-border-bottom tn-width-check">
                            <input type="checkbox" class="tn-checkbox" name="fileCommentsCheckBoxGroup" value="<%=comment.PostID %>" />
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-width-auto">
                            <a href="<%=SiteUrls.Instance().ShowFile(comment.ThreadID)+"#"+comment.PostID.ToString() %>"
                                title="<%=HtmlUtils.StripForPreview(comment.Body) %>">
                                <%=HtmlUtils.TrimHtml(comment.Body,23) %>
                            </a>
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-width-icon1">
                            <% if (comment.IsApproved)
                               { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Accept, GetResourceString("Description_CommentAuditinged"))); }
                               else
                               { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Cross, GetResourceString("Description_CommentNotAuditing"))); }%>
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-width-action1 tn-nowrap">
                            <% if (string.IsNullOrEmpty(comment.TitleUrl)) Response.Write(comment.Author);
                               else
                               {%>
                            <a href="<%=comment.TitleUrl %>">
                                <%=comment.Author%>
                            </a>
                            <%} %>
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
                            <%=Formatter.FormatDate(comment.PostDate,false) %>
                        </td>
                    </tr>
                    <%} %>
                </table>
                <div class="tn-pagination tn-helper-align-center">
                    <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, comments.TotalRecords, comments.PageSize, comments.PageIndex, 7, SPBUrlHelper.Action("Control_ManageFileComments", "File", new RouteValueDictionary { { "userDomainName", userDomainName }, { "approvalStatus", nowStatus }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
                </div>
            </div>
            </form>
        </div>
    </div>

    <script type="text/javascript">
        function setBlogStatue(action) {
            if (action == 'approve')
                $('#manageFileCommentsForm').ajaxSubmit({ target: '#manageFileCommentsDiv', url: '<%=SPBUrlHelper.Action("SetFileCommentsApproveStatus", "File", new RouteValueDictionary { { "userDomainName", userDomainName },{"isApproved",true} })%>' });
            else if (action == 'noApprove')
                $('#manageFileCommentsForm').ajaxSubmit({ target: '#manageFileCommentsDiv', url: '<%=SPBUrlHelper.Action("SetFileCommentsApproveStatus", "File", new RouteValueDictionary { { "userDomainName", userDomainName }, { "isApproved", false } })%>' });
            else if (action == 'delete') {
                if (!confirm('确认删除当前评论？'))
                    return;
                $('#manageFileCommentsForm').ajaxSubmit({ target: '#manageFileCommentsDiv', url: '<%=SPBUrlHelper.Action("DeleteFileComments", "File", new RouteValueDictionary { { "userDomainName", userDomainName } })%>', type: 'post' });
            }
        }
        function GetCommentsByApproveStatus() {
            $('#manageFileCommentsForm').ajaxSubmit({ target: '#manageFileCommentsDiv', url: '<%=SPBUrlHelper.Action("ManageFileCommentsByApprovalStatus","Blog",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>' });
        }
        function pageIndexChange(url) {
            $('#manageFileCommentsDiv').load(url);
        }
    </script>

</div>

<script type="text/javascript">
    function GetCommentsByApproveStatus() {
        $('#manageFileCommentsForm').ajaxSubmit({ target: '#manageFileCommentsDiv', url: '<%=SPBUrlHelper.Action("ManageFileCommentsByApprovalStatus","File",new RouteValueDictionary{{"userDomainName",userDomainName},{"pageIndex",pageIndex}}) %>' });
    }
</script>

