﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<FileThread>>" %>
<spb:Script runat="server" ID="jquery_form" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
    SetExpireDays="30" />
<%int applicationID = ApplicationIDs.Instance().File();
  string summaryUrl = ViewData.GetString("summaryUrl", string.Empty);
  string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
  int categoryID = ViewData.GetInt("categoryID", 0);
  int currentDomainUserID = ViewData.GetInt("currentDomainUserID", 0);
  bool hasPermission = ViewData.GetBool("hasPermission", false);
  string tagName = ViewData.GetString("tagName", string.Empty);
  RouteValueDictionary routeValueDictionary = new RouteValueDictionary { { "userDomainName", userDomainName }, { "pageIndex", Model != null ? Model.PageIndex : 0 } };
  if (Model != null)
  { %>

<div id="manageFilesDiv">
  <div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <form id="manageFileThreadsForm" name="manageFileThreadsForm" method="post" action="">
        <div class="tn-list-header">
          <% if (hasPermission)
                       {
                           ICollection<UserTag> userTags = ViewData.Get<ICollection<UserTag>>("userTags", null);
                           List<UserCategory> userCategoryList = ViewData.Get<List<UserCategory>>("userCategoryList", new List<UserCategory>());
                           List<SiteCategory> allSiteCategoryList = ViewData.Get<List<SiteCategory>>("allSiteCategoryList", new List<SiteCategory>());%>
          <div class="tn-toolbar tn-helper-clearfix">
            <div class="tn-tool-form">
              <input id="TopCheckBox" class="tn-checkbox" type="checkbox" onclick="checkAll(this,'ThreadCheckBoxGroup');" />
              <label for="TopCheckBox" class="tn-check-all"> <%=GetResourceString("Label_SelectAllOrNo") %></label>
              <%=SPBHtmlHelper.Instance().LinkButton("deleteButton", GetResourceString("Button_BatchDelete"), "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary { { "onclick", "if(confirm('" + GetResourceString("Message_DeleteSelectFiles", applicationID) + "')){ ajaxSubmitTheForm('delete'); }" } }, null)%> <%=SPBHtmlHelper.Instance().Button("permissionSettings", GetResourceString("Title_PermissionsSettings"), ButtonSizes.Default, HighlightStyles.Default, IconTypes.TriangleDown, TextIconLayout.MenuButton,null, new RouteValueDictionary { { "menu", "#privacyControl" } })%>
              <div id="privacyControl" class="tn-menu-button-position tn-menu tn-helper-reset tn-widget-content">
                <ul>
                  <li class="tn-menu-item"><a class="tn-menu-text" href="javascript:;" onclick="$('#manageFileThreadsForm').ajaxSubmit({ target: '#manageFilesDiv', url: '<%=SPBUrlHelper.Action("SetFileThreadsPrivacyStatus","File",new RouteValueDictionary(routeValueDictionary){{ "setFileThreadsPirvacyStatus",(int)PrivacyStatuses.Public }}) %>' });"> <%=GetResourceString("Enum_PrivacyStatuses_Public") %></a></li>
                  <li class="tn-menu-item"><a class="tn-menu-text" href="javascript:;" onclick="$('#manageFileThreadsForm').ajaxSubmit({ target: '#manageFilesDiv', url: '<%=SPBUrlHelper.Action("SetFileThreadsPrivacyStatus","File",new RouteValueDictionary(routeValueDictionary){{ "setFileThreadsPirvacyStatus",(int)PrivacyStatuses.OnlyFriend }}) %>' });"> <%=GetResourceString("Enum_PrivacyStatuses_OnlyFriend") %></a></li>
                  <li class="tn-menu-item"><a id="editPassWord" class="tn-menu-text" href="javascript:;"> <%=GetResourceString("Enum_PrivacyStatuses_NeedPassword") %></a></li>
                  <li class="tn-menu-item"><a class="tn-menu-text" href="javascript:;" onclick="$('#manageFileThreadsForm').ajaxSubmit({ target: '#manageFilesDiv', url: '<%=SPBUrlHelper.Action("SetFileThreadsPrivacyStatus","File",new RouteValueDictionary(routeValueDictionary){{ "setFileThreadsPirvacyStatus",(int)PrivacyStatuses.Privacy }}) %>' });"> <%=GetResourceString("Enum_PrivacyStatuses_Privacy")%></a></li>
                </ul>
              </div>
              <%=SPBHtmlHelper.Instance().Button(string.Empty, GetResourceString("Title_StickTags"), ButtonSizes.Default, HighlightStyles.Default, IconTypes.TriangleDown, TextIconLayout.MenuButton,null, new RouteValueDictionary { { "menu", "#userTagControl" } })%>
              <div id="userTagControl" class="tn-menu-button-position tn-menu tn-helper-reset tn-widget-content">
                <ul class="tn-menu-list">
                  <%foreach (UserTag tag in userTags)
                                      {%>
                  <li class="tn-menu-item">
                    <input class="tn-checkbox" name="setUserTags" id="setUserTags<%=tag.TagName%>" type="checkbox"
                                            value="<%=tag.TagName%>" />
                    <label for="setUserTags<%=tag.TagName%>"> <%=tag.TagName %></label>
                  </li>
                  <%} %>
                </ul>
                <div class="tn-menu-add tn-border-light tn-border-top"> <a class="tn-helper-right" href="javascript:;" onclick="stickTags()"> <%=GetResourceString("Button_Save")%></a> <a class="editUserTag" href="javascript:;"> <%=GetResourceString("Action_CreatTag")%></a></div>
                <script type="text/javascript">

                                    function stickTags() {
                                        var usertags = "";
                                        $("input[type='checkbox'][name='setUserTags']").each(function(index, e) {
                                            if (e.checked) {
                                                if (usertags == "") {
                                                    usertags = e.value;
                                                } else {
                                                    usertags = usertags + "," + e.value;
                                                }
                                            }

                                        });

                                        $('#manageFileThreadsForm').ajaxSubmit({ data: { setUserTagss: usertags }, target: '#manageFilesDiv', url: '<%=SPBUrlHelper.Action("SetFileThreadsTags","File",new RouteValueDictionary(routeValueDictionary){{"tagName",tagName}}) %>' });

                                    };
                                </script>
              </div>
              <%=SPBHtmlHelper.Instance().Button(string.Empty, GetResourceString("Action_ToMyFolder",applicationID), ButtonSizes.Default, HighlightStyles.Default, IconTypes.TriangleDown, TextIconLayout.MenuButton, null, new RouteValueDictionary { { "menu", "#userCategoryControl" } })%>
              <div id="userCategoryControl" class="tn-menu-button-position tn-menu tn-helper-reset tn-widget-content">
                <ul class="tn-menu-list">
                  <%foreach (UserCategory category in userCategoryList)
                                      {
                                    %>
                  <li class="tn-menu-item"><a class="tn-menu-text" href="javascript:;" onclick="$('#manageFileThreadsForm').ajaxSubmit({ target: '#manageFilesDiv', url: '<%=SPBUrlHelper.Action("SetFileThreadsUserCategory","File",new RouteValueDictionary(routeValueDictionary){{"userCategoryID",category.CategoryID}}) %>' });"> <%=category.CategoryName%></a></li>
                  <%} %>
                </ul>
              </div>
              <%=SPBHtmlHelper.Instance().Button(string.Empty, GetResourceString("Title_ReturnToSiteCategory"), ButtonSizes.Default, HighlightStyles.Default, IconTypes.TriangleDown, TextIconLayout.MenuButton,null, new RouteValueDictionary { { "menu", "#siteCategoryControl" } })%>
              <div id="siteCategoryControl" class="tn-menu-button-position tn-menu tn-helper-reset tn-widget-content">
                <ul class="tn-menu-list">
                  <%foreach (SiteCategory siteCategory in allSiteCategoryList)
                                      {%>
                  <li class="tn-menu-item"><a class="tn-menu-text" href="javascript:;" onclick="$('#manageFileThreadsForm').ajaxSubmit({ target: '#manageFilesDiv', url: '<%=SPBUrlHelper.Action("SetFileThreadsSiteCategory","File",new RouteValueDictionary(routeValueDictionary){{"siteCategoryID",siteCategory.CategoryID}}) %>' });">
                    <%string blankSpace = string.Empty; %>
                    <% 
                                            for (int i = 0; i < siteCategory.Depth; i++)
                                            {
                                                blankSpace = blankSpace + "　";
                                            }
                                            Response.Write(blankSpace);
                                        %>
                    <%=siteCategory.GetMultilingualCategoryName(CurrentUserLanguage)%> </a></li>
                  <%} %>
                </ul>
              </div>
            </div>
          </div>
          <%} %>
        </div>
        <table class="tn-table-grid">
          <tr class="tn-table-grid-header">
            <th class="tn-border-gray tn-border-bottom tn-text-note"> </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_FileName",applicationID)%> </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_Folder", applicationID)%> </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_SiteDivisionCategory")%> </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_Privacy", applicationID)%> </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_PostDate")%> </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_Actions")%> </th>
          </tr>
          <%foreach (FileThread file in Model.Records)
                      {%>
          <tr class="tn-table-grid-row">
            <td class="tn-border-gray tn-border-bottom"><input type="checkbox" name="ThreadCheckBoxGroup" value="<%=file.ThreadID %>" class="tn-checkbox thrdadsCheckBoxIDs" /></td>
            <td class="tn-border-gray tn-border-bottom"><%=SPBHtmlHelper.Instance().ContentTypeThumbnail(file.FileName, ContentTypeThumbnailSize.Small) %> <a href="<%=SPBUrlHelper.Action("ShowFile","ChannelFile",new RouteValueDictionary{{"threadID",file.ThreadID}}) %>"
                                title="<%=file.Subject %>">
              <% if (string.IsNullOrEmpty(file.Subject))
                                       Response.Write(HtmlUtils.TrimHtml(file.FileName, 23));
                                   else
                                       Response.Write(HtmlUtils.TrimHtml(file.Subject, 23));  %>
              </a></td>
            <td class="tn-border-gray tn-border-bottom"><% if (file.UserCategory != null)
                               { %>
              <a href="<%=SPBUrlHelper.Action("ListFilesByUserCategory", "File", new RouteValueDictionary { { "userDomainName", Html.GetParameterFromRouteDateOrQueryString("UserDomainName") }, { "categoryID", file.UserCategoryID } })%>"> <%=HtmlUtils.TrimHtml(file.UserCategory.CategoryName,11)%></a>
              <%} %></td>
            <td class="tn-border-gray tn-border-bottom"><% if (file.SiteCategory != null)
                               { %>
              <a href="<%=SPBUrlHelper.Action("Search", "ChannelFile", new RouteValueDictionary { { "SiteCategoryID", file.SiteCategoryID } })%>"> <%=file.SiteCategory.CategoryName%></a>
              <%} %></td>
            <td class="tn-border-gray tn-border-bottom"><%switch (file.PrivacyStatus)
                              {
                                  case PrivacyStatuses.NeedPassword:
                                      Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Key, GetResourceString("Enum_PrivacyStatuses_NeedPassword")));
                                      break;
                                  case PrivacyStatuses.OnlyFriend:
                                      Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Limit, GetResourceString("Enum_PrivacyStatuses_OnlyFriend")));
                                      break;
                                  case PrivacyStatuses.Privacy:
                                      Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Lock, GetResourceString("Enum_PrivacyStatuses_Privacy")));
                                      break;
                                  case PrivacyStatuses.Public:
                                      break;
                                  default:
                                      break;
                              } %></td>
            <td class="tn-border-gray tn-border-bottom"><label> <%=Formatter.FormatDate(file.PostDate,false) %></label></td>
            <td class="tn-border-gray tn-border-bottom"><a target="_blank" href="<%=SPBUrlHelper.Action("EditFile", "File", new RouteValueDictionary { { "userDomainName",WebUtils.UrlEncode(Html.GetParameterFromRouteDateOrQueryString("UserDomainName")) }, { "threadID", file.ThreadID } })%>"> <%=GetResourceString("Action_Edit")%> </a></td>
          </tr>
          <%} %>
        </table>
      </form>
      <div class="tn-pagination tn-helper-align-center"> <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex, 7, SPBUrlHelper.Action("Control_ManageFileThreads", "File", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pageIndex", "{0}" } }), "pageIndexChange")%> </div>
    </div>
    <script type="text/javascript">
                $(document).ready(function() {
                    $('#editPassWord').click(function(e) {
                        e.preventDefault();
                        $.nyroModalManual({
                            modal: false,
                            width: 300,
                            height: 200,
                            url: '<%=SPBUrlHelper.Action("Control_EditPassWord", "File", new RouteValueDictionary { { "userDomainName", userDomainName }}) %>',
                            endRemove: function() { $('#manageFilesDiv').load('<%=SPBUrlHelper.Action("Control_ManageFileThreads","File",new RouteValueDictionary(routeValueDictionary)) %>'); }
                        });
                        return false;
                    });

                    $("div.tn-list-header span[menu]").menuButton({ clickTrigger: true, notTriggerClose: ".tn-menu-list,.tn-menu input" });

                    $('.editUserTag').click(function(e) {
                        e.preventDefault();
                        $.nyroModalManual({
                            modal: false,
                            width: 300,
                            height: 200,
                            url: '<%=SPBUrlHelper.Action("Control_EditUserTag", "UserDomain", new RouteValueDictionary { { "userDomainName", userDomainName }, { "userTagItemKey", UserTagItemKeys.Instance().File() } }) %>',
                            endRemove: function() { $('#ManageBlogThreadsDiv').load('<%=SPBUrlHelper.Action("Control_ManageFileThreads","File",new RouteValueDictionary(routeValueDictionary)) %>'); }

                        });
                        return false;
                    });
                })
                function pageIndexChange(url) {
                    $('#manageFilesDiv').parent().load(url);
                }

                function ajaxSubmitTheForm(action) {
                    if (action == 'delete') {
                        $('#manageFileThreadsForm').ajaxSubmit({ target: '#manageFilesDiv', url: '<%=SPBUrlHelper.Action("DeleteFileThreads","File",new RouteValueDictionary(routeValueDictionary)) %>' });
                    }
                }
            </script>
    <%} %>
  </div>
</div>
