﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   FileUserDomainSubMenus? subMenu = null;
   if (ViewData["FileUserDomainSubMenu"] != null)
       subMenu = (FileUserDomainSubMenus)ViewData["FileUserDomainSubMenu"];
   User currentDomainUser = Users.GetUser(userDomainName, false);

   bool isOwner = false;
   int applicationID = ApplicationIDs.Instance().File();
   if (CurrentUser != null && (CurrentUser.UserID == currentDomainUser.UserID || CurrentUser.IsContentAdministrator))
       isOwner = true;
                   
%>
<%if (isOwner)
  {%>
<div class="spb-nav2-area">
    <div class="tn-wrapper-inner tn-helper-clearfix">
        <ul class="spb-nav2 tn-helper-reset tn-helper-left">
            <li <% if(subMenu!=null && subMenu== FileUserDomainSubMenus.myFile) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("Home","File",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <span>
                        <%if (isOwner) Response.Write(GetResourceString("Title_MyFile", ApplicationIDs.Instance().File()));
                          else
                          {
                              if (currentDomainUser.UserType == UserTypes.PersonUser)
                              {
                                  PersonUser currentPersonUser = currentDomainUser as PersonUser;
                                  if (currentPersonUser != null)
                                  {
                                      if (currentPersonUser.Gender == Genders.Female)
                                          Response.Write(GetResourceString("Title_HerFile", ApplicationIDs.Instance().File()));
                                      else
                                          Response.Write(GetResourceString("Title_HisFile", ApplicationIDs.Instance().File()));
                                  }

                              }
                          }; %>
                    </span></a></li>
            <li <% if(subMenu!=null && subMenu== FileUserDomainSubMenus.downloadFile) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("DownloadFiles","File",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <span>
                        <%if (isOwner) Response.Write(GetResourceString("Title_MyDownLoadFile", ApplicationIDs.Instance().File()));
                          else
                          {
                              if (currentDomainUser.UserType == UserTypes.PersonUser)
                              {
                                  PersonUser currentPersonUser = currentDomainUser as PersonUser;
                                  if (currentPersonUser != null)
                                  {
                                      if (currentPersonUser.Gender == Genders.Female)
                                          Response.Write(GetResourceString("Title_HerDownLoadFile", ApplicationIDs.Instance().File()));
                                      else
                                          Response.Write(GetResourceString("Title_HisDownLoadFile", ApplicationIDs.Instance().File()));
                                  }

                              }
                          }; %>
                    </span></a></li>
            <%
                if (currentDomainUser.UserType == UserTypes.PersonUser && (isOwner || CurrentUser.IsContentAdministrator))
                {%>
            <li <% if(subMenu!=null && subMenu== FileUserDomainSubMenus.friendFile) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("ListFriendsFileThreads","File",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <span>
                        <%=GetResourceString("Title_FriendsFile",ApplicationIDs.Instance().File())%>
                    </span></a></li>
            <%} %>
            <li <% if(subMenu!=null && subMenu== FileUserDomainSubMenus.siteFile) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SiteUrls.Instance().ChannelFileHome()  %>" target="_blank"><span>
                    <%=GetResourceString("Action_OthersFile", ApplicationIDs.Instance().File())%>
                </span></a></li>
        </ul>
        <div class="tn-helper-right">
            <%=SPBHtmlHelper.Instance().LinkButton("fileManage", GetResourceString("Title_FilesManage", applicationID),SPBUrlHelper.Action("ManageFileThreads", "File", new RouteValueDictionary { { "userDomainName", userDomainName } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.TriangleDown, TextIconLayout.MenuButton,null, new RouteValueDictionary { { "menu", "#manage" }, { "class", "tn-menu-button-active" } })%>
            <ul id="manage" class="tn-menu-button-position tn-menu tn-menu-text-icon tn-helper-reset tn-widget-content">
                <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageFileThreads", "File", new RouteValueDictionary { { "userDomainName", userDomainName } })%>">
                    <%=GetResourceString("Title_FilesManage", applicationID)%></a></li>
                <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageFileComments","File",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <%=GetResourceString("Action_CommentManage")%></a></li>
                <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageFileUserTags", "File", new RouteValueDictionary { {"userDomainName",userDomainName}})%>">
                    <%=GetResourceString("Action_TagManage")%></a></li>
                <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageFileCategories", "File", new RouteValueDictionary { { "userDomainName", userDomainName } })%>">
                    <%=GetResourceString("Action_ManageFolder",applicationID)%></a></li>
            </ul>
            <%=SPBHtmlHelper.Instance().LinkButton("newFileThreadLink", GetResourceString("Label_UploadFile", ApplicationIDs.Instance().File()), SPBUrlHelper.Action("UploadFiles", "File", new RouteValueDictionary { { "userDomainName",WebUtils.UrlEncode(userDomainName) } }), ButtonSizes.Default, HighlightStyles.Primary, IconTypes.Write, TextIconLayout.IconText)%>
        </div>
    </div>

    <script type="text/javascript">
        $(document).ready(function() {
            $("[menu]", $(".spb-nav2-area")).menuButton();
        });
    </script>

</div>
<%} %>