﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<FileThread>>" %>
<spb:Script runat="server" ID="jquery_ui_stars" Src="~/Utility/jquery/plugin/jquery.ui.stars-3.0.1.js"
    SetExpireDays="30" />
<div id="listFileThreadsDiv">
    <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-files-list">
        <% string title = HtmlUtils.TrimHtml(ViewData.GetString("title", string.Empty), 30);%>
        <%if (!string.IsNullOrEmpty(title))
          {%>
        <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
            <h3 class="tn-helper-reset">
                <%=WebUtils.UrlDecode(title)%></h3>
        </div>
        <%} %>
        <div class="tn-box-content tn-widget-content tn-corner-all">
            <%         
                PagingDataSet<FileThread> fileThreads = (PagingDataSet<FileThread>)ViewData.Model;
                string tagName = ViewData.GetString("tagName", string.Empty);
                int userCategoryID = ViewData.GetInt("userCategoryID", 0);
                bool isManager = ViewData.GetBool("isManager", false);
                string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
                bool isFriend = ViewData.GetBool("isFriend", false);
                int currentDomainUserID = ViewData.GetInt("currentDomainUserID", 0);
                string listFilesUrl = ViewData.GetString("listFilesUrl", string.Empty);
                int returnToPageIndex = ViewData.Model.PageIndex;
                if (ViewData.Model.TotalRecords == ViewData.Model.PageSize * (returnToPageIndex - 1) + 1)
                {
                    returnToPageIndex = ViewData.Model.PageIndex - 1;
                }
            %>
            <div class="tn-list-header">
                <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
                    <span class="tn-helper-right">
                        <%=GetResourceString("Label_Display")%><%=GetResourceString("Common_Colon") %>
                        <span class="tn-action tn-action-text-icon tn-text-note tn-selected">
                            <%=SPBHtmlHelper.Instance().Icon(IconTypes.BrowseDetail) %>
                            <a href="javascript:;" class="tn-action-text">
                                <%=GetResourceString("Action_Summary")%></a></span> <span class="tn-action tn-action-text-icon">
                                    <%=SPBHtmlHelper.Instance().Icon(IconTypes.BrowseList) %><a href="javascript:;" class="tn-action-text"
                                        id="actionList">
                                        <%=GetResourceString("Action_List")%></a></span></span>
                </div>
            </div>
            <div id="loading" style="display: none" class="tn-loading">
            </div>
            <ul class="tn-list tn-helper-reset" id="listBlogThreads">
                <%foreach (FileThread file in fileThreads.Records)
                  { %>
                <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
                    <% if (file.UserFeaturedImageAttachmentID > 0)
                       { %>
                    <div class="tn-list-item-area-left">
                        <a target="_blank" href="<%=SiteUrls.Instance().ShowFile(file.ThreadID) %>">
                            <img src="<%=SiteUrls.Instance().FileFeaturedImageUrl(file.UserFeaturedImageAttachmentID, FileFeaturedImageTypes.Title)%>"></a></div>
                    <%} %>
                    <div class="tn-list-item-area-right">
                        <div class="tn-list-figure tn-widget">
                            <div class="tn-list-figure-count tn-widget-content tn-corner-top">
                                <%=file.DownloadCount%></div>
                            <a target="_blank" href="<%=SiteUrls.Instance().ShowFile(file.ThreadID) %>" class="tn-list-figure-button tn-state-default tn-corner-bottom">
                                <%=GetResourceString("Label_DownLoad",ApplicationIDs.Instance().File())%></a>
                        </div>
                    </div>
                    <div class="tn-list-item-area-main">
                        <div class="tn-list-item-row tn-list-item-heading">
                            <h5 class="tn-helper-reset">
                                <%=SPBHtmlHelper.Instance().ContentTypeThumbnail(file.FileName, ContentTypeThumbnailSize.Small)%>
                                <a target="_blank" href="<%=SiteUrls.Instance().ShowFile(file.ThreadID) %>">
                                    <% if (string.IsNullOrEmpty(file.Subject)) Response.Write(file.FileName); else Response.Write(file.Subject);  %>
                                </a>
                                <% if (file.UserCategory != null)
                                   { %>
                                <a href="<%=SPBUrlHelper.Action("ListFilesByUserCategory", "File", new RouteValueDictionary { { "userDomainName", Html.GetParameterFromRouteDateOrQueryString("UserDomainName") }, { "categoryID", file.UserCategoryID } })%>">
                                    【<%=HtmlUtils.TrimHtml(file.UserCategory.CategoryName,11)%>】</a>
                                <%} %>
                                <% if (file.SpecialOrder > 0)
                                   {%>
                                <%=SPBHtmlHelper.Instance().Icon(IconTypes.Top, GetResourceString("Common_SetTop"), new RouteValueDictionary { { "class", "tn-icon-inline" } })%>
                                <%} %>
                                <%if (file.IsEssential)
                                  {%>
                                <%=SPBHtmlHelper.Instance().Icon(IconTypes.Elite, GetResourceString("Common_Essential"),new RouteValueDictionary {{"class","tn-icon-inline"}})%>
                                <%} %>
                                <% if (isManager || file.PrivacyStatus == PrivacyStatuses.Public)
                                   {%>
                                <%
                                    switch (file.PrivacyStatus)
                                    {
                                        case PrivacyStatuses.NeedPassword:
                                %>
                                <%=SPBHtmlHelper.Instance().Icon(IconTypes.Key, GetResourceString("Enum_PrivacyStatuses_NeedPassword"), new RouteValueDictionary {{"class","tn-icon-inline"} })%>
                                <%
                                    break;
                                        case PrivacyStatuses.OnlyFriend:
                                %>
                                <%=SPBHtmlHelper.Instance().Icon(IconTypes.Limit, GetResourceString("Enum_PrivacyStatuses_OnlyFriend"), new RouteValueDictionary { { "class", "tn-icon-inline" } })%>
                                <%
                                    break;
                                        case PrivacyStatuses.Privacy:
                                %>
                                <%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, GetResourceString("Enum_PrivacyStatuses_Privacy"), new RouteValueDictionary {{"class","tn-icon-inline"} })%>
                                <%
                                    break;
                                    case PrivacyStatuses.Public:
                                %>
                                <%
                                    break;
                                    default:
                                    break;
                                    }
                                   } %>
                            </h5>
                        </div>
                        <div class="tn-list-item-row">
                            <%if (file.Price > 0)
                              { %>
                            <em class="tn-text-note">
                                <%=SPBHtmlHelper.Instance().Icon(IconTypes.Coins)%><%=file.Price%></em>
                            <%} %>
                            <em class="tn-text-note tn-count">
                                <%=GetResourceString("Label_Size", ApplicationIDs.Instance().File())%><%=GetResourceString("Common_Colon") %><%=file.Attachment.Friendlylength%></em>
                            <em>
                                <%if (file.UserTags.Count > 0)
                                  {%>
                                &nbsp;&nbsp;
                                <%=GetResourceString("Common_UserTag")%><%=GetResourceString("Common_Colon") %>
                                <%
                                    string fileTags = string.Empty;
                                    foreach (string tName in file.UserTags)
                                    {
                                        fileTags += string.Format("<a href='{0}' title='" + GetResourceString("Description_Pattern_ListFilesByTagOfUser", ApplicationIDs.Instance().File()) + "'>{1}</a>&nbsp;&nbsp;", SPBUrlHelper.Action("ListFilesByUserTag", "File", new RouteValueDictionary { { "userDomainName", userDomainName }, { "tagName", tName } }), tName);
                                    }
                                    Response.Write(fileTags);
                                  } %>
                            </em>
                        </div>
                        <div class="tn-list-item-row tn-list-item-summary">
                            <p class="tn-helper-reset">
                                <%if (file.OwnerUserID == currentDomainUserID)
                                  {%>
                                <%=HtmlUtils.TrimHtml(file.GetBody(true), 200)%>
                                <%}
                                  else
                                  {%>
                                <%=HtmlUtils.TrimHtml(file.GetBody(false), 200)%>
                                <%} %>
                                <%switch (file.PrivacyStatus)
                                  {
                                      case PrivacyStatuses.NeedPassword:
                                %>
                                <%=GetResourceString("Description_FileEncrypt",ApplicationIDs.Instance().File())%>
                                <a href="javascript:;" onclick="$('#passwordSpan<%=file.ThreadID %>').attr('style','display:block');">
                                    <%=GetResourceString("Action_HavePassword")%></a> <span id="passwordSpan<%=file.ThreadID %>"
                                        style="display: none">
                                        <%=GetResourceString("Common_Password")%><%=GetResourceString("Common_Colon") %>
                                        <input type="text" id="passwordInput<%=file.ThreadID %>" class="tn-textbox tn-input-medium tn-border-gray" />
                                        <%=SPBHtmlHelper.Instance().LinkButton("buttonOK", GetResourceString("Button_OK"), ButtonSizes.Default, HighlightStyles.Default, new RouteValueDictionary { { "onclick", "showFileThread()" } },null)%>
                                        <%=SPBHtmlHelper.Instance().LinkButton("buttonCancel", GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Default, new RouteValueDictionary { { "onclick", "$('#passwordSpan"+file.ThreadID+"').attr('style', 'display:none')" } }, null)%>
                                    </span>

                                <script type="text/javascript">
                                    function showFileThread() {
                                        window.location = '<%=SPBUrlHelper.Action("ShowFile","ChannelFile",new RouteValueDictionary{{"threadID",file.ThreadID}}) %>' + '?password=' + $('#passwordInput<%=file.ThreadID %>').val();
                                    }                                 
                                </script>

                                <%
                                    break;
                                           case PrivacyStatuses.OnlyFriend:
                                    if (isFriend)
                                    { %>
                                <%=HtmlUtils.TrimHtml(file.GetBody(false), 200)%>
                                <%}
                                    else
                                    { %>
                                <%=GetResourceString("Description_FriendSeeAndDownload",ApplicationIDs.Instance().File())%>
                                <%if (CurrentUser != null)
                                  {%>
                                <a class="makeFriendForAuthority" href="<%=SiteUrls.Instance().NewFriendInvitation(Globals.GetCurrentUser().UserName, currentDomainUserID)%>">
                                    <%=GetResourceString("Action_IntercourseFriend")%></a>
                                <%} %>
                                <%} %>
                                <%
                                    break;
                                           case PrivacyStatuses.Privacy:
                                    break;
                                           case PrivacyStatuses.Public:
                                    break;
                                           default:
                                    break;
                                       } %>
                            </p>
                        </div>
                    </div>
                    <div class="tn-list-item-row">
                        <em class="tn-date tn-text-note">
                            <%=GetResourceString("Label_UploadFor",ApplicationIDs.Instance().File()) %><%=Formatter.FormatDate(file.PostDate)%></em>
                        <cite class="tn-text-note">
                            <%=SPBHtmlHelper.Instance().ShowRating(file.RatingSum, file.TotalRatings,false,false)%></cite>
                        <%=SPBHtmlHelper.Instance().LinkButton("comment", GetResourceString("Common_Comment") + " (" + file.CommentCount + ")", SiteUrls.Instance().ShowFile(file.ThreadID) + "#comments", ButtonSizes.Default, HighlightStyles.Lite, IconTypes.Bubble, TextIconLayout.IconText)%>
                        <%=SPBHtmlHelper.Instance().LinkButton("hit", GetResourceString("Label_Hit", ApplicationIDs.Instance().File()) + " (" + file.HitTimes + ")", SiteUrls.Instance().ShowFile(file.ThreadID), ButtonSizes.Default, HighlightStyles.Lite, IconTypes.View, TextIconLayout.IconText)%>
                        <% if (isManager)
                           {%>
                        <span class="tn-action"><a class="tn-action-text" href="<%=SPBUrlHelper.Action("EditFile", "File", new RouteValueDictionary { { "userDomainName",WebUtils.UrlEncode(Html.GetParameterFromRouteDateOrQueryString("userDomainName")) }, { "threadID", file.ThreadID } })%>">
                            <%=GetResourceString("Action_Edit")%></a> </span><span class="tn-action"><a class="tn-action-text"
                                onclick=" if (confirm('<%=GetResourceString("Message_DeleteFile",ApplicationIDs.Instance().File()) %>')) { $('#listFileThreadsDiv').parent().load('<%=SPBUrlHelper.Action("DeleteFile","File",new RouteValueDictionary{{"ThreadID",file.ThreadID},{"userDomainName",userDomainName},{"categoryID",userCategoryID},{"tagName",tagName},{"pageIndex",returnToPageIndex},{"inShowFile",false},{"isSummaryFiles",true}}) %>' )}"
                                href="javascript:;">
                                <%=GetResourceString("Action_Delete")%></a></span>
                        <%} %>
                    </div>
                </li>
                <%} %>
            </ul>
            <div class="tn-pagination tn-helper-align-center">
                <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, fileThreads.TotalRecords, fileThreads.PageSize, fileThreads.PageIndex, 7, SPBUrlHelper.Action("Control_SummaryFiles","File",new RouteValueDictionary{{"userDomainName",userDomainName},{"categoryID",userCategoryID},{"tagName",WebUtils.UrlEncode(tagName)},{"pageIndex","{0}"}}), "pageIndexChange")%>
            </div>

            <script type="text/javascript">
                $(document).ready(function() {

                    $("a[class='makeFriendForAuthority']").nyroModal({
                        resizeable: true
                    });

                });

                function showLoading() {
                    $("#loading").show();
                    $("div.tn-pagination").hide();
                    $("#listBlogThreads").hide();
                }

                $("#actionList").click(function() {
                    showLoading();
                    $("#listFileThreadsDiv").parent().load('<%=listFilesUrl %>');
                });



                function pageIndexChange(url) {
                    $('#listFileThreadsDiv').parent().load(url);
                }
            </script>

        </div>
    </div>
    <div class="tn-blank10">
    </div>
</div>
