﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<ForumThread>>" %>
<% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("UserDomainName");
   int forumApplication = ApplicationIDs.Instance().Forum();
   int presentAreaID = Request.QueryString.GetInt("presentAreaID", 0);
%>
<div id="ListMyFriendForums">
    <table class="tn-table-grid">
        <tr class="tn-table-grid-header">
            <td colspan="2" class="tn-border-gray tn-border-bottom">
                筛选：<input type="checkbox" class="tn-checkbox" id="clubFilter" <%if (presentAreaID > 0) Response.Write("checked = \"checked\""); %> /><label
                    for="clubFilter">群组的</label>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_Auto",forumApplication)%>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_ReplayScan",forumApplication)%>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_LastRepliedDate",forumApplication)%>
            </td>
        </tr>
        <%foreach (ForumThread thread in Model.Records)
          {%>
        <tr class="tn-table-grid-row">
            <td class="tn-border-gray tn-border-bottom spb-topic-icon">
                <a target="_blank" href="<%=SiteUrls.Instance().ShowForumThreadInPresentArea(thread)%>"
                    title="普通主题">
                    <span class="tn-icon tn-icon-big tn-icon-topic-normal"></span>
                </a>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-auto">
                <%if (thread.ForumSection != null)
                  {%>
                <a target="_blank" href="<%=SiteUrls.Instance().ShowForumSectionInPresentArea(thread.ForumSection) %>"
                    class="tn-category" title="<%=thread.ForumSection.SectionName %>">【<%=StringUtils.Trim(thread.ForumSection.SectionName,8) %>】</a>
                <%} %>
                <a target="_blank" href="<%=SiteUrls.Instance().ShowForumThreadInPresentArea(thread)%>"
                    class="tn-text-heading" title="<%=thread.Subject%>">
                    <%=StringUtils.Trim(thread.Subject,15)%></a>
                <%if (thread.IsSticky)
                      Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Top, GetResourceString("Action_Top", forumApplication), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                  if (thread.IsEssential)
                      Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Elite, GetResourceString("Action_Essential", forumApplication), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                  if (thread.Price > 0)
                      Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Coins, string.Format(GetResourceString("Action_Takes", forumApplication), thread.Price), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                  if (thread.IsHot)
                      Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Fire, GetResourceString("Action_HotTopic"), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                  if (thread.IsLocked)
                      Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Lock, GetResourceString("Action_Lock"), new RouteValueDictionary { { "class", " tn-icon-inline" } }));%>
                <%=SPBHtmlHelper.Instance().ContentTypeThumbnail(thread.AttachmentFilename,ContentTypeThumbnailSize.Small)%>
                <%if (thread.ReplyCount > ForumConfiguration.Instance().PostsPerPage)
                  { %>
                <span class="spb-topic-pages tn-text-note">
                    <%=SPBHtmlHelper.Instance().ShowForumThreadPager(thread,null) %></span>
                <%} %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                <cite>
                    <a target="_blank" href="<%=SiteUrls.Instance().UserChannelHome(thread.UserID,ApplicationIDs.Instance().Forum()) %>"
                        title="<%=thread.Author %>">
                        <%=thread.Author %></a></cite> <em class="tn-text-note">
                            <%=Formatter.FormatDate(thread.PostDate)%></em> </td>
            <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                <cite>
                    <a target="_blank" href="<%=SiteUrls.Instance().ShowForumThreadInPresentArea(thread)%>">
                        <%=thread.ReplyCount %></a></cite> <em class="tn-text-note">
                            <%=thread.HitTimes %></em> </td>
            <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                <%if (thread.MostRecentPostAuthorID > 0)
                  {
                      ForumSectionGroup group = ForumSectionGroups.GetGroup(thread.GroupID, false);
                      string gotoLastUrl = string.Empty;
                      if (group != null && group.PresentAreaID == PresentAreaIDs.Instance().ClubDomain())
                          gotoLastUrl = SiteUrls.Instance().ShowForumThreadGotoLastPostInClub(group.GroupName, thread.ThreadID, thread.MostRecentPostID);
                      else
                          gotoLastUrl = SiteUrls.Instance().ShowForumThreadGotoLastPost(thread.ThreadID, thread.MostRecentPostID); %>
                <cite>
                    <a target="_blank" href="<%=SiteUrls.Instance().UserChannelHome(thread.MostRecentPostAuthorID,ApplicationIDs.Instance().Forum()) %>">
                        <%=thread.MostRecentPostAuthor %></a></cite><a href="<%=gotoLastUrl %>" target="_blank"><em
                            class="tn-text-note">
                            <%if (thread.LastRepliedDate > ValueHelper.GetSafeSqlDateTime(DateTime.MinValue)) Response.Write(Formatter.FormatDate(thread.LastRepliedDate, false)); %>
                        </em></a>
            </td>
            <%} %>
        </tr>
        <%} %>
    </table>
    <div class="tn-pagination tn-helper-align-center">
        <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11, SPBUrlHelper.Action("Control_ListMyFriendForums", "UserDomainForum", new RouteValueDictionary { { "userDomainName", userDomainName }, { "presentAreaID", presentAreaID }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
        <div class="tn-page-results tn-text-note">
            <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $('#clubFilter').click(function() {
            if ($(this).is(":checked")) {
                $('#ListMyFriendForums').parent().load('<%=SPBUrlHelper.Action("Control_ListMyFriendForums", "UserDomainForum", new RouteValueDictionary { { "userDomainName", userDomainName }, { "presentAreaID",  PresentAreaIDs.Instance().ClubDomain() }})%>');
            }
            else {
                $('#ListMyFriendForums').parent().load('<%=SPBUrlHelper.Action("Control_ListMyFriendForums", "UserDomainForum", new RouteValueDictionary { { "userDomainName", userDomainName }})%>');
            }
        });
    });
    function pageIndexChange(url) {
        $('#ListMyFriendForums').parent().load(url);
    }
</script>

