﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<ForumPost>>" %>
<%Dictionary<int, ForumThread> forumThreads = ViewData["forumThreads"] as Dictionary<int, ForumThread>; %>
<% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("UserDomainName");
   int forumApplication = ApplicationIDs.Instance().Forum();
   bool isFriends = ViewData.GetBool("isFriends");
   int presentAreaID = Request.QueryString.GetInt("presentAreaID", 0);
%>
<div id="ListPostForums">
    <table class="tn-table-grid">
        <tr class="tn-table-grid-header">
            <td class="tn-border-gray tn-border-bottom">
                筛选：<input type="checkbox" class="tn-checkbox" id="clubPostFilter" <%if (presentAreaID > 0) Response.Write("checked = \"checked\""); %> /><label
                    for="clubPostFilter">群组的</label>
            </td>
            <%if (isFriends)
              { %>
            <td class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_PostAuthor", forumApplication)%>
            </td>
            <%} %>
            <td class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_ReplayScan",forumApplication)%>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_LastRepliedDate",forumApplication)%>
            </td>
        </tr>
        <%foreach (ForumPost post in Model.Records)
          {
              ForumThread thread = forumThreads[post.ThreadID];
              if (thread == null)
                  continue;

              string gotopost = string.Empty;
              ForumSectionGroup group = ForumSectionGroups.GetGroup(thread.GroupID, false);
              if (group != null)
                  gotopost = group.PresentAreaID == PresentAreaIDs.Instance().ClubDomain() ? SiteUrls.Instance().ShowForumThreadGotoLastPostInClub(group.GroupName, thread.ThreadID, post.PostID) : SiteUrls.Instance().ShowForumThreadGotoLastPost(thread.ThreadID, post.PostID);
        %>
        <tr class="tn-table-grid-row">
            <td class="tn-border-gray tn-border-bottom tn-width-auto">
                <%if (thread.ForumSection != null)
                  {%>
                <a href="<%=SiteUrls.Instance().ShowForumSectionInPresentArea(thread.ForumSection) %>"
                    class="tn-category" title="<%=thread.ForumSection.SectionName%>">【<%=thread.ForumSection.SectionName%>】</a>
                <%} %>
                <a href="<%=SiteUrls.Instance().ShowForumThreadInPresentArea(thread)%>" class="tn-text-heading"
                    title="<%=post.Subject%>">
                    <%=StringUtils.Trim(post.Subject,35)%></a>
                <p>
                    <%=HtmlUtils.TrimHtml(post.Body,30)%>
                    <%if (!string.IsNullOrEmpty(gotopost))
                      {%>&nbsp; &nbsp;
                    <a href="<%=gotopost %>" target="_blank">查看</a></p>
                <%} %>
            </td>
            <%if (isFriends)
              {%>
            <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                <cite>
                    <a href="<%=SiteUrls.Instance().UserDomainHome(thread.UserID) %>" title="<%=thread.Author%>">
                        <%=thread.Author%></a></cite> <em class="tn-text-note">
                            <%=Formatter.FormatDate(thread.PostDate)%></em> </td>
            <%} %>
            <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                <cite>
                    <a href="<%=SiteUrls.Instance().ShowForumThreadInPresentArea(thread)%>">
                        <%=thread.ReplyCount %></a></cite> <em class="tn-text-note">
                            <%=thread.HitTimes %></em> </td>
            <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                <cite>
                    <a href="<%=SiteUrls.Instance().UserDomainHome(thread.MostRecentPostAuthorID)%>"
                        title="<%=thread.MostRecentPostAuthor %>">
                        <%=thread.MostRecentPostAuthor %></a></cite> <em class="tn-text-note">
                            <%=Formatter.FormatDate(thread.LastRepliedDate)%></em> </td>
        </tr>
        <%} %>
    </table>
    <div class="tn-pagination tn-helper-align-center">
        <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11, SPBUrlHelper.Action("Control_ListPostForums", "UserDomainForum", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pageIndex", "{0}" }, { "isFriends", isFriends },{"presentAreaID",presentAreaID} }), "ListPostForumsPageIndexChange")%>
        <div class="tn-page-results tn-text-note">
            <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $('#clubPostFilter').click(function() {
            if ($(this).is(":checked")) {
                $('#ListPostForums').parent().load('<%=SPBUrlHelper.Action("Control_ListPostForums", "UserDomainForum", new RouteValueDictionary { { "userDomainName", userDomainName }, { "isFriends", isFriends },{"presentAreaID",PresentAreaIDs.Instance().ClubDomain() } }) %>');
            }
            else {
                $('#ListPostForums').parent().load('<%=SPBUrlHelper.Action("Control_ListPostForums", "UserDomainForum", new RouteValueDictionary { { "userDomainName", userDomainName }, { "isFriends", isFriends } }) %>');
            }
        });
    });
    function ListPostForumsPageIndexChange(url) {
        $('#ListPostForums').parent().load(url);
    }
</script>

