﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% 
    int ForumApplicationID = ApplicationIDs.Instance().Forum();
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    ForumUserDomainSubMenus? subMenu = null;
    if (ViewData["ForumUserDomainSubMenu"] != null)
        subMenu = (ForumUserDomainSubMenus)ViewData["ForumUserDomainSubMenu"];
    User currentDomainUser = Users.GetUser(userDomainName, false);

    bool isOwner = false;
    if (CurrentUser != null && (CurrentUser.UserID == currentDomainUser.UserID || CurrentUser.IsContentAdministrator))
        isOwner = true;
%>
<% if (isOwner)
   {%>
<div class="spb-nav2-area">
    <div class="tn-wrapper-inner tn-helper-clearfix">
        <ul class="spb-nav2 tn-helper-reset tn-helper-left">
            <li <% if(subMenu!=null && subMenu== ForumUserDomainSubMenus.myForum) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("ListMyForums", "UserDomainForum", new RouteValueDictionary { { "userDomainName", userDomainName } })%>">
                    <span>
                        <%=GetResourceString("Title_MyForums",ForumApplicationID)%></span></a></li>
            <%
                if (currentDomainUser.UserType == UserTypes.PersonUser && (isOwner || CurrentUser.IsContentAdministrator))
                {%>
            <li <% if(subMenu!=null && subMenu== ForumUserDomainSubMenus.friendForum) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\"");  %>>
                <a href="<%=SPBUrlHelper.Action("ListMyFriendForums", "UserDomainForum", new RouteValueDictionary { { "userDomainName", userDomainName } })%>">
                    <span>
                        <%=GetResourceString("Title_MyFriendsForums", ForumApplicationID)%></span></a></li>
            <%} %>
            <li class="spb-nav-item"><a href="<%=SiteUrls.Instance().ChannelForumHome()%>" target="_blank">
                <span>
                    <%=GetResourceString("Title_Forum",ForumApplicationID)%></span></a></li>
        </ul>
        <div class="tn-helper-right">
            <%=SPBHtmlHelper.Instance().LinkButton("newForumThreadLink", GetResourceString("Label_SendTopic", ForumApplicationID), SPBUrlHelper.Action("Control_ShowForumNavigation", "ChannelForum"), ButtonSizes.Default, HighlightStyles.Primary, IconTypes.Write, TextIconLayout.IconText, new RouteValueDictionary { { "class", "tn-action-text nyroModal" } },null)%>
        </div>
    </div>
</div>
<%} %>
