﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<Friend>" %>
<%Friend friend = ViewData.Model;
  string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
  Friendliness friendliness = (Friendliness)ViewData.GetInt("Friendliness", (int)Friendliness.All);
  int friendApplicationID = ApplicationIDs.Instance().Friend();
  
%>
<%   
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">$.nyroModalRemove();refresh();</script>"));
        }
        else
        {
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
        }
        TempData["StatusMessageType"] = null;
    }   
%>

<div class="tn-form tn-label-right">
  <h4 class="tn-text-heading tn-border-gray tn-border-bottom"> <%=GetResourceString("Title_EditFriend",friendApplicationID) %> </h4>
  <form method="post" action="<%=SPBUrlHelper.Action("UpdateFriend","Friend",new RouteValueDictionary{{"userDomainName",userDomainName},{"friendID",friend.FriendID}}) %>"
    class="nyroModal">
    <div class="tn-form-row">
      <label class="tn-form-label"> 备注名称<%=GetResourceString("Common_Colon") %></label>
      <input class="tn-textbox tn-input-medium tn-border-gray" id="noteName" maxlength="15"
            name="noteName" value="<%=friend.NoteName%>" />
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> <%=GetResourceString("Label_Friendliness",friendApplicationID) %><%=GetResourceString("Common_Colon") %></label>
      <select id="friendlinessSelect" name="friendlinessSelect" class="tn-dropdownlist">
        <option value="<%=(int)Friendliness.NotSet %>" <%if (friendliness== Friendliness.NotSet)
                       {
                           Response.Write(" selected=\"selected\""); 
                       } %>> <%=GetResourceString("Common_NotSet") %></option>
        <option value="<%=(int)Friendliness.BosomFriend %>" <%if (friendliness== Friendliness.BosomFriend)
                       {
                           Response.Write(" selected=\"selected\"");     
                       } %>> <%=GetResourceString("Enum_Friendliness_BosomFriend",friendApplicationID) %></option>
        <option value="<%=(int)Friendliness.GoodFriend %>" <%if (friendliness== Friendliness.GoodFriend)
                       {
                           Response.Write(" selected=\"selected\"");     
                       } %>> <%=GetResourceString("Enum_Friendliness_GoodFriend", friendApplicationID)%></option>
        <option value="<%=(int)Friendliness.Friend %>" <%if (friendliness== Friendliness.Friend)
                       {
                           Response.Write(" selected=\"selected\"");    
                       } %>> <%=GetResourceString("Enum_Friendliness_Friend", friendApplicationID)%></option>
        <option value="<%=(int)Friendliness.Acquaintance %>" <%if (friendliness== Friendliness.Acquaintance)
                       {
                           Response.Write(" selected=\"selected\"");    
                       } %>> <%=GetResourceString("Enum_Friendliness_Acquaintance", friendApplicationID)%></option>
        <option value="<%=(int)Friendliness.WithoutMeet %>" <%if (friendliness== Friendliness.WithoutMeet)
                        {
                           Response.Write(" selected=\"selected\"");
                        } %>> <%=GetResourceString("Enum_Friendliness_WithoutMeet", friendApplicationID)%></option>
      </select>
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> <%=GetResourceString("Label_IsHidden",friendApplicationID) %><%=GetResourceString("Common_Colon") %></label>
      <div class="tn-input-multiple">
        <input class="tn-radiobutton" id="show" type="radio" <%if(!friend.IsHidden){Response.Write(" checked=\"checked\" ");} %>
                value="false" name="isHidden" />
        <label for="show"><%=GetResourceString("Enum_PrivacyStatuses_Public")%></label>
        <input class="tn-radiobutton" id="hidden" type="radio" <%if(friend.IsHidden){Response.Write(" checked=\"checked\" ");} %>
                value="true" name="isHidden" />
        <label for="hidden"><%=GetResourceString("Label_Hidden",friendApplicationID) %></label>
        <br />
        <div class="tn-text-note"> <%=string.Format(GetResourceString("Description_Pattern_IsHidden", friendApplicationID), Users.GetUser(friend.FriendUserID, false).DisplayName)%> </div>
      </div>
    </div>
    <div class="tn-form-row tn-textarea-wrap">
      <label class="tn-form-label"> <%=GetResourceString("Label_Remark",friendApplicationID) %><%=GetResourceString("Common_Colon") %></label>
      <textarea class="tn-textarea tn-input-long tn-border-gray" id="remark"  maxlength="200"
            name="remark" rows="6" cols="35"><%=friend.Remark%></textarea>
            <span style="display:none"></span>
    </div>
    <div class="tn-form-row tn-form-row-button">
      <label class="tn-form-label"> </label>
      <%=SPBHtmlHelper.Instance().SubmitButton("saveButton", GetResourceString("Button_OK"), ButtonSizes.Large, null, null)%> <%=SPBHtmlHelper.Instance().Button("", GetResourceString("Button_Cancel"), ButtonSizes.Large, HighlightStyles.Secondary, new RouteValueDictionary { { "class", "nyroModalClose" } },null)%> </div>
  </form>
</div>
