﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PersonUser>" %>
<div class="tn-card tn-card-complete">
    <div class="tn-widget tn-bubble-box tn-bubble-box-arrow-left">
        <div class="tn-bubble-box-arrow">
            <b class="tn-arrow-b1 tn-widget-content tn-bg-light"></b><b class="tn-arrow-b2 tn-widget-content tn-bg-light">
            </b><b class="tn-arrow-b3 tn-widget-content tn-bg-light"></b><b class="tn-arrow-b4 tn-widget-content tn-bg-light">
            </b><b class="tn-arrow-b5 tn-widget-content tn-bg-light"></b><b class="tn-arrow-b6 tn-widget-content tn-bg-light">
            </b><b class="tn-arrow-b7 tn-widget-content tn-bg-light"></b>
        </div>
        <div class="tn-bubble-box-content tn-widget-content tn-bg-light tn-corner-all">
            <%
                if (Model != null)
                {
                    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
                    int friendApplicationID = ApplicationIDs.Instance().Friend();
                    int applicationID = ApplicationIDs.Instance().User();
                    Friend friend = ViewData.Get<Friend>("friend", null);
                    bool isManager = ViewData.GetBool("isManager", false);
            %>
            <div class="tn-showcase tn-helper-clearfix">
                <div class="tn-helper-left">
                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(Model.UserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Card)%></div>
                <div class="tn-info">
                    <div class="tn-id-name">
                        <strong><a class="tn-user-name" href="<%=SiteUrls.Instance().UserChannelHome(Model.UserID,UserDomainSpecialAppIDs.Instance().Home()) %>">
                            <%=SPBHtmlHelper.Instance().UserDisplayName(Model)%></a></strong></div>
                    <%string microblog = MicroBlogUserDatas.GetUserData(Model.UserID, false).MostRecentThreadBody;
                      if (!string.IsNullOrEmpty(microblog))
                      { %>
                    <div class="spb-i-said">
                        &nbsp;<span class="tn-icon tn-icon-quotes-before tn-icon-inline"></span>
                        <%=microblog%>
                        <span class="tn-icon tn-icon-quotes-after tn-icon-inline"></span>
                    </div>
                    <%}%>
                    <div class="tn-info-part">
                        <dl class="tn-text-note">
                            <dt>
                                <%=GetResourceString("Label_LastActivity", applicationID)%><%=GetResourceString("Common_Colon")%></dt>
                            <dd>
                                <%=Formatter.FormatDate(Model.LastActivity, false)%></dd>
                        </dl>
                        <%if (!string.IsNullOrEmpty(Model.PublicEmail))
                          { %>
                        <dl class="tn-text-note">
                            <dt>Email：</dt>
                            <dd>
                                <%=Model.PublicEmail%></dd>
                        </dl>
                        <%}
                          if (!string.IsNullOrEmpty(Model.Mobile))
                          { %>
                        <dl class="tn-text-note">
                            <dt>
                                <%=GetResourceString("Label_PersonUserMobile", applicationID)%><%=GetResourceString("Common_Colon")%></dt>
                            <dd>
                                <%=Model.Mobile%></dd>
                        </dl>
                        <%}
              if (!string.IsNullOrEmpty(Model.HomeTel))
              { %>
                        <dl class="tn-text-note">
                            <dt>
                                <%=GetResourceString("Label_PersonUserTel", applicationID)%><%=GetResourceString("Common_Colon")%></dt>
                            <dd>
                                <%=Model.HomeTel%></dd>
                        </dl>
                        <%} %>
                    </div>
                </div>
            </div>
            <div class="tn-marked tn-border-light tn-border-top">
                <div class="tn-info-part">
                    <dl class="tn-text-note">
                        <dt>
                            <%=GetResourceString("Label_Friendliness", friendApplicationID)%><%=GetResourceString("Common_Colon")%></dt>
                        <dd>
                            <%switch (friend.Friendliness)
                              {
                                  case Friendliness.Acquaintance:
                                      Response.Write(GetResourceString("Enum_Friendliness_Acquaintance", friendApplicationID));
                                      break;
                                  case Friendliness.BosomFriend:
                                      Response.Write(GetResourceString("Enum_Friendliness_BosomFriend", friendApplicationID));
                                      break;
                                  case Friendliness.Friend:
                                      Response.Write(GetResourceString("Enum_Friendliness_Friend", friendApplicationID));
                                      break;
                                  case Friendliness.GoodFriend:
                                      Response.Write(GetResourceString("Enum_Friendliness_GoodFriend", friendApplicationID));
                                      break;
                                  case Friendliness.NotSet:
                                      Response.Write(GetResourceString("Common_NotSet"));
                                      break;
                                  case Friendliness.WithoutMeet:
                                      Response.Write(GetResourceString("Enum_Friendliness_WithoutMeet", friendApplicationID));
                                      break;
                                  default:
                                      Response.Write(GetResourceString("Common_NotSet"));
                                      break;
                              } %>
                        </dd>
                    </dl>
                    <dl class="tn-text-note">
                        <dt>
                            <%=GetResourceString("Label_Friendships", friendApplicationID)%><%=GetResourceString("Common_Colon")%></dt>
                        <dd>
                            <%if (friend.IsHidden) { Response.Write(GetResourceString("Action_Fold", friendApplicationID)); } else { Response.Write(GetResourceString("Enum_PrivacyStatuses_Public")); } %>
                        </dd>
                    </dl>
                    <%if (!string.IsNullOrEmpty(friend.Remark))
                      { %>
                    <dl>
                        <dt>
                            <%=GetResourceString("Label_Remark", friendApplicationID)%><%=GetResourceString("Common_Colon")%></dt>
                        <dd>
                            <%=friend.Remark%></dd>
                    </dl>
                    <%} %>
                </div>
            </div>
            <%if (CurrentUser != null)
              { %>
            <div class="tn-actions tn-border-light tn-border-top">
                <span class="tn-button tn-button-default"><span class="tn-first-child"><a class="tn-button-text"
                    href="<%=SiteUrls.Instance().NewMessage(Globals.GetCurrentUser().UserName,friend.FriendUserID) %>">
                    <%=GetResourceString("Action_SendMessage", friendApplicationID)%></a></span></span>
                <span class="tn-button tn-button-default"><span class="tn-first-child"><a class="tn-button-text"
                    href="<%=SiteUrls.Instance().DownloadVCard(friend.FriendUserID) %>">
                    <%=GetResourceString("Action_DownloadVCard", friendApplicationID)%></a> </span>
                </span><span class="tn-button tn-button-default"><span class="tn-first-child"><a
                    class="tn-button-text" href="<%=SPBUrlHelper.Action("PrivacySpecialSettings","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName},{"toUserID",friend.FriendUserID }}) %>">
                    <%=GetResourceString("Action_AuthorizedUser", friendApplicationID)%></a></span></span>
                <%
                    if (isManager)
                    {
                %>
                <span class="tn-button tn-button-default"><span class="tn-first-child"><a class="tn-button-text editFriendForModal"
                    href="<%=SPBUrlHelper.Action("Control_EditFriend","Friend",new RouteValueDictionary{{"userDomainName",userDomainName},{"friendID",friend.FriendID}}) %>">
                    <%=GetResourceString("Action_Edit")%></a></span></span>
                <%} %>
            </div>
            <%}
          }%>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $('.editFriendForModal').nyroModal({
            resizeable: true,
        });
    });
</script>

