﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<Favorite>>" %>
<%
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    
    int friendApplicationID = ApplicationIDs.Instance().Friend();
%>
<%bool? isfriendbool = null;
  if (!string.IsNullOrEmpty(Html.GetParameterFromRouteDateOrQueryString("isFriend")))
  {
      isfriendbool = Convert.ToBoolean(Html.GetParameterFromRouteDateOrQueryString("isFriend"));
  }%>
<div class="tn-box-content tn-widget-content tn-corner-all" id="contentdiv">
    <form id="favoriteForm" method="post">
    <ul class="tn-list tn-helper-reset tn-helper-clearfix">
        <%foreach (Favorite user in Model)
         {
             User toUser = Users.GetUser(user.ItemID, false);
             if (toUser == null)
                 continue;%>
        <li class="tn-list-item tn-helper-clearfix">
            <div class="tn-list-item-area-left">
                <div class="tn-avatar">
                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(user.ItemID,true,HyperLinkTarget._self,AvatarSizeTypes.Small,null) %>
                </div>
            </div>
            <div class="tn-list-item-area-main">
                <div class="tn-list-item-row">
                    <cite><a href="<%=SiteUrls.Instance().UserDomainHome(user.ItemID)%>">
                        <%=toUser.DisplayName%></a></cite> <span class="spb-user-type"><a href="<%=SPBUrlHelper.Action("TotalUserPoints","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                            <%=SPBHtmlHelper.Instance().ShowUserRankIcons(toUser)%></a> </span>
                </div>
                <div class="tn-list-item-row">
                    <%if (CurrentUser != null && !Friends.IsFriend(CurrentUser.UserID, user.ItemID))
                   {%>
                    <span class="tn-action"><a class="addFriendModal" href="<%=SiteUrls.Instance().NewFriendInvitation(CurrentUser.UserName,user.ItemID)%>">
                        <%= GetResourceString("Action_AddFriend")%></a></span>
                    <%} %>
                    <%if(FavoriteManager.Instance(FavoriteItemKeys.Instance().Users()).IsFavorite(CurrentUser.UserID,user.ItemID)) 
                    { %>
                    <span class="tn-action"><a id="A1" name="deleteFavorite" href="javascript:;"
                        onclick="if (confirm('<%=GetResourceString("Message_ConfirmDeleteFavoriteUser",friendApplicationID) %>')) {$('#contentdiv').parent().load('<%=SPBUrlHelper.Action("DeleteFavoriteUser","Friend",new RouteValueDictionary{{"userDomainName",userDomainName},{"favoriteID",user.FavoriteID},{"isFriend",isfriendbool}}) %>')}">
                        <%=GetResourceString("Description_CancleAttention",friendApplicationID)%></a>
                    </span>
                    <%} %>
                </div>
            </div>
        </li>
        <%} %>
    </ul>
    </form>
    <% if (Model.Count == 0) { Response.Write(GetResourceString("Description_NoFavoriteUsers", friendApplicationID)); }%>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $('.addFriendModal').nyroModal({
            resizeable: true,
            width: 300,
            height: 300
        });
    });
</script>

