﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<Friend>>" %>
<div id="ManageFriends">
    <%
        Friendliness? friendliness = (Friendliness?)ViewData["friendliness"];
        string keyWords = WebUtils.UrlEncode(ViewData.GetString("keyWords", string.Empty));
        string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
        int? groupID = null;
        if (Html.GetParameterFromRouteDateOrQueryString("groupID", 0) > 0)
            groupID = Html.GetParameterFromRouteDateOrQueryString("groupID", 0);
        int friendApplicationID = ApplicationIDs.Instance().Friend();
        int pageIndex = Html.GetParameterFromRouteDateOrQueryString("pageIndex", 1);
        List<UserCategory> userCategories = ViewData.Get<List<UserCategory>>("UserCategories", new List<UserCategory>());  
        
    %>
    <spb:Script runat="server" ID="position" Src="~/Utility/jquery/ui.position.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="autocomplete" Src="~/Utility/jquery/ui.autocomplete.min-1.8.12.js"
        SetExpireDays="30" />
    <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-friends-list">
        <div class="tn-box-content tn-widget-content tn-corner-all">
            <form id="listFriendForm" method="post" action="">
            <div class="tn-list-header">
                <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
                    <div class="tn-search-box tn-helper-right">
                        <input type="hidden" value="<%=groupID %>" name="groupID" />
                        <input type="text" class="tn-search-input tn-input-medium tn-border-gray tn-border-tbl"
                            autocomplete="false" value="<%=WebUtils.UrlDecode(keyWords) %>" name="keyword"
                            id="keyword">
                        <span class="tn-search-button tn-search-ico-button tn-border-gray tn-bg-gray">
                            <button id="searchButton">
                                <span class="tn-icon tn-icon-find"></span>
                            </button>
                        </span>
                    </div>
                    <%=GetResourceString("Label_Display")%><%=GetResourceString("Common_Colon") %>
                    <select name="sortbyselect" id="sortbyselect" class="tn-dropdownlist" onchange="$('#sortForLoad').load('<%=SPBUrlHelper.Action("Control_ListFriends", "Friend", new RouteValueDictionary { { "userDomainName", userDomainName },{ "keyWords", keyWords }, { "groupID", groupID }, { "pageIndex", pageIndex }, { "isManager", true } })%>',{friendliness:$('#sortbyselect').val()});">
                        <option value="" <%if (friendliness== Friendliness.NotSet)
               {
                   Response.Write(" selected=\"selected\""); 
               } %>>
                            <%=GetResourceString("Enum_Friendliness_All",friendApplicationID) %></option>
                        <option value="<%=(int)Friendliness.BosomFriend %>" <%if (friendliness== Friendliness.BosomFriend)
               {
                   Response.Write(" selected=\"selected\"");     
               } %>>
                            <%=GetResourceString("Enum_Friendliness_BosomFriend",friendApplicationID) %></option>
                        <option value="<%=(int)Friendliness.GoodFriend %>" <%if (friendliness== Friendliness.GoodFriend)
               {
                   Response.Write(" selected=\"selected\"");     
               } %>>
                            <%=GetResourceString("Enum_Friendliness_GoodFriend",friendApplicationID) %></option>
                        <option value="<%=(int)Friendliness.Friend %>" <%if (friendliness== Friendliness.Friend)
               {
                   Response.Write(" selected=\"selected\"");    
               } %>>
                            <%=GetResourceString("Enum_Friendliness_Friend", friendApplicationID)%></option>
                        <option value="<%=(int)Friendliness.Acquaintance %>" <%if (friendliness== Friendliness.Acquaintance)
               {
                   Response.Write(" selected=\"selected\"");    
               } %>>
                            <%=GetResourceString("Enum_Friendliness_Acquaintance",friendApplicationID) %></option>
                        <option value="<%=(int)Friendliness.WithoutMeet %>" <%if (friendliness== Friendliness.WithoutMeet) 
                {
                   Response.Write(" selected=\"selected\"");
                } %>>
                            <%=GetResourceString("Enum_Friendliness_WithoutMeet",friendApplicationID) %></option>
                    </select>
                </div>
                <div class="tn-toolbar-area tn-helper-clearfix">
                    <input class="tn-checkbox" type="checkbox" id="checkAllOrNo" onclick="checkAll(this,'friendCheckBoxGroup')" />
                    <label class="tn-check-all" for="checkAllOrNo">
                        <%=GetResourceString("Label_SelectAllOrNo") %></label>
                    <%=SPBHtmlHelper.Instance().LinkButton(string.Empty,GetResourceString("Action_AddToGroup",ApplicationIDs.Instance().Friend()), "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.MenuButton, null, new RouteValueDictionary { { "menu", "#SelectFriendsGroup" } } )%>
                    <div class="tn-menu-button-position tn-menu tn-helper-reset tn-widget-content" id="SelectFriendsGroup">
                        <ul class="tn-menu-list">
                            <%
                                foreach (UserCategory category in userCategories)
                                {%>
                            <li class="tn-menu-item" onclick="ajaxSubmitTheForm('<%=SPBUrlHelper.Action("SetFriendsToGroup", "Friend", new RouteValueDictionary { { "userDomainName", userDomainName },{ "keyWords", keyWords },{"categoryID",category.CategoryID}, { "groupID", groupID }, { "pageIndex", pageIndex }, { "sortBy", friendliness }})%>');">
                                <a href="javascript:;" class="tn-menu-text">
                                    <%=category.CategoryName%></a></li>
                            <%} %>
                        </ul>
                    </div>
                    <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Action_SetFriendliness",ApplicationIDs.Instance().Friend()), "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.MenuButton, null, new RouteValueDictionary { { "menu", "#SelectIntimacy" } })%>
                    <div class="tn-menu-button-position tn-menu tn-helper-reset tn-widget-content" id="SelectIntimacy">
                        <ul class="tn-menu-list">
                            <li class="tn-menu-item" onclick="ajaxSubmitTheForm('<%=SPBUrlHelper.Action("UpdateFriendliness","Friend",new RouteValueDictionary{{"userDomainName",userDomainName},{ "keyWords", keyWords },{"groupID",groupID},{"pageIndex",pageIndex},{"sortBy",friendliness},{"friendliness",(int)Friendliness.All}}) %>');">
                                <a href="javascript:;" class="tn-menu-text">
                                    <%=GetResourceString("Action_SetFriendliness",friendApplicationID) %></a></li>
                            <li class="tn-menu-item" onclick="ajaxSubmitTheForm('<%=SPBUrlHelper.Action("UpdateFriendliness","Friend",new RouteValueDictionary{{"userDomainName",userDomainName},{ "keyWords", keyWords },{"groupID",groupID},{"pageIndex",pageIndex},{"sortBy",friendliness},{"friendliness",(int)Friendliness.BosomFriend}}) %>');">
                                <a href="javascript:;" class="tn-menu-text">
                                    <%=GetResourceString("Enum_Friendliness_BosomFriend", friendApplicationID)%></a></li>
                            <li class="tn-menu-item" onclick="ajaxSubmitTheForm('<%=SPBUrlHelper.Action("UpdateFriendliness","Friend",new RouteValueDictionary{{"userDomainName",userDomainName},{ "keyWords", keyWords },{"groupID",groupID},{"pageIndex",pageIndex},{"sortBy",friendliness},{"friendliness",(int)Friendliness.GoodFriend}}) %>');">
                                <a href="javascript:;" class="tn-menu-text">
                                    <%=GetResourceString("Enum_Friendliness_GoodFriend", friendApplicationID)%></a></li>
                            <li class="tn-menu-item" onclick="ajaxSubmitTheForm('<%=SPBUrlHelper.Action("UpdateFriendliness","Friend",new RouteValueDictionary{{"userDomainName",userDomainName},{ "keyWords", keyWords },{"groupID",groupID},{"pageIndex",pageIndex},{"sortBy",friendliness},{"friendliness",(int)Friendliness.Friend}}) %>');">
                                <a href="javascript:;" class="tn-menu-text">
                                    <%=GetResourceString("Enum_Friendliness_Friend", friendApplicationID)%></a></li>
                            <li class="tn-menu-item" onclick="ajaxSubmitTheForm('<%=SPBUrlHelper.Action("UpdateFriendliness","Friend",new RouteValueDictionary{{"userDomainName",userDomainName},{ "keyWords", keyWords },{"groupID",groupID},{"pageIndex",pageIndex},{"sortBy",friendliness},{"friendliness",(int)Friendliness.Acquaintance}}) %>');">
                                <a href="javascript:;" class="tn-menu-text">
                                    <%=GetResourceString("Enum_Friendliness_Acquaintance",friendApplicationID) %></a></li>
                            <li class="tn-menu-item" onclick="ajaxSubmitTheForm('<%=SPBUrlHelper.Action("UpdateFriendliness","Friend",new RouteValueDictionary{{"userDomainName",userDomainName},{ "keyWords", keyWords },{"groupID",groupID},{"pageIndex",pageIndex},{"sortBy",friendliness},{"friendliness",(int)Friendliness.WithoutMeet}}) %>');">
                                <a href="javascript:;" class="tn-menu-text">
                                    <%=GetResourceString("Enum_Friendliness_WithoutMeet",friendApplicationID) %></a></li>
                        </ul>
                    </div>
                    <span class="tn-button tn-button-default"><span class="tn-first-child"><a class="tn-button-text"
                        href="<%=SPBUrlHelper.Action("Control_ExportFriendToCSV","Friend",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"
                        id="exportFriendToCSV"><span>
                            <%=GetResourceString("Action_ExportFriendToCSV",friendApplicationID) %></span>
                    </a></span></span>
                </div>
            </div>
            <ul id="friendUL" class="tn-list tn-helper-reset">
                <%foreach (var friend in ViewData.Model.Records)
                  {
                      if (friend.FriendUser == null)
                          continue;
                      List<UserCategory> selectedCategory = MultiUserCategoryManager.Instance(MultiUserCategoryItemKeys.Instance().Friend()).GetUserCategoriesOfItem(friend.FriendID, true);%>
                <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
                    <div class="tn-list-checkbox">
                        <input type="checkbox" name="friendCheckBoxGroup" class="tn-checkbox" value="<%=friend.FriendID %>" />
                    </div>
                    <div class="tn-list-item-area-left">
                        <div class="tn-avatar" value="<%=friend.FriendUserID %>,<%=friend.FriendID %>">
                            <%=SPBHtmlHelper.Instance().ShowUserAvatar(friend.FriendUserID, true, HyperLinkTarget._self, AvatarSizeTypes.Small)%></div>
                    </div>
                    <div class="tn-list-item-area-right">
                        <ul class="tn-list-actions tn-helper-reset">
                            <%if (userCategories != null)
                              { %>
                            <li class="tn-list-action"><span id="optionButton_<%=friend.FriendID %>" class="tn-action tn-action-text-icon-right tn-action-has-drop-menu tn-border-trl"
                                menu="#moreOptions_<%=friend.FriendID %>"><span class="tn-icon tn-icon-triangle-down">
                                </span><a href="#" class="tn-action-text">
                                    <%=GetResourceString("Action_AddToGroup", ApplicationIDs.Instance().Friend())%></a></span>
                                <div id="moreOptions_<%=friend.FriendID %>" class="tn-drop-menu ui-widget-content"
                                    style="display: none;">
                                    <ul class="tn-menu-drop-list">
                                        <%foreach (UserCategory category in userCategories)
                                          {%>
                                        <li class="tn-menu-drop-item">
                                            <label>
                                                <input class="tn-checkbox" <%if(selectedCategory.Exists(n=>n.CategoryID == category.CategoryID)){Response.Write(" checked=\"checked\"");} %>
                                                    value="true" type="checkbox" onclick="setFriendCategory('<%=SPBUrlHelper.Action("SetFriendToGroup","Friend",new RouteValueDictionary{{"userDomainName",userDomainName},{ "keyWords", keyWords },{"friendID",friend.FriendID},{"categoryID",category.CategoryID},{"groupID",groupID},{"pageIndex",pageIndex},{"sortBy",friendliness}}) %>') " />
                                                <%=category.CategoryName%></label>
                                        </li>
                                        <%} %>
                                    </ul>
                                </div>
                            </li>
                            <%} %>
                            <li class="tn-list-action tn-helper-align-center"><span class="tn-action"><a class="tn-action-text editFriendModel"
                                href="<%=SPBUrlHelper.Action("Control_EditFriend", "Friend", new RouteValueDictionary { { "userDomainName", userDomainName }, { "friendID", friend.FriendID } }) %>">
                                编辑 </a></span><span class="tn-action"><a class="tn-action-text" href="<%=SPBUrlHelper.Action("DeleteFriend","Friend",new RouteValueDictionary{{"userDomainName",userDomainName},{ "keyWords", keyWords },{"friendID",friend.FriendID},{"groupID",groupID},{"pageIndex",pageIndex},{"friendliness",friendliness}}) %>"
                                    onclick="if (!confirm('<%=GetResourceString("Message_ConfirmDeleteFriend",friendApplicationID) %>')) return false;">
                                    <%=GetResourceString("Action_Delete")%></a></span></li>
                        </ul>
                    </div>
                    <div class="tn-list-item-area-main">
                        <div class="tn-list-item-row">
                            <cite>
                                <%=SPBHtmlHelper.Instance().UserDisplayNameLink(friend.FriendUserID,friend.FriendName, true) %></cite><em
                                    class="tn-count tn-text-note">（<%=string.Format(GetResourceString("Description_TotalFriendCount", ApplicationIDs.Instance().Friend()), friend.FriendUser.FriendCount)%>）</em>
                        </div>
                        <div class="tn-list-item-row tn-list-item-summary">
                            <div class="spb-i-said">
                                <%if (!friend.IsHidden)
                                      Response.Write("公开好友" + " | ");
                                  switch (friend.Friendliness)
                                  {
                                      case Friendliness.BosomFriend:
                                          Response.Write(GetResourceString("Enum_Friendliness_BosomFriend", friendApplicationID) + " | ");
                                          break;
                                      case Friendliness.GoodFriend:
                                          Response.Write(GetResourceString("Enum_Friendliness_GoodFriend", friendApplicationID) + " | ");
                                          break;
                                      case Friendliness.Friend:
                                          Response.Write(GetResourceString("Enum_Friendliness_Friend", friendApplicationID) + " | ");
                                          break;
                                      case Friendliness.Acquaintance:
                                          Response.Write(GetResourceString("Enum_Friendliness_Acquaintance", friendApplicationID) + " | ");
                                          break;
                                      case Friendliness.WithoutMeet:
                                          Response.Write(GetResourceString("Enum_Friendliness_WithoutMeet", friendApplicationID) + " | ");
                                          break;
                                  }
                                  if (selectedCategory != null)
                                  {%>
                                <%bool first = true;
                                  foreach (UserCategory category in selectedCategory)
                                  {
                                      if (first)
                                      {
                                          Response.Write(category.CategoryName);
                                          first = false;
                                      }
                                      else
                                      {
                                          Response.Write(string.Format(",{0}", category.CategoryName));
                                      }
                                  } %>
                            </div>
                            <%}%>
                            <%=friend.Remark %>
                        </div>
                    </div>
                </li>
                <%}%>
            </ul>
            </form>
            <div class="tn-pagination tn-helper-align-center">
                <% if (Model != null)
                   {%>
                <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex, 7, SPBUrlHelper.Action("Control_ListFriends", "Friend", new RouteValueDictionary { { "userDomainName", userDomainName }, { "keyWords", keyWords }, { "groupID", groupID }, { "pageIndex", "{0}" }, { "friendliness", friendliness }, { "isManager", true } }), "pageIndexChange")%>
                <%} %>
            </div>
        </div>
    </div>
    <script type="text/javascript">
    $(document).ready(function() {
    $("#listFriendForm").submit(function() {
             $('#listFriendForm').ajaxSubmit(
             { 
                 target: '#ManageFriends',
                  url: '<%=SPBUrlHelper.Action("UserSearch", "Friend", new RouteValueDictionary { { "userDomainName", userDomainName }})%>'
                   });
                   return false;
             });
    
        $('#exportFriendToCSV').nyroModal({
            resizeable: true,
            width: 300,
            height: 300
        });

        $('.editFriendModel,.editgroup').nyroModal({
            resizeable: true,
            width: 400,
            height: 350
        });

        $("#listFriendForm").validate({
            rules: {
                keyword: "required"
            },
            messages: {
                keyword: "*"
            }
        });

        $("#searchButton").click(function() {
            if (!$("#listFriendForm").valid()) {
                return false;
            }
            $("#listFriendForm").submit();
        });
        
        $("div.tn-avatar", $("#friendUL")).each(function() {
          var self = $(this);
         self.qtip(
         {
             content: '<div class="tn-loading"></div>',
             position: {
                 corner: {
                     target: 'rightTop',
                     tooltip: 'leftTop'
                 },
                 adjust: {
                     screen: true 
                 }
             },
             show: {
                    when: 'mouseover',
                    solo: true,
                    delay: 1000
                },
             hide: { when: 'mouseout', fixed: true, delay: 480 },
             style: {
                 tip: false,
                 border: {
                     width: 0,
                     radius: 0
                 },
				 background: 'none',
                 name: 'light', 
                 width: 325,
				 padding: 1
             },             
            api: { onShow: function() {
            if (self.qtip('api').elements.content.is(":has(div.tn-loading)"))
                $.get('<%=SPBUrlHelper.Action("Control_FriendCard", "Friend", new RouteValueDictionary { { "userDomainName", userDomainName } })%>', { id:self.attr("value") }, function(data) {
                    self.qtip('api').updateContent(data);
                });
            }
            }
         });
        });
        
        var friendDisplayName = [<%=ViewData.GetString("friendDisplayName",string.Empty) %>];
		$("#keyword").autocomplete({
			source: friendDisplayName
		});
		
		$("button[menu], a[menu]").menuButton();
		$("div.tn-list-header span[menu]").menuButton({ clickTrigger: true, notTriggerClose: ".tn-menu-list,.tn-menu input" });
		$("span[menu]").menuButton({clickTrigger: true,notTriggerClose:".tn-menu-drop-item *", buttonHoverClass:'ui-widget-content tn-action-hover'}).click(function(){
		            $("span[id^='optionButton']").removeClass("ui-widget-content tn-action-hover");
		            $(this).addClass("ui-widget-content tn-action-hover");
		}); 
    });
    function pageIndexChange(url) {
            $('#sortForLoad').load(url);
        }
    function ajaxSubmitTheForm(postUrl) {
                $('#listFriendForm').ajaxSubmit({ target: '#sortForLoad', url: postUrl });
        }
        
        function setFriendCategory(postUrl,friendID)
        {
        $('#listFriendForm').ajaxSubmit({ 
        target: '#sortForLoad', 
        url: postUrl,
        success:function(){
            $("#optionButton_"+friendID).click();
        } 
        });
        }
    </script>
</div>
