﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<Friend>>" %>
<%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
  PersonUser pu = Users.GetUser(userDomainName, false) as PersonUser;
%>
<ul id="friendUL" class="tn-list tn-helper-reset">
    <%foreach (var friend in ViewData.Model.Records)
      {
          if (friend.FriendUser == null)
              continue;
    %>
    <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
        <div class="tn-list-item-area-left">
            <div class="tn-avatar" value="<%=friend.FriendUserID %>,<%=friend.FriendID %>">
                <%=SPBHtmlHelper.Instance().ShowUserAvatar(friend.FriendUserID, true, HyperLinkTarget._self, AvatarSizeTypes.Small)%></div>
        </div>
        <div class="tn-list-item-area-right">
            <ul class="tn-list-actions tn-helper-reset">
                <%if (CurrentUser != null)
                  {
                      if (!Friends.IsFriend(CurrentUser.UserID, friend.FriendUserID))
                      {%>
                <li class="tn-list-action tn-border-gray tn-border-bottom"><a class="addFriendModal"
                    href="<%=SiteUrls.Instance().NewFriendInvitation(CurrentUser.UserName,friend.FriendUserID)%>">
                    <%= GetResourceString("Action_AddFriend")%></a></li>
                <%} %>
                <li class="tn-list-action tn-border-gray tn-border-bottom"><a href="<%=SiteUrls.Instance().NewMessage(CurrentUser.UserName,friend.FriendUserID) %>">
                    <%=GetResourceString("Action_SendMessage",ApplicationIDs.Instance().User())%></a></li>
                <%} %>
            </ul>
        </div>
        
        <div class="tn-list-item-area-main">
            <div class="tn-list-item-row">
                <cite><a href="<%=SiteUrls.Instance().UserChannelHome(friend.FriendUserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
                    class="tn-author">
                    <%=SPBHtmlHelper.Instance().UserDisplayName(friend.FriendUser.UserID)%></a></cite> <em class="tn-count tn-text-note">（<%=string.Format(GetResourceString("Description_TotalFriendCount",ApplicationIDs.Instance().Friend()),friend.FriendUser.FriendCount) %>）</em>
            </div>
            <div class="tn-list-item-row">
                <%string microblog = MicroBlogUserDatas.GetUserData(friend.FriendUserID, false).MostRecentThreadBody;
                  if (!string.IsNullOrEmpty(microblog))
                  { %>
                <div class="spb-i-said">
                    &nbsp;<span class="tn-icon tn-icon-quotes-before tn-icon-inline"></span>
                    <%=microblog%>
                    <span class="tn-icon tn-icon-quotes-after tn-icon-inline"></span>
                </div>
                <%}%>
            </div>
            <div class="tn-list-item-row">
                <p class="tn-text-note">
                    上次登录：<%=Formatter.FormatDate(friend.FriendUser.LastActivity) %></p>
            </div>
        </div>
    </li>
    <%}%>
</ul>
<div class="tn-pagination tn-helper-align-center">
    <% if (Model != null)
       {%>
    <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex, 7, SPBUrlHelper.Action("Control_ListFriends", "Friend", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pageIndex", "{0}" }, { "isManager", false } }), "pageIndexChange")%>
    <%} %>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $('.addFriendModal').nyroModal({
            resizeable: true
        });

        $("div.tn-avatar", $("#friendUL")).each(function() {
            var self = $(this);
            self.qtip(
         {
             content: '<div class="tn-loading"></div>',
             position: {
                 corner: {
                     target: 'rightTop',
                     tooltip: 'leftTop'
                 },
                 adjust: {
                     screen: true
                 }
             },
             show: {
                 when: 'mouseover',
                 solo: true,
                 delay: 1000
             },
             hide: { when: 'mouseout', fixed: true, delay: 480 },
             style: {
                 tip: false,
                 border: {
                     width: 0,
                     radius: 0
                 },
                 background: 'none',
                 name: 'light',
                 width: 325,
                 padding: 1
             },
             api: { onShow: function() {
                 if (self.qtip('api').elements.content.is(":has(div.tn-loading)"))
                     $.get('<%=SPBUrlHelper.Action("Control_FriendCard", "Friend", new RouteValueDictionary { { "userDomainName", userDomainName } })%>', { id: self.attr("value") }, function(data) {
                         self.qtip('api').updateContent(data);
                     });
             }
             }
         });
        });
    });
    function pageIndexChange(url) {
        $('#sortfriendForLoad').parent().load(url);
    }

</script>

