﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<UserCategory>>" %>
<%int groupID = Html.GetParameterFromRouteDateOrQueryString("groupID", 0);
  int friendApplicationID = ApplicationIDs.Instance().Friend();
  string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");%>
<div id="groupForLoad" class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <%if (ViewData.GetBool("isManager", false))
          {%><span class="tn-helper-right"><a href="<%=SPBUrlHelper.Action("ManageGroups","Friend",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"><%=GetResourceString("Action_Manage")%></a></span><%} %>
        <h3 class="tn-helper-reset">
            <%=GetResourceString("Title_FriendGroup", ApplicationIDs.Instance().Friend())%></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <ul class="tn-side-menu">
            <li <%if(groupID<=0){Response.Write(" class=\"tn-selected tn-widget-content tn-bg-light tn-corner-all\"");} %>>
                <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("Home","Friend",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <span>
                        <%=GetResourceString("Title_FriendGroupAll", ApplicationIDs.Instance().Friend())%>
                    </span></a></li>
            <%foreach (var category in ViewData.Model)
              {%>
            <li <%if(groupID==category.CategoryID){Response.Write(" class=\"tn-selected tn-widget-content tn-bg-light tn-corner-all\"");} %>>
                <a href="<%=SPBUrlHelper.Action("Home","Friend",new RouteValueDictionary{{"userDomainName",userDomainName},{"groupID",category.CategoryID}}) %>"
                    class="tn-menu-text">
                    <%=category.CategoryName%></a></li>
            <%}%>
        </ul>
        <%if (ViewData.GetBool("isManager", false))
          {%>
        <div class="tn-side-menu-action">
            <%=SPBHtmlHelper.Instance().LinkButton("newGroupModal",GetResourceString("Action_NewGroup", ApplicationIDs.Instance().Friend()),SPBUrlHelper.Action("Control_EditGroup", "UserDomain", new RouteValueDictionary { { "userDomainName", userDomainName }, { "multiUserCategoryItemKey", MultiUserCategoryItemKeys.Instance().Friend() } }), ButtonSizes.Default, HighlightStyles.Default,IconTypes.Add, TextIconLayout.IconText) %>
        </div>
        <%}%>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
    $('#newGroupModal').dialog({
        closeFn: function() {
        $('#groupForLoad').parent().load('<%=SPBUrlHelper.Action("Control_ListGroups","Friend",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>');
        }
    });
    
    }) 
</script>

