﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<spb:Script runat="server" ID="JqueryFormJs" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="artDialog" Src="~/Utility/jquery/plugin/jquery.artDialog.min-3.0.5.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="superfish" Src="~/Utility/jquery/plugin/jquery.superfish-1.4.8.js"
    SetExpireDays="30" />
<%
    
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("UserDomainName");
    User currentDomainUser = Users.GetUser(userDomainName, false);
    int notReadMessageCount = 0;
    int userApplicationID = ApplicationIDs.Instance().User();
    int unsettledInvitationTotalCount = 0;
    int notReadNoticeCount = 0;
    int applicationID = ViewData.GetInt("applicationID", -1);
    if (CurrentUser != null)
    {
        //获取未读消息
        notReadMessageCount = PrivateMessages.GetNoReadCount(CurrentUser.UserID);

        //获取未处理邀请字典集合
        Dictionary<int, int> unsettledInvitationCounts = Invitations.GetUnsettledCounts(CurrentUser.UserID);

        foreach (KeyValuePair<int, int> pair in unsettledInvitationCounts)
        {
            unsettledInvitationTotalCount += pair.Value;
        }
        notReadNoticeCount = InstationNotices.GetNoReadCount(CurrentUser.UserID);
    }
    int totalCount = notReadMessageCount + unsettledInvitationTotalCount + notReadNoticeCount;
    IList<Navigation> list = Navigations.GetDefaultNavgitions(PresentAreaIDs.Instance().Channel(), false);

    bool isUserDomainOwnerOrAdministrator = false;
    if (CurrentUser != null && (currentDomainUser.UserID == CurrentUser.UserID || CurrentUser.IsContentAdministrator || CurrentUser.IsAdministrator))
        isUserDomainOwnerOrAdministrator = true;
    int currentUserPresentAreaID = PresentAreaIDs.Instance().UserDomain();
    if (CurrentUser != null && CurrentUser.UserType == UserTypes.CompanyUser)
        currentUserPresentAreaID = PresentAreaIDs.Instance().CompanyUserDomain();
    int userID = CurrentUser != null ? CurrentUser.UserID : 0;
    bool isShow = ViewData.GetBool("isShow", false);
    IList<OwnerNavigation> currentUserNavigations = Navigations.GetOwnerNavigations(currentUserPresentAreaID, userID, true);
    IList<OwnerNavigation> currentDomainUserNavigations = Navigations.GetOwnerNavigations(PresentAreaIDs.Instance().UserDomain(), currentDomainUser.UserID, isUserDomainOwnerOrAdministrator);
    int count = UserDomainConfiguration.Instance().MaxApplicationMenuCount;
    if (count < 1) count = 1;
    if (count > currentDomainUserNavigations.Count) count = currentDomainUserNavigations.Count;
%>
<div class="spb-top-menubar">
    <div class="tn-wrapper-inner tn-helper-clearfix">
        <div class="spb-home-link">
            <span class="tn-icon tn-icon-home"></span>
            <a class="spb-top-logo-link" href="<%=SiteUrls.Instance().Home() %>">
                <%=Globals.SiteName %></a>
        </div>
        <div class="spb-user-menu">
            <% 
                if (CurrentUser != null)
                { %>
            <ul class="sf-menu">
                <li>
                    <a href="<%=Globals.GetFullUrlInMainSite(WebUtils.ResolveUrl("~/Help/Home.html")) %>"
                        target="_blank">
                        <%=GetResourceString("Common_Help")%></a></li>
                <li>
                    <a href="<%=SiteUrls.Instance().UserEditProfile(CurrentUser) %>" class="sf-with-ul">
                        账号设置</a>
                    <ul class="tn-widget tn-widget-content tn-bg-light tn-corner-all" style="visibility: hidden;
                        display: none;">
                        <li>
                            <a href="<%=SiteUrls.Instance().UserEditProfile(CurrentUser) %>">个人资料</a></li>
                        <li>
                            <a href="<%=SPBUrlHelper.Action("UploadAvatar", "UserDomainSettings", new RouteValueDictionary { {"userDomainName",currentDomainUser.UserName} })%>">
                                修改头像</a></li>
                        <li>
                            <a href="<%=SiteUrls.Instance().UserPrivacySettings(CurrentUser.UserName) %>">
                                <%=GetResourceString("Title_PrivacySettings", ApplicationIDs.Instance().User())%></a></li>
                        <li>
                            <a href="<%=SPBUrlHelper.Action("ManageApplications", "UserDomainSettings", new RouteValueDictionary { {"userDomainName",CurrentUser.UserName} })%>">
                                <%=GetResourceString("Title_ManageApplay", ApplicationIDs.Instance().User())%>
                            </a>
                        </li>
                        <li class="spb-separator tn-border-light tn-border-bottom"></li>
                        <li>
                            <a href="<%=SPBUrlHelper.Action("Logout","ChannelUser") %>">安全退出 </a>
                        </li>
                    </ul>
                </li>
                <li class="tn-msg-bubble-position">
                    <a id="messageCenter" href="<%=SiteUrls.Instance().ListMessageInBox(CurrentUser.UserName) %>"
                        class="sf-with-ul">
                        <%=GetResourceString("Navigation_UserDomain_MessageCenter")%></a>
                    <% if (totalCount > 0)
                       { %>
                    <span class="tn-msg-bubble">
                        <span class="tn-img-sprite tn-msg-bubble-left"></span>
                        <span class="tn-img-sprite tn-msg-bubble-center">
                            <%=totalCount %></span>
                        <span class="tn-img-sprite tn-msg-bubble-right"></span>
                    </span>
                    <%} %>
                    <ul class="tn-widget tn-widget-content tn-bg-light tn-corner-all" style="visibility: hidden;
                        display: none;">
                        <li>
                            <a href="<%=SiteUrls.Instance().ListMessageInBox(CurrentUser.UserName) %>">
                                <%=GetResourceString("Action_PrivateMessage")%>
                                <% if (notReadMessageCount > 0)
                                       Response.Write(string.Format("({0})", notReadMessageCount)); %>
                            </a>
                        </li>
                        <% if (CurrentUser.UserType == UserTypes.PersonUser)
                           { %>
                        <li>
                            <a href="<%=SiteUrls.Instance().ListInvitationInBox(CurrentUser.UserName) %>">
                                <%=GetResourceString("Action_Invitation")%>
                                <% if (unsettledInvitationTotalCount > 0)
                                       Response.Write(string.Format("({0})", unsettledInvitationTotalCount)); %>
                            </a>
                        </li>
                        <%} %>
                        <li>
                            <a href="<%=SiteUrls.Instance().ListNoticeRecords(CurrentUser.UserName) %>">
                                <%=GetResourceString("Action_Notice")%>
                                <% if (notReadNoticeCount > 0)
                                       Response.Write(string.Format("({0})", notReadNoticeCount)); %>
                            </a>
                        </li>
                    </ul>
                </li>
                <li class="tn-msg-bubble-position">
                    <a class="sf-with-ul" href="<%=SiteUrls.Instance().UserDomainHome(CurrentUser) %>">
                     <%=CurrentUser.DisplayName %></a>
                   <%if (CurrentUser == null || (currentDomainUser.UserID != CurrentUser.UserID) || CurrentUser.IsInRoles(SiteSettingsManager.GetSiteSettings().RoleNamesForEnterControlPanel))
                     {  %>
                    <ul class="tn-widget tn-widget-content tn-bg-light tn-corner-all" style="display: none;
                        visibility: hidden;">
                          <%  if (CurrentUser.IsInRoles(SiteSettingsManager.GetSiteSettings().RoleNamesForEnterControlPanel))
                            { %>
                        <li>
                            <a href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().UserDomainHome(CurrentUser.UserName))%>">
                                <% if (CurrentUser.UserType == UserTypes.PersonUser) Response.Write(GetResourceString("Navigation_UserDomain_MyHome")); else Response.Write(GetResourceString("Navigation_UserDomain_Home"));%></a></li>
                        
                        <li class="spb-separator tn-border-light tn-border-bottom"></li>
                        <li>
                            <a target="_blank" href="<%=SiteUrls.Instance().ManageHome() %>">
                                <%=GetResourceString("Navigation_Manage_Home")%></a></li>
                        <%} 
                    if (currentUserNavigations != null)
                    {
                        if (CurrentUser == null || (currentDomainUser.UserID != CurrentUser.UserID))
                        { 
                                 %>
                     
                        <% 
                            foreach (OwnerNavigation navigation in currentUserNavigations)
                            {
                                if (!navigation.IsVisible(true))
                                    continue;                            
                        %>
                        <li>
                            <a href="<%=navigation.GetUserNavigationUrl(CurrentUser.UserName) %>">
                                <%=string.Format(GetResourceString("Navigation_Pattern_MyNavigation"), navigation.GetMultilingualNavigationName(CurrentUserLanguage))%></a></li>
                        <%}
                        }
                                 }
                            %>
                    </ul>
                    <%} %>
                </li>
            </ul>
            <%}
                else
                { %>
            <ul id="AnonymousPanel" class="sf-menu">
                <li>
                    <a href="<%=SiteUrls.Instance().HelpHome() %>" target="_blank">
                        <%=GetResourceString("Common_Help")%></a></li>
                         <%if (SiteSettingsManager.GetSiteSettings().RegistrationMode == RegistrationModes.EnableAll)
                  { %>
                <li>
                    <a href="<%=SiteUrls.Instance().UserRegister() %>">
                        <%=GetResourceString("Action_Register")%></a></li>
                        <%} %>
                <li>
                    <a href="<%=SiteUrls.Instance().LoginInModal() %>" id="loginInModalButton">
                        <%=GetResourceString("Action_Login")%></a></li>
            </ul>
            <%} %>
        </div>
    </div>
</div>
<div class="spb-branding-area">
    <div class="tn-wrapper-inner">
        <div class="spb-profile-card tn-helper-clearfix">
            <div class="spb-profile-avatar">
                <div class="tn-avatar">
                    <%
                        if (CurrentUser != null && CurrentUser.UserID == currentDomainUser.UserID)
                            Response.Write(SPBHtmlHelper.Instance().ShowUserAvatar(currentDomainUser, false, HyperLinkTarget._self, AvatarSizeTypes.Small, false, new RouteValueDictionary()));
                        else
                            Response.Write(SPBHtmlHelper.Instance().ShowUserAvatar(currentDomainUser, false, HyperLinkTarget._self, AvatarSizeTypes.Small, true, new RouteValueDictionary()));
                    %>
                </div>
            </div>
            <div class="spb-profile">
                <h1 class="tn-user-name">
                    <%=SPBHtmlHelper.Instance().UserDisplayName(currentDomainUser.UserID,true) %>              
                </h1>
            
                <span class="spb-user-type">
                    <a href="<%=SPBUrlHelper.Action("TotalUserPoints","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                        <%=SPBHtmlHelper.Instance().ShowUserRankIcons(currentDomainUser)%></a></span><em
                            class="tn-text-note">（<%=string.Format(GetResourceString("Label_PeopleVisit"),currentDomainUser.HitTimes) %>）</em>
            </div>
            <div class="spb-status">
                <%MicroBlogUserData userData = null;
                  userData = MicroBlogUserDatas.GetUserData(currentDomainUser.UserID, CurrentUser != null && currentDomainUser.UserID == CurrentUser.UserID);
                  if (userData != null && !string.IsNullOrEmpty(userData.MostRecentThreadBody))
                  {
                      Response.Write(userData.MostRecentThreadBody); %>
                <em class="tn-text-note">
                    <%=Formatter.FormatFriendlyDate(userData.MostRecentThreadDate)%></em><a href="<%= SiteUrls.Instance().UserMicroBlogHome(currentDomainUser.UserID,CurrentUser) %>"><%=GetResourceString("Action_More")%></a>
                <%} %>
            </div>
        </div>
    </div>
</div>
<div class="spb-nav1-area">
    <div class="tn-wrapper-inner tn-helper-clearfix">
        <%if (isShow)
          {%>
        <div class="tn-shortcut">
            <% 
                PresentArea presentArea = PresentAreas.GetPresentArea(PresentAreaIDs.Instance().UserDomain(), false);
                if (isUserDomainOwnerOrAdministrator && presentArea != null && presentArea.EnableThemes && CurrentUser.UserType == UserTypes.PersonUser)
                {%>
            <%=SPBHtmlHelper.Instance().LinkButton("modifyHome", "空间装扮",SPBUrlHelper.Action("ModifyHome","UserDomainSettings",new RouteValueDictionary {{"userDomainName",currentDomainUser.UserName} }), ButtonSizes.Default, HighlightStyles.Primary, IconTypes.Dress, TextIconLayout.IconText)%>
            <%} %>
            <% if (CurrentUser != null && CurrentUser.UserName != userDomainName && !Friends.IsFriend(CurrentUser.UserID, currentDomainUser.UserID))
               {%>
            <%=SPBHtmlHelper.Instance().LinkButton("addFriend", "加为好友", SiteUrls.Instance().NewFriendInvitation(CurrentUser.UserName, currentDomainUser.UserID), ButtonSizes.Default, HighlightStyles.Primary, IconTypes.UserAdd, TextIconLayout.IconText, new RouteValueDictionary { { "class", "nyroModal" } }, null)%>
            <%} %>
        </div>
        <%} %>
        <ul class="spb-nav1 tn-helper-reset tn-helper-clearfix sf-menu">
            <%             
                string homeUrl = SiteUrls.Instance().UserDomainHome(userDomainName);
                //空间主人查看自己的空间主页使用单独的主页网址  
                string myhomeUrl = SiteUrls.Instance().UserMessageHome(currentDomainUser);          
                if (CurrentUser != null && CurrentUser.UserName == userDomainName)
                {
                    homeUrl = SiteUrls.Instance().UserDomainMasterHome(userDomainName);
                    
                }
             
            %>
            <%if (CurrentUser != null && (currentDomainUser.UserID == CurrentUser.UserID))
              { %>
           <li id='myHome' <% if(applicationID== UserDomainSpecialAppIDs.Instance().MyHome()){ Response.Write("class=\"spb-nav-item tn-selected\""); }  else {Response.Write("class=\"spb-nav-item\"");} %>>
                <a href="<%=SPBUrlHelper.Action("Home", "UserDomain", new RouteValueDictionary { { "userDomainName", userDomainName } }) %>">
                    <span>
                        <% Response.Write(GetResourceString("Navigation_UserDomain_MyHome"));%>
                    </span>
                </a>
            </li>
            <%} %>
            <li id='home' <% if(applicationID== UserDomainSpecialAppIDs.Instance().Home()){ Response.Write("class=\"spb-nav-item tn-selected\""); }  else {Response.Write("class=\"spb-nav-item\"");} %>>
                <a href="<%=homeUrl %>">
                    <span>
                        <% if (isUserDomainOwnerOrAdministrator) Response.Write(GetResourceString("Navigation_UserDomain_Home")); else Response.Write(GetResourceString("Navigation_UserDomain_Home_ToOtherUser"));%>
                    </span>
                </a>
            </li>
            <li id='profile' <% if(applicationID== UserDomainSpecialAppIDs.Instance().Profile()){ Response.Write("class=\"spb-nav-item tn-selected\""); }  else {Response.Write("class=\"spb-nav-item\"");} %>>
                <a href="<%=SPBUrlHelper.Action("ShowProfile", "UserDomain", new RouteValueDictionary { { "userDomainName", userDomainName } })%>">
                    <span>
                        <%=GetResourceString("Title_Profile") %></span></a></li>
            <% 
                int i = 0;//遍历序号
                int j = 0;//已显示的导航个数
                foreach (OwnerNavigation navigation in currentDomainUserNavigations)
                {
                    i++;
                    if (!navigation.IsVisible(isUserDomainOwnerOrAdministrator))
                        continue;
                    j++;
                    if (j <= count)
                    {                    
            %>
            <li <% if(applicationID==navigation.ApplicationID){ Response.Write("class=\"spb-nav-item tn-selected\""); } else {Response.Write("class=\"spb-nav-item\"");} %>>
                <a href="<%=navigation.GetUserNavigationUrl(currentDomainUser.UserName) %>" target="<%=navigation.NavigationTarget %>"
                    value="<%=navigation.ApplicationID %>">
                    <span>
                        <%=navigation.GetMultilingualNavigationName(CurrentUserLanguage)%></span></a></li>
            <%
                if (i == currentDomainUserNavigations.Count)
                {
            %>
            <% 
                break;
                }
                    }
                    if (j == count)
                    {%>
            <%} if (j == count + 1)
                    { %>
            <li class="spb-nav-item">
                <a href="javascript:;">
                    <span>&nbsp;</span></a>
                <ul style="display: none; visibility: hidden;">
                    <% }
                    if (j > count)
                    { %><li>
                        <a href="<%=navigation.GetUserNavigationUrl(currentDomainUser.UserName) %>">
                            <%=navigation.GetMultilingualNavigationName(CurrentUserLanguage)%></a></li>
                    <%}%>
                    <%}%>
                    <%if (i == currentDomainUserNavigations.Count && j > count)
                      { %>
                    <% if (isUserDomainOwnerOrAdministrator)
                       { %>
                    <li class="spb-separator"></li>
                    <li>
                        <a href="<%=SPBUrlHelper.Action("ManageUserNavigations", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", currentDomainUser.UserName } })%>">
                            <%=GetResourceString("Title_NavigationsSettings",ApplicationIDs.Instance().User())%>
                        </a>
                    </li>
                    <%} %>
                </ul>
            </li>
        </ul>
        <%}%>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $('ul.sf-menu').superfish();
        $('#loginInModalButton').dialog({
                id: 'loginDialog',
                title: '登录',
                width: 400             
            });
      if(<%=totalCount %> > 0)
      newMessageHint('<%=GetResourceString("Description_NewMessage")%>');

    });  
</script>

