﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
    <%   
        if (TempData["StatusMessageData"] != null)
        {
            StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
            if (statusMessageData.MessageType == StatusMessageType.Success)
            {
                Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
            }
            TempData["StatusMessageData"] = null;
        }
        UserExpiredDataType userExpiredDataType = UserExpiredDataType.FriendActivity;
        if (ViewData["UserExpiredDataType"] != null)
            userExpiredDataType = (UserExpiredDataType)ViewData["UserExpiredDataType"];
    %>
    <form id="DeleteUserExpiredDataForm" name="DeleteUserExpiredDataForm" class="tn-helper-reset nyroModal"
    action="<%=SPBUrlHelper.Action("ExecDeleteUserExpiredData", "MessageCenter", new RouteValueDictionary { { "userDomainName", Html.GetParameterFromRouteDateOrQueryString("userDomainName") }, { "userExpiredDataType", userExpiredDataType } })%>"
    method="post">
              <div class="tn-form tn-label-right">
<h4 class="tn-text-heading tn-border-gray tn-border-bottom">
        <%=GetResourceString("Title_DeleteActivities",ApplicationIDs.Instance().User()) %></h4>
       <div class="tn-form-row">
        
        <span class="tn-text-note">
            <%=GetResourceString("Description_DeleteActivitiesDescription",ApplicationIDs.Instance().User()) %></span>
    </div>
        
        
    <div class="tn-form-row">
        <label class="tn-form-label">
            <%=GetResourceString("Label_Date") %><%=GetResourceString("Common_Colon") %></label>
        <select name="beforeDays" class="tn-dropdownlist">
            <option value="1">
                <%=string.Format(GetResourceString("Common_Pattern_DayAgo",ApplicationIDs.Instance().User()),1) %></option>
            <option value="3">
                <%=string.Format(GetResourceString("Common_Pattern_DayAgo",ApplicationIDs.Instance().User()),3) %></option>
            <option value="7">
                <%=string.Format(GetResourceString("Common_Pattern_WeeksAgo", ApplicationIDs.Instance().User()), 1)%></option>
            <option value="14">
                <%=string.Format(GetResourceString("Common_Pattern_WeeksAgo", ApplicationIDs.Instance().User()), 2)%></option>
            <option value="30">
                <%=string.Format(GetResourceString("Common_Pattern_MonthsAgo", ApplicationIDs.Instance().User()), 1)%></option>
            <option value="90">
                <%=string.Format(GetResourceString("Common_Pattern_MonthsAgo", ApplicationIDs.Instance().User()), 3)%></option>
            <option value="180">
                <%=string.Format(GetResourceString("Common_Pattern_MonthsAgo", ApplicationIDs.Instance().User()), 6)%></option>
            <option value="365">
                <%=string.Format(GetResourceString("Common_Pattern_YearAgo", ApplicationIDs.Instance().User()), 1)%></option>
        </select>
    </div>
    <div class="tn-form-row tn-form-row-button">
        <label class="tn-form-label">
        </label>
        <%=SPBHtmlHelper.Instance().SubmitButton("submit", GetResourceString("Button_OK"),ButtonSizes.Default,null,null)%>
        <%=SPBHtmlHelper.Instance().Button("channel", GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Default, new RouteValueDictionary { { "class", "nyroModalClose" } }, null)%>
    
    </div>
    </div>
    </form>
