﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<PrivateMessageInboxItem>>" %>
<%     string userDomainName = Html.GetParameterFromRouteDateOrQueryString("UserDomainName");
%>
<div id="ListMessageInBoxDiv">
    <div class="tn-list-header">
        <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
            <div class="tn-pagination tn-helper-align-right tn-helper-right">
                <span class="tn-page-results tn-text-note">
                    <%=string.Format(GetResourceString("Label_MessageInBoxInfo",ApplicationIDs.Instance().User()),ViewData.Model.TotalRecords,ViewData.GetInt("NoReadCount",0)) %>
                </span>
            </div>
            <input type="checkbox" id="TopCheckBox" class="tn-checkbox" onclick="checkAll(this,'MessageInBoxCheckBoxGroup')" />
            <label class="tn-check-all" for="TopCheckBox">
                <%=GetResourceString("Label_SelectAllOrNo") %></label>
            <%=SPBHtmlHelper.Instance().LinkButton("read", GetResourceString("Action_MessageSetRead", ApplicationIDs.Instance().User()),"javascript:;", ButtonSizes.Default, HighlightStyles.Default,IconTypes.EmailOpen,TextIconLayout.IconText, new RouteValueDictionary { { "onclick", "operate('read')" } }, null)%>
            <%=SPBHtmlHelper.Instance().LinkButton("noread", GetResourceString("Action_MessageSetNoRead", ApplicationIDs.Instance().User()), "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Email, TextIconLayout.IconText, new RouteValueDictionary { { "onclick", "operate('noread')" } }, null)%>
            <%=SPBHtmlHelper.Instance().LinkButton("delete", GetResourceString("Action_Delete", ApplicationIDs.Instance().User()), "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary { { "onclick", "operate('delete')" } }, null)%>
        </div>
    </div>
    <form id="ListMessageInBoxForm" method="post">
    <table class="tn-table-grid">
        <tbody>
            <%foreach (PrivateMessageInboxItem message in ViewData.Model.Records)
              {%>
            <tr class="tn-table-grid-row <%if (!message.IsRead) Response.Write(" tn-unread"); %>">
                <td class="tn-border-gray tn-border-bottom tn-width0">
                    <input type="checkbox" name="MessageInBoxCheckBoxGroup" class="tn-checkbox" value="<%=message.ThreadID %>" />
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width1">
                    <div class="tn-avatar">
                        <% if (message.MessageType == PrivateMessageType.Serve)
                           { %>
                        <img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/ServeAvatar.gif") %>"
                            width="46" height="46" />
                        <%}
                           else if (message.MessageType == PrivateMessageType.System)
                           {%>
                        <img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/SystemAvatar.gif") %>"
                            width="46" height="46" />
                        <% }
                           else
                           {
                               if (message.SenderUserID > 0)
                               { %>
                        <%=SPBHtmlHelper.Instance().ShowUserAvatar(message.SenderUserID, true, HyperLinkTarget._self, AvatarSizeTypes.Small,null)%>
                        <%}
                       }%>
                    </div>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width2">
                    <cite>
                        <% if (message.SenderUserID > 0)
                           { %>
                        <a class="tn-user-name" href="<%=SiteUrls.Instance().UserChannelHome(message.SenderUserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
                            title="<%=string.Format(GetResourceString("Description_Pattern_ViewUserDomain"), message.Sender)%>">
                            <%=message.Sender %></a>
                        <%}
                           else Response.Write(message.Sender); %></cite> <em class="tn-date tn-text-note">
                           <%=Formatter.FormatFriendlyDate(message.MostRecentPostDate) %></em>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width3">
                    <%if (message.IsRead)
                          Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.EmailOpen));
                      else
                          Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Email));  %>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width4">
                    <cite><a class="tn-subject" href="<%=SiteUrls.Instance().ShowPrivateMessage(userDomainName,message.ThreadID) %>"
                        title="<%=message.MostRecentPostSubject %>">
                        <%=StringUtils.Trim(message.MostRecentPostSubject, 30) %></a></cite><span class="tn-snippet"><%=HtmlUtils.TrimHtml(message.MostRecentPostBody, 30) %></span>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width5">
                    <%if (!message.IsLocked)
                      { %>
                    <%=SPBHtmlHelper.Instance().LinkButton("reply", SiteUrls.Instance().ShowPrivateMessage(userDomainName, message.ThreadID)+"#reply", HighlightStyles.Lite, IconTypes.Bubble)%>
                    <%} %>
                    <% int returnToPageIndex = ViewData.Model.PageIndex;
                       if ((ViewData.Model.TotalRecords == ViewData.Model.PageSize * (returnToPageIndex - 1) + 1) && (ViewData.Model.PageIndex > 1))
                       {
                           returnToPageIndex = ViewData.Model.PageIndex - 1;
                       } %>
                    <%=SPBHtmlHelper.Instance().LinkButton("del",HighlightStyles.Lite,IconTypes.Cross,new RouteValueDictionary {{"onclick","if (confirm('"+GetResourceString("Message_ConfirmDeleteThisMessage",ApplicationIDs.Instance().User()) +"')) { $('#ListMessageInBoxDiv').load('"+SPBUrlHelper.Action("DeleteInBoxMessage","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"threadID",message.ThreadID},{"pageIndex",returnToPageIndex}})+"'); }"}},null)%>
                </td>
            </tr>
            <%} %>
        </tbody>
    </table>
    </form>
    <div class="tn-pagination tn-helper-align-center">
        <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11, SPBUrlHelper.Action("Control_ListMessageInBox", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
        <div class="tn-page-results tn-text-note">
            <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
    </div>

    <script type="text/javascript">
        function pageIndexChange(url) {
            $('#ListMessageInBoxDiv').load(url);
        }
        function operate(action) {
            if (action == 'read')
                $('#ListMessageInBoxForm').ajaxSubmit({ target: '#ListMessageInBoxDiv', url: '<%=SPBUrlHelper.Action("SetMessageReadStatus","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"pageIndex",Model.PageIndex},{"isread",true}}) %>' });
            else if (action == 'noread')
                $('#ListMessageInBoxForm').ajaxSubmit({ target: '#ListMessageInBoxDiv', url: '<%=SPBUrlHelper.Action("SetMessageReadStatus","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"pageIndex",Model.PageIndex},{"isread",false}}) %>' });
            else if (action == 'delete') {
                if (confirm('<%=GetResourceString("Message_ConfirmDeleteMessage",ApplicationIDs.Instance().User()) %>')) {
                    $('#ListMessageInBoxForm').ajaxSubmit({ target: '#ListMessageInBoxDiv', url: '<%=SPBUrlHelper.Action("DeleteInBoxMessages","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>' });
                }
            }
        }
    </script>

</div>
