﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<PrivateMessageOutboxItem>>" %>
<form id="ListMessageOutBoxForm" method="post">
<%     string userDomainName = Html.GetParameterFromRouteDateOrQueryString("UserDomainName");
%>
<div class="tn-list-header">
    <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
        <input type="checkbox" id="TopCheckBox" class="tn-checkbox" onclick="checkAll(this,'MessageOutBoxCheckBoxGroup')" />
        <label class="tn-check-all" for="TopCheckBox">
            <%=GetResourceString("Label_SelectAllOrNo") %></label>
        <%=SPBHtmlHelper.Instance().LinkButton("delete", GetResourceString("Action_Delete", ApplicationIDs.Instance().User()), string.Empty, ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary { { "onclick", "deleteMessage()" } }, null)%>
    </div>
</div>
<table class="tn-table-grid">
    <tbody>
        <%foreach (PrivateMessageOutboxItem message in ViewData.Model.Records)
          { %>
        <tr class="tn-table-grid-row">
            <td class="tn-border-gray tn-border-bottom tn-width0">
                <input type="checkbox" name="MessageOutBoxCheckBoxGroup" class="tn-checkbox" value="<%=message.ThreadID %>" />
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width1">
                <div class="tn-avatar">
                    <%if (message.ReceiverUserID > 0)
                      { %>
                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(message.ReceiverUserID, true, HyperLinkTarget._self, AvatarSizeTypes.Small, null)%>
                    <%}
                      else
                      {%>
                    <img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/ServeAvatar.gif") %>"
                        width="46" height="46" />
                    <%} %>
                </div>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width2">
                <cite>
                    <%=GetResourceString("Label_InvitTo",ApplicationIDs.Instance().User()) %><a class="tn-user-name"
                        href="<%=SiteUrls.Instance().UserChannelHome(message.ReceiverUserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
                        title="<%=string.Format(GetResourceString("Description_Pattern_ViewUserDomain"), message.Receiver)%>">
                        <%=message.Receiver%></a></cite> <em class="tn-date tn-text-note">
                            <%=Formatter.FormatFriendlyDate(message.MostRecentPostDate) %></em>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width4">
                <cite><a class="tn-subject" href="<%=SiteUrls.Instance().ShowPrivateMessage(userDomainName,message.ThreadID) %>"
                    title="<%=message.MostRecentPostSubject %>">
                    <%=StringUtils.Trim(message.MostRecentPostSubject, 30) %></a></cite><span class="tn-snippet"><%=HtmlUtils.TrimHtml(message.MostRecentPostBody, 30)%></span>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width5">
                <%if (!message.IsLocked)
                  { %>
                <%=SPBHtmlHelper.Instance().LinkButton("reply", SiteUrls.Instance().ShowPrivateMessage(userDomainName, message.ThreadID)+"#reply", HighlightStyles.Lite, IconTypes.Bubble)%>
                <%} %>
                <% int returnToPageIndex = ViewData.Model.PageIndex;
                   if ((ViewData.Model.TotalRecords == ViewData.Model.PageSize * (returnToPageIndex - 1) + 1) && (ViewData.Model.PageIndex > 1))
                   {
                       returnToPageIndex = ViewData.Model.PageIndex - 1;
                   } %>
                <%=SPBHtmlHelper.Instance().LinkButton("del", HighlightStyles.Lite, IconTypes.Cross, new RouteValueDictionary { { "onclick", "if (confirm('" + GetResourceString("Message_ConfirmDeleteThisMessage", ApplicationIDs.Instance().User()) + "')) { $('#ListMessageOutBoxDiv').load('" + SPBUrlHelper.Action("DeleteOutBoxMessage", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "threadID", message.ThreadID }, { "pageIndex", returnToPageIndex } }) + "'); }" } }, null)%>
            </td>
        </tr>
        <%} %>
    </tbody>
</table>
<div class="tn-pagination tn-helper-align-center">
    <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex,11, SPBUrlHelper.Action("Control_ListMessageOutBox","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"pageIndex","{0}"}}), "pageIndexChange")%>
    <div class="tn-page-results tn-text-note">
        <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
</div>
</form>
<script type="text/javascript">
    function pageIndexChange(url) {
        $('#ListMessageOutBoxDiv').load(url);
    }
    function deleteMessage() {
        if (confirm('<%=GetResourceString("Message_ConfirmDeleteMessage",ApplicationIDs.Instance().User()) %>')) { $('#ListMessageOutBoxForm').ajaxSubmit({ target: '#ListMessageOutBoxDiv', url: '<%=SPBUrlHelper.Action("DeleteOutBoxMessages","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>' }); }
    }
</script>
