﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<InstationNoticeRecord>>" %>

<div id="ListNoticeRecordsDiv" class="tn-box tn-widget tn-widget-content tn-corner-all">
  <div class="tn-box-content tn-widget-content tn-corner-all">
    <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("UserDomainName"); %>
    <form id="ListNoticeRecordsForm" method="post">
      <div class="tn-list-header">
        <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
          <div class="tn-helper-right"> <a href="<%=SPBUrlHelper.Action("NoticeSettings", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName } })%>"> <%=GetResourceString("Title_NoticeSettings",ApplicationIDs.Instance().User())%></a> </div>
          <div class=" tn-helper-left"> <%=string.Format(GetResourceString("Label_NoticeRecordInfo",ApplicationIDs.Instance().User()), ViewData.Model.TotalRecords ) %></div>
        </div>
      </div>
      <ul class="tn-list tn-helper-reset">
        <%foreach (InstationNoticeRecord record in ViewData.Model.Records)
              { %>
            <%--<li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom" id="MessageRow">
                <em class="tn-text-note tn-date">
                    <%=Formatter.FormatFriendlyDate(record.DateCreated)%></em>
                <h5>
                    <%=record.Subject %>
                </h5>
                <p title="<%=HtmlUtils.StripAllTags(record.Body) %>">
                    <%=HtmlUtils.TrimHtml(record.Body, 80) %></p>
            </li>--%>
            
            
            
              <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
            <div class="tn-list-item-area-left">
                
            </div>
            <div class="tn-list-item-area-right">

            </div>
            <div class="tn-list-item-area-main">
                <div class="tn-list-item-row">
                   
                         <%=record.Subject %><em class="tn-text-note tn-date">  <%=Formatter.FormatFriendlyDate(record.DateCreated)%></em></div>
                <div class="tn-list-item-row tn-list-item-summary">
                    <p class="tn-helper-reset" title="<%=HtmlUtils.StripAllTags(record.Body) %>">
                    <%=HtmlUtils.TrimHtml(record.Body, 40) %>
                    
                    </p>
                    <div class="tn-list-item-row">
                       
                    </div>
                </div>
            </div>
        </li>
        <%} %>
      </ul>
      <div class="tn-pagination tn-helper-align-center"> <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11, SPBUrlHelper.Action("Control_ListNoticeRecords", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
        <div class="tn-page-results tn-text-note"> <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
      </div>
    </form>
    <script type="text/javascript">
            function pageIndexChange(url) {
                $('#ListNoticeRecordsDiv').parent().load(url);
            }
        </script>
  </div>
</div>
