﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%
    int appID = int.Parse(ViewData["appID"].ToString());
    int type = int.Parse(ViewData["type"].ToString());
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");

    List<PermissionItem> ListPItem = null;
    List<Role> ListRole = null;
    List<UserRank> ListRank = null;
    Dictionary<int, PermissionCollection> DicPerCollection = null;
    if (ViewData["ListPItem"] != null)
    {
        ListPItem = ViewData["ListPItem"] as List<PermissionItem>;
        if (type == 0)
        {
            ListPItem = (from lp in ListPItem
                         where lp.EnabledInUserRole == true
                         select new PermissionItem
                         {
                             ItemKey = lp.ItemKey,
                             ItemName = lp.ItemName,
                         }).ToList();
        }
        else
        {
            ListPItem = (from lp in ListPItem
                         where lp.EnabledInUserRank == true
                         select new PermissionItem
                         {
                             ItemKey = lp.ItemKey,
                             ItemName = lp.ItemName,
                         }).ToList();
        }
    }
    if (ViewData["ListRole"] != null)
    {
        ListRole = ViewData["ListRole"] as List<Role>;
    }
    if (ViewData["DicPerCollection"] != null)
    {
        DicPerCollection = ViewData["DicPerCollection"] as Dictionary<int, PermissionCollection>;
    }
    if (ViewData["ListRank"] != null)
    {
        ListRank = ViewData["ListRank"] as List<UserRank>;
    }           
%>
<div class="ui-tabs ui-widget ui-widget-content ui-corner-all" style="width:950px; overflow-x:scroll;overflow-y:hidden">
    <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
        <%
            Dictionary<int, Application> dic = null;
            if (ViewData["DicApplication"] != null)
            {
                dic = ViewData["DicApplication"] as Dictionary<int, Application>;
            }
            if (dic != null)
            {
                string str = "<li {0}><a href=\"{1}\" target=\"_self\"><span>{2}</span></a></li>";
                string strUrl = "";
                foreach (var item in dic.Values)
                {
                    string strClass = "class=\"ui-state-default ui-corner-top\"";
                    if (item.ApplicationID == appID)
                        strClass = "class=\"ui-state-default ui-corner-top ui-tabs-selected ui-state-active\"";
                    strUrl = SPBUrlHelper.Action("ListPermission", "MessageCenter", new RouteValueDictionary { { "AppID", item.ApplicationID }, { "userDomainName", userDomainName } });
                    Response.Write(string.Format(str, strClass, strUrl, item.GetMultilingualApplicationName(CurrentUserLanguage)));
                }
            }
        %>
    </ul>

    <div class="tn-list-header">
        <div class="tn-toolbar-area tn-helper-clearfix">
            <select class="tn-dropdownlist" onchange="window.location.href='?appID=<%=Request.QueryString.GetInt("appID",ApplicationIDs.Instance().Forum()) %>&type='+$(this).val()+'&userDomainName=<%=userDomainName %>';">
                <option value="1">按级别设置</option>
                <option value="0" <%if(type==0) Response.Write("selected"); %>>按角色设置</option>
            </select>
        </div>
    </div>
    <%if (type == 0)
      { %>
    <table class="tn-table-grid">
        <tr class="tn-table-grid-header">
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                角色
            </th>
            <%
                if (ListPItem != null)
                {
                    string strTH = "<th   class=\"tn-border-gray tn-border-bottom tn-text-note\">{0}</th>";
                    foreach (var item in ListPItem)
                    {
                        Response.Write(string.Format(strTH, item.ItemName));
                    }
                }
            %>
        </tr>
        <%
            if (ListRole != null)
            {
                foreach (var item in ListRole)
                {
        %>
        <tr class="tn-table-grid-row">
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <%=item.FriendlyRoleName %>
            </td>
            <%
                if (ListPItem != null && DicPerCollection != null)
                {
                    string strTH = "<td class=\"tn-border-gray tn-border-bottom tn-nowrap\"><img src=\"{0}\" style=\"border-width: 0px;\" />{1}</td>";

                    foreach (var Pitem in ListPItem)
                    {
                        try
                        {
                            if (item.RoleName == "SystemAdministrator" || item.RoleName == "ContentAdministrator")
                                Response.Write(string.Format(strTH, Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Icons/icon_true_red.gif"), string.Empty));
                            else
                            {
                                if (DicPerCollection[item.RoleID][Pitem.ItemKey].IsLocked)
                                {
                                    if (DicPerCollection[item.RoleID][Pitem.ItemKey].AllowType == AllowTypes.Allow)
                                        Response.Write(string.Format(strTH, Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Icons/icon_true_red.gif"), string.Empty));
                                    else if (DicPerCollection[item.RoleID][Pitem.ItemKey].AllowType == AllowTypes.NotSet)
                                        Response.Write("<td class=\"tn-border-gray tn-border-bottom tn-nowrap\">---</td>");
                                    else
                                        Response.Write(string.Format(strTH, Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Icons/icon_false_red.gif"), string.Empty));
                                }
                                else
                                {
                                    if (DicPerCollection[item.RoleID][Pitem.ItemKey].AllowType == AllowTypes.Allow)
                                        Response.Write(string.Format(strTH, Globals.GetFullUrlInResourceSite("~/Themes/Manages/Default/Appearances/Default/Images/icon_true.gif"), string.Empty));
                                    else if (DicPerCollection[item.RoleID][Pitem.ItemKey].AllowType == AllowTypes.NotSet)
                                        Response.Write("<td class=\"tn-border-gray tn-border-bottom tn-nowrap\">未设置</td>");
                                    else
                                        Response.Write(string.Format(strTH, Globals.GetFullUrlInResourceSite("~/Themes/Manages/Default/Appearances/Default/Images/icon_false.gif"), string.Empty));
                                }
                            }
                        }
                        catch
                        { Response.Write("<td class=\"tn-border-gray tn-border-bottom tn-nowrap\">未设置</td>"); }
                    }
                }
            %>
        </tr>
        <%
            }
                }
        %>
    </table>
    <div>
        <br />
        图例说明：<img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Icons/icon_true_red.gif")%>" />允许(不可修改)&nbsp;&nbsp;&nbsp;&nbsp;
        <img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Icons/icon_false_red.gif")%>" />禁止(不可修改)&nbsp;&nbsp;&nbsp;&nbsp;
        <img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Manages/Default/Appearances/Default/Images/icon_true.gif") %>" />允许&nbsp;&nbsp;&nbsp;&nbsp;
        <img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Manages/Default/Appearances/Default/Images/icon_false.gif")%>" />禁止&nbsp;&nbsp;&nbsp;&nbsp;
        --- 无实际意义
    </div>
    <%
        }
      else
      {
    %>
    <table class="tn-table-grid" style="overflow:scroll;">
        <tr class="tn-table-grid-header">
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                级别
            </th>
            <%
                if (ListPItem != null)
                {
                    string strTH = "<th class=\"tn-border-gray tn-border-bottom tn-text-note\">{0}</th>";
                    foreach (var item in ListPItem)
                    {
                        Response.Write(string.Format(strTH, item.ItemName));
                    }
                }
            %>
        </tr>
        <%
            if (ListRank != null)
            {
                foreach (var item in ListRank)
                {
        %>
        <tr class="tn-table-grid-row">
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <%=item.Rank %>级
            </td>
            <%
                if (ListPItem != null && DicPerCollection != null)
                {
                    string strTH = "<td class=\"tn-border-gray tn-border-bottom tn-nowrap\"><img src=\"{0}\" style=\"border-width: 0px;\" />{1}</td>";

                    foreach (var Pitem in ListPItem)
                    {
                        try
                        {
                            if (DicPerCollection[item.Rank][Pitem.ItemKey].IsLocked)
                            {
                                if (DicPerCollection[item.Rank][Pitem.ItemKey].AllowType == AllowTypes.Allow)
                                    Response.Write(string.Format(strTH, Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Icons/icon_true_red.gif"), string.Empty));
                                else if (DicPerCollection[item.Rank][Pitem.ItemKey].AllowType == AllowTypes.Refuse)
                                    Response.Write(string.Format(strTH, Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Icons/icon_false_red.gif"), string.Empty));
                                else
                                    Response.Write("<td class=\"tn-border-gray tn-border-bottom tn-nowrap\">---</td>");
                            }
                            else
                            {
                                if (DicPerCollection[item.Rank][Pitem.ItemKey].AllowType == AllowTypes.Allow)
                                    Response.Write(string.Format(strTH, Globals.GetFullUrlInResourceSite("~/Themes/Manages/Default/Appearances/Default/Images/icon_true.gif"), string.Empty));
                                else if (DicPerCollection[item.Rank][Pitem.ItemKey].AllowType == AllowTypes.Refuse)
                                    Response.Write(string.Format(strTH, Globals.GetFullUrlInResourceSite("~/Themes/Manages/Default/Appearances/Default/Images/icon_false.gif"), string.Empty));
                                else
                                    Response.Write("<td class=\"tn-border-gray tn-border-bottom tn-nowrap\">未设置</td>");
                            }
                        }
                        catch
                        { Response.Write("<td class=\"tn-border-gray tn-border-bottom tn-nowrap\">未设置</td>"); }
                    }
                }
            %>
        </tr>
        <%
            }
                }
        %>
    </table>
    <%} %>


    </div>