﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<UserActivity>>" %>

<div id="ListMyNewStories" class="spb-user-activities">
  <% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
       int userApplicationID = ApplicationIDs.Instance().User();
       if (ViewData.GetBool("IsOwnerOrAdministrator", false))
       { %>
  <div class="tn-list-header">
    <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
      <div class="tn-helper-right"> <a href="<%=SPBUrlHelper.Action("ActivitySettings", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName } })%>"> <%=GetResourceString("Title_ActivitySettings",userApplicationID) %></a></div>
      <div class=" tn-helper-left"> <%=SPBHtmlHelper.Instance().LinkButton("BatchDeleteButton", GetResourceString("Action_DeleteMuch", userApplicationID), SPBUrlHelper.Action("Control_DeleteUserExpiredData", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "userExpiredDataType", UserExpiredDataType.UserActivity } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary { { "title", GetResourceString("Title_DeleteActivities", userApplicationID) } }, null)%> </div>
    </div>
  </div>
  <%} %>
  <% PagingDataSet<UserActivity> userActivities = (PagingDataSet<UserActivity>)ViewData.Model;
       int returnPageIndex = userActivities.PageIndex;
       if (userActivities.TotalRecords == (returnPageIndex * userActivities.PageSize + 1))
           returnPageIndex = returnPageIndex - 1;
       if (userActivities.Records.Count > 0)
       {%>
  <ul class="tn-list tn-helper-reset">
    <% 
            Dictionary<int, Application> applications = Applications.GetApplications();
            string applicationKey = "default";
            string applicationName = GetResourceString("Title_ActivityApplicationName", userApplicationID);

            foreach (UserActivity userActivity in userActivities.Records)
            {
                if (applications.ContainsKey(userActivity.ApplicationID))
                {
                    applicationKey = applications[userActivity.ApplicationID].ApplicationKey;
                    applicationName = applications[userActivity.ApplicationID].GetMultilingualApplicationName(CurrentUserLanguage);
                }
                string filePath = WebUtils.ResolveUrl(string.Format("~/Themes/Shared/Styles/Icons/activity_{0}.gif", applicationKey.ToLower()));
        %>
    <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
      <div class="tn-list-item-area-left"> <img src="<%=filePath %>" title="<%=applicationName %>" alt="<%=applicationName %>"
                    width="16" height="16" /> </div>
      <div class="tn-list-item-area-right">
        <% if (CurrentUser != null && (Globals.GetCurrentUser().UserName == userDomainName || Globals.GetCurrentUser().IsContentAdministrator))
                   {%>
        <%=SPBHtmlHelper.Instance().LinkButton("del", HighlightStyles.Lite, IconTypes.Cross, new RouteValueDictionary { { "onclick", "DeleteThisStory('" + SPBUrlHelper.Action("DeleteUserActivity", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "activityID", userActivity.ActivityID }, { "pageIndex", returnPageIndex } }) + "')" }, { "title", GetResourceString("Action_Delete") } }, null)%>
        <%}%>
      </div>
      <div class="tn-list-item-area-main">
        <div class="tn-list-item-row tn-list-item-heading"> <%=userActivity.Subject%><em class="tn-text-note tn-date"><%= Convert.ToString(Formatter.FormatFriendlyDate(userActivity.DateCreated))%></em></div>
        <div class="tn-list-item-row tn-list-item-summary">
          <p class="tn-helper-reset"> <%=userActivity.Body%></p>
          <div class="tn-list-item-row"> </div>
        </div>
      </div>
    </li>
    <%} %>
  </ul>
  <div class="tn-pagination tn-helper-align-center"> <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, userActivities.TotalRecords, userActivities.PageSize, userActivities.PageIndex, 11, SPBUrlHelper.Action("Control_ListUserActivities", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pageIndex", "{0}" } }), "pageIndexChange")%> </div>
  <script type="text/javascript">
        function DeleteThisStory(url) {
            if (confirm('<%=GetResourceString("Message_ConfirmDeleteActivity",userApplicationID) %>'))
            { $('#ListMyNewStories').load(url); }
        }

        function pageIndexChange(url) {
            $('#ListMyNewStories').load(url);
        }
                  
    </script>
  <%} %>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        $("button[menu]").menuButton();

        $('#BatchDeleteButton').nyroModal({
            resizeable: true
        });
    });

    function toggleMicroBlogComments(showMicroBlogComments, microBlogThreadID, url) {
        if (showMicroBlogComments) {
            $('#microBlogReplyContainer-' + microBlogThreadID).load(url);
            $("#showMicroBlogCommentsToggler-" + microBlogThreadID).hide();
            $("#hideMicroBlogCommentsToggler-" + microBlogThreadID).show();
        }
        else {
            $('#microBlogReplyContainer-' + microBlogThreadID).html("");
            $("#showMicroBlogCommentsToggler-" + microBlogThreadID).show();
            $("#hideMicroBlogCommentsToggler-" + microBlogThreadID).hide();
        }
    }
</script>
