﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<UserActivity>>" %>
<%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName"); User currentDomainUser = Users.GetUser(userDomainName, false);
  int userApplicationID = ApplicationIDs.Instance().User();
    
     %>
<div id="ListMyNewStories" class="spb-user-activities">
    <% 
        if (Model.Count > 0)
        {%>
    <ul class="tn-list tn-helper-reset">
        <% 
            //int microBlogActiveCount = 0;
            Dictionary<int, Application> applications = Applications.GetApplications();
            string applicationKey = "default";
            string applicationName = GetResourceString("Title_ActivityApplicationName", ApplicationIDs.Instance().User());
            foreach (UserActivity userActivity in Model)
            {%>
        <% if (applications.ContainsKey(userActivity.ApplicationID))
           {
               Application application = applications[userActivity.ApplicationID];
               applicationKey = application.ApplicationKey;
               applicationName = application.GetMultilingualApplicationName(CurrentUserLanguage);
           }
           string filePath = WebUtils.ResolveUrl(string.Format("~/Themes/Shared/Styles/Icons/activity_{0}.gif", applicationKey.ToLower()));
        %>
        <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
            <div class="tn-list-item-area-left">
                <img src="<%=filePath %>" title="<%=applicationName %>" alt="<%=applicationName %>"
                    width="16" height="16" />
            </div>
            <div class="tn-list-item-area-right">
                <% if (CurrentUser!=null && (Globals.GetCurrentUser().UserName == userDomainName || Globals.GetCurrentUser().IsContentAdministrator))
                   {%>
                <%=SPBHtmlHelper.Instance().LinkButton("del", HighlightStyles.Lite, IconTypes.Cross, new RouteValueDictionary { { "onclick", "DeleteThisStory('" + SPBUrlHelper.Action("DeleteUserActivityInBlock", "MessageCenter", new RouteValueDictionary { { "userDomainName", Html.GetParameterFromRouteDateOrQueryString("userDomainName") }, { "activityID", userActivity.ActivityID }, { "displayItemCount", Model.Count } }) + "')" }, { "title", GetResourceString("Action_Delete") } }, null)%>
              
               <%}%>
            </div>
            <div class="tn-list-item-area-main">
               <div class="tn-list-item-row tn-list-item-heading">
                        <%=userActivity.Subject%><em class="tn-text-note tn-date"><%= Convert.ToString(Formatter.FormatFriendlyDate(userActivity.DateCreated))%></em></div>
                <div class="tn-list-item-row tn-list-item-summary">
                    <p class="tn-helper-reset">
                        <%=userActivity.Body%></p>
                    <div class="tn-list-item-row">
                       
                        
                    </div>
                </div>
            </div>
        </li>
        <%} %>
    </ul>

    <script type="text/javascript">

        function DeleteThisStory(url) {
            if (confirm('<%=GetResourceString("Message_ConfirmDeleteActivity",userApplicationID) %>'))
            { $('#ListMyNewStories').load(url); }
        }

        function toggleMicroBlogComments(showMicroBlogComments, microBlogThreadID, url) {
            if (showMicroBlogComments) {
                $('#microBlogReplyContainer-' + microBlogThreadID).load(url);
                $("#showMicroBlogCommentsToggler-" + microBlogThreadID).hide();
                $("#hideMicroBlogCommentsToggler-" + microBlogThreadID).show();
            }
            else {
                $('#microBlogReplyContainer-' + microBlogThreadID).html("");
                $("#showMicroBlogCommentsToggler-" + microBlogThreadID).show();
                $("#hideMicroBlogCommentsToggler-" + microBlogThreadID).hide();
            }
        }
    </script>

    <%} %>
</div>
