﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<UserVisit>>" %>
<div class="tn-avatar-list tn-helper-reset">
    <%-- <div class="clearfix">--%>
    <% 
        foreach (UserVisit visit in ViewData.Model)
        {
    %>
    <div class="tn-avatar-item">
        <% if (ViewData.GetBool("isVisitor", false))
           {
        %>
        <div class="tn-avatar">
            <%=SPBHtmlHelper.Instance().ShowUserAvatar(visit.FromUserID,true, HyperLinkTarget._self, AvatarSizeTypes.Small)%>
        </div>
        <a class="tn-text-heading" href="<%=SiteUrls.Instance().UserChannelHome(visit.FromUserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
            title="<%=string.Format(GetResourceString("Description_Pattern_ViewUserDomain"), visit.FromUserDisplayName) %>">
            <%=visit.FromUserDisplayName%></a>
        <%}
           else
           {
        %>
        <div class="tn-avatar">
            <%=SPBHtmlHelper.Instance().ShowUserAvatar(visit.ToUserID,true, HyperLinkTarget._self, AvatarSizeTypes.Small)%>
        </div>
      <a class="tn-text-heading" href="<%=SiteUrls.Instance().UserChannelHome(visit.ToUserID, UserDomainSpecialAppIDs.Instance().Home()) %>">
            <%=visit.ToUserDisplayName %>
        </a>
        <%} %>
        <span class="tn-text-note">
            <%=Formatter.FormatDateToIntervalTime(visit.LastVisitTime)%></span>
    </div>
    <%} %>
    <% if (ViewData.Model.Count >= 10)
       { %>
    <p class="tn-helper-align-right">
        <% string moreUrl = string.Empty;
           string userDomainName = Html.GetParameterFromRouteDateOrQueryString("UserDomainName");
           if (ViewData.GetBool("isVisitor", false))
               moreUrl = SPBUrlHelper.Action("ListVisitor", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName } });
           else
               moreUrl = SPBUrlHelper.Action("ListVisited", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName } });%>
        <a href="<%=moreUrl %>">
            <%=GetResourceString("Action_More")%></a></p>
    <%} %>
</div>
