﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<UserVisit>>" %>
<div id="ListVisitedDiv">
    <% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
       if (ViewData.GetBool("IsOwnerOrAdministrator", false))
       { %>
    <div class="tn-list-header">
        <div class="tn-toolbar-area tn-helper-clearfix">
            <%=SPBHtmlHelper.Instance().LinkButton("BatchDeleteButton", GetResourceString("Button_BatchDelete"), SPBUrlHelper.Action("Control_DeleteUserExpiredData", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "userExpiredDataType", UserExpiredDataType.UserVisit } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText)%>
        </div>
    </div>
    <%} %>
    <ul class="tn-list tn-helper-reset">
        <%if (ViewData.Model != null)
              foreach (UserVisit visit in ViewData.Model.Records)
              {%>
        <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
            <div class="tn-list-item-area-left">
                <div class="tn-avatar">
                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(visit.ToUserID, true, HyperLinkTarget._self, AvatarSizeTypes.Small,null)%>
                </div>
            </div>
            <div class="tn-list-item-area-right">
                <ul class="tn-list-actions tn-helper-reset">
                    <li class="tn-list-action tn-border-gray tn-border-bottom"><a href="javascript:;"
                        onclick="$('#ListVisitedDiv').load('<%=SPBUrlHelper.Action("SetVisitIsVisible","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"visitID",visit.VisitID},{"isVisible",!visit.IsVisible},{"pageIndex",ViewData.Model.PageIndex}}) %>' )">
                        <% if (visit.IsVisible)
                           { %>
                        <%=GetResourceString("Description_HideUserVisitLogActionTitle",ApplicationIDs.Instance().User())%>
                        <%}
                           else
                           {
                        %>
                        <%=GetResourceString("Description_ShowUserVisitLogActionTitle",ApplicationIDs.Instance().User())%>
                        <%} %>
                    </a></li>
                    <li class="tn-list-action tn-border-gray tn-border-bottom">
                        <% int returnToPageIndex = ViewData.Model.PageIndex;
                           if ((ViewData.Model.TotalRecords == ViewData.Model.PageSize * (returnToPageIndex - 1) + 1) && (ViewData.Model.PageIndex > 1))
                           {
                               returnToPageIndex = ViewData.Model.PageIndex - 1;
                           } %>
                        <a href="javascript:;" onclick="if (confirm('<%=GetResourceString("Message_ConfirmDeleteThisVisitLog", ApplicationIDs.Instance().User())%>')) $('#ListVisitedDiv').load('<%=SPBUrlHelper.Action("DeleteUserVisit","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"visitID",visit.VisitID},{"pageIndex",returnToPageIndex}}) %>' )">
                            <%=GetResourceString("Action_Delete")%></a> </li>
                </ul>
            </div>
            <div class="tn-list-item-area-main">
                <div class="tn-list-item-row tn-list-item-heading">
                    <h5 class="tn-helper-reset">
                        <a href="<%=SiteUrls.Instance().UserChannelHome(visit.ToUserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
                            title="<%=string.Format(GetResourceString("Description_Pattern_ViewUserDomain"),visit.ToUserDisplayName) %>"
                            target="_blank">
                            <%=visit.ToUserDisplayName%></a></h5>
                </div>
                <div class="tn-list-item-row tn-text-note">
                    <%=GetResourceString("Label_LastVisitTime", ApplicationIDs.Instance().User())%><%=GetResourceString("Common_Colon") %><%=Formatter.FormatDateToIntervalTime(visit.LastVisitTime) %>&nbsp;&nbsp;&nbsp;&nbsp;<%=GetResourceString("Label_VisitTimes", ApplicationIDs.Instance().User())%><%=GetResourceString("Common_Colon") %><%=visit.VisitTimes %>
                </div>
            </div>
        </li>
        <%} %>
    </ul>
    <div class="tn-pagination tn-helper-align-center">
        <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11, SPBUrlHelper.Action("Control_ListVisited","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"pageIndex","{0}"}}), "pageIndexChange")%>
    </div>

    <script type="text/javascript">
        $(document).ready(function() {
            $('#BatchDeleteButton').nyroModal({
                resizeable: true
            });
        });
        function pageIndexChange(url) {
            $('#ListVisitedDiv').load(url);
        }
    </script>

</div>
