﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<GuestbookPost>>" %>

<div id="MyGuestBookBlockDiv" class="spb-message-board"> <a id="guestbook" name="guestbook"></a>
  <%   
        if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            if (messageType == StatusMessageType.Success)
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
            else
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
            TempData["StatusMessageType"] = null;
        }
        string userDomainName = Html.GetParameterFromRouteDateOrQueryString("UserDomainName");

        bool isPrivate = TempData.GetBool("isPrivate", false);
    %>
  <% SiteSettings settings = SiteSettingsManager.GetSiteSettings();
       if (settings.EnableAnonymousPosting && CurrentUser == null || CurrentUser != null)
       { %>
  <form id="MyGuestBookBlockForm" method="post" action="<%=SPBUrlHelper.Action("CreateGuestBookPostInBlock","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
    <div class="tn-form">
      <div class="tn-comment-form-wrap tn-emotion-box tn-bg-gray">
        <div class="tn-comment-form tn-emotion-box">
          <div class="tn-comment-text-wrap tn-border-gray tn-form-row-near tn-textarea-wrap">
            <%  Html.RenderAction<ChannelController>(n => n.Control_SmileySelector(string.Empty, "body"));%>
            <textarea id="body" name="body" class="tn-comment-text-area"><%=TempData.GetString("Body", string.Empty)%></textarea>
            <span style="display:none"></span> </div>
          <div class="tn-form-row"> <span class=" tn-text-note">（<%=GetResourceString("Message_NewGuestBookPostMaxBobyHint",ApplicationIDs.Instance().User()) %>）</span> <a href="<%=SPBUrlHelper.Action("ShowGuestBook","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"> <%=GetResourceString("Title_ShowGuestBook",ApplicationIDs.Instance().User()) %></a> </div>
          <%  
           if (settings.VerifyCodeOption == VerifyCodeOption.Enabled || CurrentUser == null && settings.VerifyCodeOption == VerifyCodeOption.Anonymous)
           { %>
          <% if (CurrentUser == null)
                       { %>
          <div class="tn-form-row">
            <label class="tn-form-label"> <%=GetResourceString("Label_CommonName")%><%=GetResourceString("Common_Colon") %></label>
            <input type="text" id="author" class="tn-textbox tn-input-medium tn-border-gray"
                            name="author" maxlength="30" value="<%=TempData.GetString("Author",string.Empty) %>" />
          </div>
          <%} %>
          <div class="tn-form-row tn-verifycode">
            <label> <%=GetResourceString("Label_VerifyCode")%><%=GetResourceString("Common_Colon") %></label>
            <%=SPBHtmlHelper.Instance().ShowVerificationCode("verifyCode", VerificationCodeDifficultyLevel.Low)%> </div>
          <script type="text/javascript">
                $(document).ready(function() {
                    $("#MyGuestBookBlockForm").validate({
                        rules: {
                            author: { required: true, rangelength: [1, 30] },
                            verifyCode: { required: true },
                            body: { required: true, rangelength: [1, 300] }
                        },
                        messages: {
                            author: { required: "<%=GetResourceString("Validate_NewGuestBookPostAuthorErrorForEmpty",ApplicationIDs.Instance().User()) %>", rangelength: "<%=string.Format(GetResourceString("Validate_Pattern_NewGuestBookPostAuthorErrorForLength", ApplicationIDs.Instance().User()), 30)%>" },
                            verifyCode: { required: "<%=GetResourceString("Validate_FillInValidate") %>" },
                            body: { required: "<%=GetResourceString("Validate_NewGuestBookPostBodyErrorForEmpty",ApplicationIDs.Instance().User()) %>", rangelength: "<%=string.Format(GetResourceString("Validate_Pattern_NewGuestBookPostBodyErrorForLength", ApplicationIDs.Instance().User()), 300)%>" }
                        }
                    });
                }); 
                    </script>
          <%} %>
          <div class="tn-form-row tn-form-row-button"> <%=SPBHtmlHelper.Instance().SubmitButton("submitGuestBookPost",GetResourceString("Button_SubmitGuestBookPost",ApplicationIDs.Instance().User()),ButtonSizes.Default,null,null) %>
            <input type="hidden" id="parentID" name="parentID" value="<%=TempData.GetInt("parentID", 0)%>" />
            <% if (CurrentUser != null)
                           { %>
            <input class="tn-checkbox" type="checkbox" id="isPrivate" <% if(isPrivate) Response.Write("checked=\"checked\""); %>
                            name="isPrivate" value="true" />
            <label for="isPrivate"> <%=GetResourceString("Label_GuestBookPrivatePost",ApplicationIDs.Instance().User()) %></label>
            <%} %>
          </div>
        </div>
      </div>
    </div>
  </form>
  <%} %>
  <ul class="tn-comments tn-helper-reset">
    <%            
            Dictionary<int, User> guestBookUsers = ViewData["guestBookUsers"] as Dictionary<int, User>;
            //如果当前用户是空间主人或管理员，则具有查看悄悄话的权限
            bool hasManagePermission = CurrentUser != null && (CurrentUser.UserID == UserID2UserNameDictionary.GetUserID(userDomainName) || CurrentUser.IsContentAdministrator);

            foreach (GuestbookPost post in ViewData.Model.Records)
            {
                User user = null;
                guestBookUsers.TryGetValue(post.PostID, out user);
                //如果当前用户是被回复人或是留言作者
                bool hasViewPrivatePostPermission = hasManagePermission || CurrentUser != null && (post.ParentUserID == CurrentUser.UserID || post.UserID == CurrentUser.UserID);
                if (post.IsPrivate && !hasViewPrivatePostPermission)
                    continue;
        %>
    <li class="tn-comment-item tn-border-gray tn-border-bottom">
      <div class="tn-comment tn-helper-clearfix">
        <div class="tn-comment-avatar">
          <div class="tn-avatar"> <%=SPBHtmlHelper.Instance().ShowUserAvatar(post.UserID, true, HyperLinkTarget._self, AvatarSizeTypes.Small)%> </div>
        </div>
        <%bool isAllowed = ViewData.GetBool("IsAllowed", false);
                  if (isAllowed)
                  { %>
        <a href="javascript:;" class="tn-icon tn-icon-cross tn-helper-right" onclick="if (confirm('<%=GetResourceString("Message_ConfirmDeleteThisGuestBookPost",ApplicationIDs.Instance().User()) %>')) $('#MyGuestBookBlockDiv').parent().load('<%=SPBUrlHelper.Action("DeleteGuestBookInBlock","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"postID",post.PostID}}) %>')"> </a>
        <%} %>
        <div class="tn-comment-info">
          <div class="tn-commentator">
            <h5>
              <% if (post.UserID > 0)
                               { %>
              <a class="tn-author" href="<%=SiteUrls.Instance().UserChannelHome(post.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
                                title="<%=string.Format(GetResourceString("Description_Pattern_ViewUserDomain"), post.Author)%>"> <%=post.Author%></a>
              <%}
                               else Response.Write(post.Author); %>
            </h5>
            <span>
            <%if (user != null && user.UserType == UserTypes.PersonUser)
                              {
                                  string nowAreaCode = ((PersonUser)user).NowAreaCode;
                                  if (!string.IsNullOrEmpty(nowAreaCode))
                                      Response.Write(string.Format("（{0}）", Formatter.FormatArea(nowAreaCode, 0, 1)));
                              }%>
            </span><em class="tn-text-note tn-date"> <%=Formatter.FormatFriendlyDate(post.PostDate)%></em>
            <% if (CurrentUser != null && post.UserID != CurrentUser.UserID)
                           {  %>
            <span><a href="javascript:;" onclick="$('#body').focus(); $('#body').attr('value','<%=GetResourceString("Common_Reply") %><%=post.Author %><%=GetResourceString("Common_Colon") %>');$('#parentID').attr('value','<%=post.PostID %>'); <%=string.Format("$('#isPrivate').attr('checked',{0}).attr('disabled',{0});",post.IsPrivate.ToString().ToLower()) %>"> <%=GetResourceString("Common_Reply")%></a></span>
            <%} %>
            <% if (post.IsPrivate)
                           { %>
            <span class="tn-text-note"> <%=GetResourceString("Label_GuestBookPrivatePost",ApplicationIDs.Instance().User()) %></span>
            <%} %>
          </div>
          <%if (post.ParentID > 0)
                      { %>
          <blockquote class="tn-cue-tips tn-bg-gray tn-border-gray">
            <p> <%=GetResourceString("Common_Reply")%> <a class="tn-author" href="<%=SiteUrls.Instance().UserDomainHome(post.ParentUserID) %>"> <%=post.ParentAuthor%></a><em class="tn-text-note tn-date"><%=Formatter.FormatDate(post.ParentPostDate, true)%></em></p>
            <p> <%=post.ParentBody%></p>
          </blockquote>
          <%} %>
          <p> <%=post.Body %></p>
        </div>
      </div>
    </li>
    <%} %>
  </ul>
  <script type="text/javascript">
    $(document).ready(function() {
        $("#MyGuestBookBlockForm").validate({
            rules: {
                body: { required: true, rangelength: [1, 300] }
            },
            messages: {
                body: { required: "<%=GetResourceString("Validate_NewGuestBookPostBodyErrorForEmpty",ApplicationIDs.Instance().User()) %>", rangelength: "<%=string.Format(GetResourceString("Validate_Pattern_NewGuestBookPostBodyErrorForLength", ApplicationIDs.Instance().User()), 300)%>" }
            }
        });
   
        $('#MyGuestBookBlockForm').ajaxForm({
            beforeSubmit: function() {
                if (!$("#MyGuestBookBlockForm").valid())
                { return false; }
                $('#MyGuestBookBlockForm').block({
                    message: '<%=GetResourceString("Message_Loading")%>'
                });
            },
            target: '#MyGuestBookBlockDiv',
            success: function() {
                $('#MyGuestBookBlockForm').unblock();
            }
        });
    }); 
    </script>
</div>
