﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%  string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    User domainUser = Users.GetUser(userDomainName, false);
    int? pageIndex = ViewData.GetInt("pageIndex", 1);
    List<UserCategory> list = MultiUserCategoryManager.Instance(MultiUserCategoryItemKeys.Instance().Friend()).GetUserCategories(domainUser.UserID, true);
%>
<div class="spb-accept-invitation">
    <form method="get" id="SetFriendInfoForm" action="<%=SPBUrlHelper.Action("BatchSetFriendGroup", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }})%>">
    <input type="hidden" id="invitationIDs" name="invitationIDs" value="" />
    <input type="hidden" name="pageIndex" value="<%=pageIndex %>"  />
    <div class="tn-card">
       
        <div class="tn-form">
            <div class="tn-form-row">
                <select id="categoryID" name="categoryID">
                    <option value="0">选择分组</option>
                    <%foreach (UserCategory cat in list)
                      {%>
                    <option value="<%=cat.CategoryID %>">
                        <%=cat.CategoryName%></option>
                    <%} %>
                    <option value="-100">添加分组...</option>
                </select>
                <span id="showGroupName" style="visibility:hidden">
                    <input type="text" id="groupName" name="groupName" class="tn-textbox tn-input-medium tn-border-gray" />
                </span>
            </div>
           
            <div class="tn-form-row tn-form-row-button">
                <%=SPBHtmlHelper.Instance().SubmitButton("submitButton","确定",ButtonSizes.Default,null,null) %>
                <%=SPBHtmlHelper.Instance().CancelButton(new RouteValueDictionary { { "class", "dialogClose" } })%>
            </div>
        </div>
    </div>
    </form>

    <script type="text/javascript">
        $(document).ready(function() {

        var invitationIDs = '';
        $("input[name='InvitationInBoxCheckBoxGroup']:checked").each(function() {
        invitationIDs += $(this).val() + ',';
        });
        $("#invitationIDs").attr("value", invitationIDs);
        
            $("#groupName").watermark("分组名称");

            $("#categoryID").change(function() {
                if ($(this).val() == '-100')
                    $("#showGroupName").attr("style", "visibility:visible");
                else
                    $("#showGroupName").attr("style", "visibility:hidden");
            });
            $("#submitButton").click(function() {
                if (!$("#SetFriendInfoForm").valid()) {
                    return false;
                }
            });

            $("#SetFriendInfoForm").validate({
            rules: {
                    groupName: { maxBlength: 20 }
                },
                messages: {
                    groupName: { maxBlength: "最多20个字" }
                }
            });
        });
    </script>

</div>
