﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<FriendActivity>>" %>
<div id="ListMyNewStories" class="spb-user-activities">
    <% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
       int userApplicationID = ApplicationIDs.Instance().User();
       if (ViewData.GetBool("IsOwnerOrAdministrator", false))
       { %>
    <div class="tn-list-header">
        <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
            <div class="tn-helper-right">
                <a href="<%=SPBUrlHelper.Action("ActivitySettings", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName } })%>">
                    <%=GetResourceString("Title_ActivitySettings",userApplicationID) %></a></div>
            <div class=" tn-helper-left">
                <%=SPBHtmlHelper.Instance().LinkButton("BatchDeleteButton", GetResourceString("Action_DeleteMuch", userApplicationID), SPBUrlHelper.Action("Control_DeleteUserExpiredData", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "userExpiredDataType", UserExpiredDataType.FriendActivity } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary { { "title", GetResourceString("Description_DeleteActivitiesActionTitle", userApplicationID) } }, null)%>
            </div>
        </div>
    </div>
    <%} %>
    <% PagingDataSet<FriendActivity> friendActivities = (PagingDataSet<FriendActivity>)ViewData.Model;
       int returnPageIndex = friendActivities.PageIndex;
       if (friendActivities.TotalRecords == (returnPageIndex * friendActivities.PageSize + 1))
           returnPageIndex = returnPageIndex - 1;
       if (friendActivities.Records.Count > 0)
       {%>
    <ul class="tn-list tn-helper-reset">
        <%
            Dictionary<int, Application> applications = Applications.GetApplications();
            string applicationKey = "default";
            string applicationName = GetResourceString("Title_ActivityApplicationName", userApplicationID);
            foreach (FriendActivity friendActivity in friendActivities.Records)
            {
                if (applications.ContainsKey(friendActivity.ApplicationID))
                {
                    applicationKey = applications[friendActivity.ApplicationID].ApplicationKey;
                    applicationName = applications[friendActivity.ApplicationID].GetMultilingualApplicationName(CurrentUserLanguage);
                }
                string filePath = WebUtils.ResolveUrl(string.Format("~/Themes/Shared/Styles/Icons/activity_{0}.gif", applicationKey.ToLower()));
        %>
        <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
            <div class="tn-list-item-area-left">
                <img src="<%=filePath %>" title="<%=applicationName %>" alt="<%=applicationName %>"
                    width="16" height="16" />
            </div>
            <% if (CurrentUser != null && (Globals.GetCurrentUser().UserName == userDomainName || Globals.GetCurrentUser().IsContentAdministrator))
               {%>
            <div class="tn-list-item-area-right">
                <div class="spb-list-icon-actions">
                    <div class="spb-icon-action">
                        <span menu="#sitecategoryMenu1<%=friendActivity.ActivityID %>" class="tn-action tn-action-has-drop-menu tn-border-trl">
                            <span class="tn-icon tn-icon-set"></span></span>
                        <div style="display: none;" class="tn-drop-menu ui-widget-content" id="sitecategoryMenu1<%=friendActivity.ActivityID %>">
                            <ul class="tn-menu-drop-list">
                                <li class="tn-menu-drop-item"><a class="tn-menu-text" href="javascript:;" onclick="$('#ListMyNewStories').load('<%=SPBUrlHelper.Action("UpdateHideUserActivitySetting","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName} ,{"LeadingActorUserID",friendActivity.LeadingActorUserID},{"LeadingActor",friendActivity.LeadingActor},{"pageIndex",returnPageIndex}}) %>')">
                                    <%=GetResourceString("Action_ShieldingHisDynamic",userApplicationID) %></a></li>
                                <li class="tn-menu-drop-item"><a class="tn-menu-text" href="javascript:;" onclick="$('#ListMyNewStories').load('<%=SPBUrlHelper.Action("UpdateHideTypeActivitySetting","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"activityItemID",friendActivity.ActivityItemID},{"pageIndex",returnPageIndex}}) %>')">
                                    <%=GetResourceString("Action_ShieldingThisDynamic",userApplicationID) %></a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="spb-icon-action">
                        <a class="tn-icon tn-icon-cross" href="javascript:;" onclick=" DeleteThisStory('<%=SPBUrlHelper.Action("DeleteFriendActivity", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "activityID", friendActivity.ActivityID }, { "pageIndex", returnPageIndex } })%>')">
                        </a>
                    </div>
                </div>
            </div>
            <%}%>
            <div class="tn-list-item-area-main">
                <div class="tn-list-item-row tn-list-item-heading">
                    <%=friendActivity.Subject%><em class="tn-text-note tn-date"><%= Convert.ToString(Formatter.FormatFriendlyDate(friendActivity.DateCreated))%></em></div>
                <div class="tn-list-item-row tn-list-item-summary">
                    <% if (!string.IsNullOrEmpty(friendActivity.Body))
                       {%>
                    <p class="tn-helper-reset">
                        <%=friendActivity.Body%></p>
                    <%} %>
                </div>
            </div>
        </li>
        <%} %>
    </ul>
    <div class="tn-pagination tn-helper-align-center">
        <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, friendActivities.TotalRecords, friendActivities.PageSize, friendActivities.PageIndex, 11, SPBUrlHelper.Action("Control_ListFriendActivities","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"pageIndex","{0}"}}), "pageIndexChange")%>
    </div>

    <script type="text/javascript">
        function DeleteThisStory(url) {
            if (confirm('<%=GetResourceString("Message_ConfirmDeleteActivity",ApplicationIDs.Instance().User()) %>'))
            { $('#ListMyNewStories').load(url); }
        }

        function pageIndexChange(url) {
            $('#ListMyNewStories').load(url);
        }
                  
    </script>

    <%} %>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $("span[menu]").menuButton();
        $("span[menu]").menuButton({ buttonHoverClass: 'ui-widget-content tn-action-hover' });

        $('#BatchDeleteButton').nyroModal({
            resizeable: true
        });
    });

    function toggleMicroBlogComments(showMicroBlogComments, microBlogThreadID, url) {
        if (showMicroBlogComments) {
            $('#microBlogReplyContainer-' + microBlogThreadID).load(url);
            $("#showMicroBlogCommentsToggler-" + microBlogThreadID).hide();
            $("#hideMicroBlogCommentsToggler-" + microBlogThreadID).show();
        }
        else {
            $('#microBlogReplyContainer-' + microBlogThreadID).html("");
            $("#showMicroBlogCommentsToggler-" + microBlogThreadID).show();
            $("#hideMicroBlogCommentsToggler-" + microBlogThreadID).hide();
        }
    }
</script>

