﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<FriendActivity>>" %>
<spb:Script runat="server" ID="menuButton" Src="~/Utility/jquery/plugin/jquery.spb.menuButton.js"
    SetExpireDays="30" />
<% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   int topNumber = ViewData.GetInt("topNumber", 0);
   int userApplicationID = ApplicationIDs.Instance().User();
   int? applicationID = ViewData.GetInt("applicationID");
   int totalRecords = ViewData.GetInt("totalRecords", 0);
   if (applicationID == 0)
       applicationID = null;
   Dictionary<int, Application> applications = Applications.GetApplications(); %>
<%if (TempData["StatusMessageType"] != null)
  {
      StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
      Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 19000));
      TempData["StatusMessageType"] = null;
  } %>
<div id="friendActiveForLoad">
    <div class="tn-directory">
        <div class="tn-directory-level tn-border-gray tn-border-bottom">
            <span class="tn-directory-item <%if (applicationID == null) Response.Write(" tn-text-note tn-selected"); %>">
                <a href="#" onclick="$('#friendActiveForLoad').load('<%=SPBUrlHelper.Action("Control_ListFriendActivitiesBlock", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName } })%>')">
                    <%=GetResourceString("Enum_AccountStatuses_All")%></a>
            </span>
            <%
                if (applications != null)
                {
                    foreach (var appPair in applications)
                    {

                        if (!Applications.IsEnabled(appPair.Key))
                            continue;%>
            <span class="tn-directory-item <%if (applicationID == appPair.Key) Response.Write(" tn-text-note tn-selected"); %>">
                <a href="#<%=appPair.Value.ApplicationKey %>" onclick="$('#friendActiveForLoad').load('<%=SPBUrlHelper.Action("Control_ListFriendActivitiesBlock", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "applicationID",appPair.Key} })%>')">
                    <%=appPair.Value.GetMultilingualApplicationName(CurrentUserLanguage) %></a></span>
            <%}
                } %>
        </div>
    </div>
    <% if (Model.Count > 0)
       {%>
    <ul class="tn-list">
        <% 
            string applicationKey = "default";
            string applicationName = GetResourceString("Title_ActivityApplicationName", ApplicationIDs.Instance().User());
            ActivityItem activityItem = Activities.GetActivityItem(ActivityItemKeys.Instance().NewMicroBlogThread());
            foreach (FriendActivity friendActivity in Model)
            {%>
        <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
            <div class="tn-list-item-area-left">
                <% if (applications.ContainsKey(friendActivity.ApplicationID))
                   {
                       applicationKey = applications[friendActivity.ApplicationID].ApplicationKey;
                       applicationName = applications[friendActivity.ApplicationID].GetMultilingualApplicationName(CurrentUserLanguage);
                   }
                   string filePath = WebUtils.ResolveUrl(string.Format("~/Themes/Shared/Styles/Icons/activity_{0}.gif", applicationKey.ToLower()));
                %>
                <img src="<%=filePath %>" title="<%=applicationName %>" alt="<%=applicationName %>"
                    width="16" height="16" />
            </div>
            <% if (CurrentUser != null && (Globals.GetCurrentUser().UserName == userDomainName || Globals.GetCurrentUser().IsContentAdministrator))
               {%>
            <div class="tn-list-item-area-right">
                <div class="spb-list-icon-actions">
                    <div class="spb-icon-action">
                        <span menu="#sitecategoryMenu1<%=friendActivity.ActivityID %>" class="tn-action tn-action-has-drop-menu tn-border-trl">
                            <span class="tn-icon tn-icon-set"></span>
                        </span>
                        <div style="display: none;" class="tn-drop-menu ui-widget-content" id="sitecategoryMenu1<%=friendActivity.ActivityID %>">
                            <ul class="tn-menu-drop-list">
                                <li class="tn-menu-drop-item">
                                    <a class="tn-menu-text" href="javascript:;" onclick="$('#friendActiveForLoad').load('<%=SPBUrlHelper.Action("UpdateHideUserActivitySetting","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"isHome",true} ,{"LeadingActorUserID",friendActivity.LeadingActorUserID},{"applicationID",applicationID}}) %>')">
                                        <%=GetResourceString("Action_ShieldingHisDynamic",userApplicationID) %></a></li>
                                <li class="tn-menu-drop-item">
                                    <a class="tn-menu-text" href="javascript:;" onclick="$('#friendActiveForLoad').load('<%=SPBUrlHelper.Action("UpdateHideTypeActivitySetting","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"activityItemID",friendActivity.ActivityItemID},{"isHome",true},{"applicationID",applicationID}}) %>')">
                                        <%=GetResourceString("Action_ShieldingThisDynamic",userApplicationID) %></a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="spb-icon-action">
                        <a class="tn-icon tn-icon-cross" href="javascript:;" onclick=" DeleteThisStory('<%=SPBUrlHelper.Action("DeleteFirendActivityInBlock","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"topNumber",topNumber},{"activityID",friendActivity.ActivityID},{"applicationID",applicationID}}) %>')">
                        </a>
                    </div>
                </div>
            </div>
            <%} %>
            <div class="tn-list-item-area-main">
                <div class="tn-list-item-row tn-list-item-heading">
                    <%=friendActivity.Subject %>
                    <em class="tn-text-note tn-date">
                        <%= Convert.ToString(Formatter.FormatFriendlyDate(friendActivity.DateCreated))%></em>
                </div>
                <div class="tn-list-item-row tn-list-item-summary">
                    <% if (!string.IsNullOrEmpty(friendActivity.Body))
                       {%>
                    <p class="tn-helper-reset">
                        <%=friendActivity.Body%>
                    </p>
                    <%} %>
                </div>
                <%if (CurrentUser != null && friendActivity.ApplicationID == ApplicationIDs.Instance().MicroBlog() && (activityItem != null && friendActivity.ActivityItemID == activityItem.ItemID))
                  {
                      MicroBlogThread thread = MicroBlogThreads.GetThread(friendActivity.RelativeItemID, false);
                      if (thread == null)
                          thread = new MicroBlogThread();%>
                <div class="tn-list-item-row">
                    &nbsp &nbsp<a href="javascript:;" name="replay_<%=friendActivity.RelativeItemID%>"
                        id="<%=friendActivity.RelativeItemID %>" onclick="toggleMicroBlogComments(this,'<%=SPBUrlHelper.Action("Control_ListMicroBlogCommentsInActive", "UserDomainMicroBlog", new RouteValueDictionary { {"userDomainName",userDomainName},{ "threadID", friendActivity.RelativeItemID } })%>',<%=thread.ReplyCount %>);"><%=GetResourceString("Common_Reply")%>(<%=thread.ReplyCount %>)</a>
                </div>
                <%} %>
            </div>
            <%if (CurrentUser != null && friendActivity.ApplicationID == ApplicationIDs.Instance().MicroBlog() && (activityItem != null && friendActivity.ActivityItemID == activityItem.ItemID))
              {%>
            <div class="tn-simple-comments" id="showMicroBlogCommentsToggler_<%=friendActivity.RelativeItemID%>"
                style="display: none">
                <div class="tn-widget tn-bubble-box tn-bubble-box-arrow-top">
                    <div class="tn-bubble-box-arrow">
                        <b class="tn-arrow-b1 tn-widget-content tn-bg-light"></b>
                        <b class="tn-arrow-b2 tn-widget-content tn-bg-light"></b>
                        <b class="tn-arrow-b3 tn-widget-content tn-bg-light"></b>
                        <b class="tn-arrow-b4 tn-widget-content tn-bg-light"></b>
                        <b class="tn-arrow-b5 tn-widget-content tn-bg-light"></b>
                    </div>
                    <div class="tn-bubble-box-content tn-widget-content tn-bg-light tn-corner-all" id="microBlogReplyContainer_<%=friendActivity.RelativeItemID%>">
                        <div class="tn-loading">
                        </div>
                    </div>
                </div>
            </div>
            <%} %>
        </li>
        <%} %>
        <%} %>
    </ul>
    <%if (topNumber < totalRecords)
      { %>
    <div class="spb-show-more">
        <%=SPBHtmlHelper.Instance().LinkButton("showMore",GetResourceString("Button_ShowMore"), "javascript:;", ButtonSizes.Large, HighlightStyles.Default, IconTypes.CollapseOpen, TextIconLayout.IconText, new RouteValueDictionary { { "onclick", "ShowMore()" } }, null)%>
    </div>
    <%} %>

    <script type="text/javascript">
        $(document).ready(function() {
            $("span[menu]").menuButton();
            $("span[menu]").menuButton({ buttonHoverClass: 'ui-widget-content tn-action-hover' });
        });

        function ShowMore() {

            $('#friendActiveForLoad').parent().load('<%=SPBUrlHelper.Action("Control_ListFriendActivitiesBlock","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"topNumber",topNumber+10},{"applicationID",applicationID}}) %>');
        }

        function DeleteThisStory(url) {
            $('#friendActiveForLoad').parent().load(url);
        }
        function toggleMicroBlogComments(obj, url, count) {
            if ($('#showMicroBlogCommentsToggler_' + obj.id).is(':hidden')) {
                $("a[name='replay_" + obj.id + "']").text('收起回复(' + count + ')');
                $("#showMicroBlogCommentsToggler_" + obj.id).show();
                if (!$("#microBlogReplyContainer_" + obj.id).children().length || $("#microBlogReplyContainer_" + obj.id).find("div.tn-loading").length) {
                    $("#microBlogReplyContainer_" + obj.id).load(url);
                }
            }
            else {
                $("#showMicroBlogCommentsToggler_" + obj.id).hide();
                $("a[name='replay_" + obj.id + "']").text('<%=GetResourceString("Common_Reply")%>(' + count + ')');
            }
        }
    </script>

</div>
