﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<Invitation>>" %>
<spb:Script runat="server" ID="menuButton" Src="~/Utility/jquery/plugin/jquery.spb.menuButton.js"
    SetExpireDays="30" />
<% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("UserDomainName");
   bool isDeal = ViewData.GetBool("isDeal", false);

   int? applicationID = ViewData.GetInt("applicationID");
   if (applicationID <= 0)
       applicationID = null;
%>
<form id="ListInvitationInBoxForm" method="post">
<div class="tn-list-header tn-border-gray tn-border-bottom">
    <div class="tn-toolbar-area tn-helper-clearfix">
        <span class="tn-helper-right">
            <%=GetResourceString("Lable_Select")%><%=GetResourceString("Common_Colon")%>
            处理状态： <span class="tn-action <%if (!isDeal) Response.Write(" tn-text-note tn-selected"); %>">
                <a class="tn-action-text" href="javascript:;" onclick="$('#ListInvitationInBoxForm').parent().load('<%=SPBUrlHelper.Action("Control_ListInvitationInBox", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName },{"applicationID",applicationID}, { "pageIndex", ViewData.Model.PageIndex }, { "isDeal",false } })%>', { salt: new Date() });">
                    <%=GetResourceString("Action_NotDeal")%></a></span> <span class="tn-action <%if (isDeal) Response.Write(" tn-text-note tn-selected"); %>">
                        <a class="tn-action-text" href="javascript:;" onclick="$('#ListInvitationInBoxForm').parent().load('<%=SPBUrlHelper.Action("Control_ListInvitationInBox", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, {"applicationID",applicationID},{ "pageIndex", ViewData.Model.PageIndex }, { "isDeal", true } })%>', { salt: new Date() });">
                            <%=GetResourceString("Action_HasDeal") %></a></span> 邀请类型： <span class="tn-action <%if (applicationID== null) Response.Write(" tn-text-note tn-selected"); %>">
                                <a class="tn-action-text" href="javascript:;" onclick="$('#ListInvitationInBoxForm').parent().load('<%=SPBUrlHelper.Action("Control_ListInvitationInBox", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName },{ "pageIndex", ViewData.Model.PageIndex }, { "isDeal", isDeal } })%>', { salt: new Date() });">
                                    全部</a></span> <span class="tn-action <%if (applicationID== ApplicationIDs.Instance().Friend()) Response.Write(" tn-text-note tn-selected"); %>">
                                        <a class="tn-action-text" href="javascript:;" onclick="$('#ListInvitationInBoxForm').parent().load('<%=SPBUrlHelper.Action("Control_ListInvitationInBox", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, {"applicationID",ApplicationIDs.Instance().Friend()},{ "pageIndex", ViewData.Model.PageIndex }, { "isDeal", isDeal } })%>', { salt: new Date() });">
                                            朋友</a></span> <span class="tn-action <%if (applicationID== ApplicationIDs.Instance().Event()) Response.Write(" tn-text-note tn-selected"); %>">
                                                <a class="tn-action-text" href="javascript:;" onclick="$('#ListInvitationInBoxForm').parent().load('<%=SPBUrlHelper.Action("Control_ListInvitationInBox", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, {"applicationID",ApplicationIDs.Instance().Event()},{ "pageIndex", ViewData.Model.PageIndex }, { "isDeal", isDeal } })%>', { salt: new Date() });">
                                                    活动</a></span> <span class="tn-action <%if (applicationID== ApplicationIDs.Instance().Club()) Response.Write(" tn-text-note tn-selected"); %>">
                                                        <a class="tn-action-text" href="javascript:;" onclick="$('#ListInvitationInBoxForm').parent().load('<%=SPBUrlHelper.Action("Control_ListInvitationInBox", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, {"applicationID",ApplicationIDs.Instance().Club()},{ "pageIndex", ViewData.Model.PageIndex }, { "isDeal", isDeal } })%>', { salt: new Date() });">
                                                            群组</a></span> </span>
        <input type="checkbox" id="TopCheckBox" class="tn-checkbox" onclick="checkAll(this,'InvitationInBoxCheckBoxGroup')" />
        <label class="tn-check-all" for="TopCheckBox">
            <%=GetResourceString("Label_SelectAllOrNo")%></label>
        <%=SPBHtmlHelper.Instance().LinkButton("delete", GetResourceString("Action_Delete", ApplicationIDs.Instance().User()),"javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary { { "onclick", "deleteInvitation()" } }, null)%>
        <%if (applicationID.HasValue && applicationID.Value == ApplicationIDs.Instance().Friend() && !isDeal)
          { %>
        <%=SPBHtmlHelper.Instance().LinkButton("batchAcceptFriend", "批量接受好友申请", SPBUrlHelper.Action("Control_BatchSetFriendGroup", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName } }), ButtonSizes.Default, HighlightStyles.Default,IconTypes.Set,TextIconLayout.IconText)%>
        <%} %>
    </div>
</div>
<table class="tn-table-grid">
    <tbody>
        <%
            foreach (Invitation invitation in ViewData.Model.Records)
            {
                if (invitation.InvitationID > 0)
                {
        %>
        <tr class="tn-table-grid-row">
            <td class="tn-border-gray tn-border-bottom tn-width-check">
                <input type="checkbox" name="InvitationInBoxCheckBoxGroup" class="tn-checkbox" value="<%=invitation.InvitationID %>" />
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-avatar">
                <div class="tn-avatar">
                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(invitation.SenderUserID, true, HyperLinkTarget._self, AvatarSizeTypes.Small,null)%>
                </div>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-user-name">
                <cite>
                    <% if (invitation.SenderUserID > 0)
                       {  %>
                    <a class="tn-user-name" href="<%=SiteUrls.Instance().UserDomainHome(invitation.SenderUserID) %>"
                        title="<%=string.Format(GetResourceString("Description_Pattern_ViewUserDomain"), invitation.Sender)%>">
                        <%=invitation.Sender%></a>
                    <%}
                       else Response.Write(invitation.Sender); %>
                </cite><em class="tn-date tn-text-note">
                    <%=Formatter.FormatFriendlyDate(invitation.DateCreated)%></em>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-icon1">
                <%  if (invitation.ApplicationID == ApplicationIDs.Instance().Friend())
                        Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.UserInvite));
                    else if (invitation.ApplicationID == ApplicationIDs.Instance().Club())
                        Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.UserGroup));
                    else if (invitation.ApplicationID == ApplicationIDs.Instance().Event())
                        Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Event));
                %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-auto">
                <cite>
                    <%=invitation.Subject%></cite><span class="tn-snippet">
                        <%=HtmlUtils.TrimHtml(invitation.Body,500)%></span>
            </td>
            <% int returnToPageIndex = ViewData.Model.PageIndex;
               if ((ViewData.Model.TotalRecords == ViewData.Model.PageSize * (returnToPageIndex - 1) + 1) && (ViewData.Model.PageIndex > 1))
               {
                   returnToPageIndex = ViewData.Model.PageIndex - 1;
               }
               if (isDeal)
               { %>
            <td class="tn-border-gray tn-border-bottom tn-width-action1 tn-nowrap">
                <ul class="tn-actions">
                    <li><span class="tn-action"><span class="tn-action-text">
                        <% if (invitation.Status == InvitationStatuses.Accept)
                               Response.Write(GetResourceString("Lable_Accepted"));
                           else Response.Write(GetResourceString("Lable_Ignored")); %>
                    </span></span></li>
                </ul>
            </td>
            <%}
               else
               { %>
            <td class="tn-border-gray tn-border-bottom tn-width-action1 tn-nowrap">
                <ul class="tn-actions">
                    <li><span class="tn-button tn-button-default"><span class="tn-first-child">
                        <%if (invitation.ApplicationID == ApplicationIDs.Instance().Friend())
                          { %>
                        <a class="tn-button-text" name="acceptFriend" href="<%=SPBUrlHelper.Action("Control_SetFriendInfo","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"invitationID",invitation.InvitationID},{"pageIndex",ViewData.Model.PageIndex}}) %>">
                            <%=GetResourceString("Action_Accept")%></a>
                        <%}
                          else
                          { %>
                        <a class="tn-button-text" href="javascript:;" name="acceptButton" value="<%=SPBUrlHelper.Action("SetInvitationAcceptStatus","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"applicationID",applicationID}, {"invitationID",invitation.InvitationID},{"isAccept",true},{"pageIndex",ViewData.Model.PageIndex},{ "isDeal", isDeal }}) %>">
                            <%=GetResourceString("Action_Accept")%></a>
                        <%} %>
                    </span></span></li>
                    <li><span class="tn-button tn-button-secondary"><span class="tn-first-child"><a class="tn-button-text"
                        href="javascript:;" onclick="$('#ListInvitationInBoxDiv').load('<%=SPBUrlHelper.Action("SetInvitationAcceptStatus", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "invitationID", invitation.InvitationID }, { "isAccept", false }, { "pageIndex", ViewData.Model.PageIndex }, { "isDeal", isDeal } }) %>', { salt: new Date() })">
                        忽略</a> </span></span></li>
                </ul>
            </td>
            <%} %>
            <td class="tn-border-gray tn-border-bottom tn-width-action1 tn-nowrap">
                <ul class="tn-actions">
                    <li><span class="tn-action"><a class="tn-action-text" href="<%=SiteUrls.Instance().NewMessage(userDomainName,invitation.SenderUserID)%>">
                        <%=GetResourceString("Action_SendPrivateMessage")%></a> </span></li>
                    <li><span class="tn-action"><a class="tn-action-text" href="javascript:;" name="deleteButton"
                        value="<%=SPBUrlHelper.Action("DeleteInBoxInvitation","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"applicationID",applicationID}, {"invitationID",invitation.InvitationID},{"pageIndex",returnToPageIndex},{ "isDeal", isDeal }}) %>">
                        <%=GetResourceString("Action_Delete")%></a> </span></li>
                </ul>
            </td>
        </tr>
        <%}
            } %>
    </tbody>
</table>
<div class="tn-pagination tn-helper-align-center">
    <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11, SPBUrlHelper.Action("Control_ListInvitationInBox", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "applicationID", applicationID }, { "pageIndex", "{0}" }, { "isDeal", isDeal } }), "pageIndexChange")%>
    <div class="tn-page-results tn-text-note">
        <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords.ToString())%></div>
</div>
</form>
<script type="text/javascript">
    $(document).ready(function () {
        $("span[menu]").menuButton();
        $("tr span[menu]").menuButton({ buttonHoverClass: 'ui-widget-content tn-action-hover' });
        $.ajaxSetup({ cache: false });
        $("a[name='acceptButton']").click(function () {
            $('#ListInvitationInBoxDiv').load($(this).attr("value"), { salt: new Date() });
        });

        $("a[name='acceptFriend'],#batchAcceptFriend").click(function () {
            if ($(this).is("#batchAcceptFriend") && $("input[name='InvitationInBoxCheckBoxGroup']:checked").length == 0) {
                alert("请先选中所要批量接受的邀请");
                return false;
            }
            art.dialog.load($(this).attr("href"), {
                id: 'acceptFriendDialog',
                title: '接受好友请求',
                width: 400
            });
            return false;
        });

        $("a[name='deleteButton']").click(function () {
            if (confirm('<%=GetResourceString("Message_ConfirmDeleteInvit",ApplicationIDs.Instance().User()) %>'))
                $('#ListInvitationInBoxDiv').load($(this).attr("value"), { salt: new Date() });
        });
    });

    function pageIndexChange(url) {
        $('#ListInvitationInBoxDiv').load(url);
    }

    function deleteInvitation() {
        if (confirm('<%=GetResourceString("Message_ConfirmDeleteInvit",ApplicationIDs.Instance().User()) %>')) { $('#ListInvitationInBoxForm').ajaxSubmit({ target: '#ListInvitationInBoxDiv', url: '<%=SPBUrlHelper.Action("DeleteInBoxInvitations","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"applicationID",applicationID}, {"isDeal",isDeal}}) %>' }); }
    }
    
</script>
