﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<Invitation>>" %>
<spb:Script runat="server" ID="menuButton" Src="~/Utility/jquery/plugin/jquery.spb.menuButton.js"
    SetExpireDays="30" />
<% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("UserDomainName"); %>
<form id="ListInvitationOutBoxForm" method="post">
<div class="tn-list-header tn-border-gray tn-border-bottom">
    <div class="tn-toolbar-area tn-helper-clearfix">
        <input type="checkbox" id="TopCheckBox" class="tn-checkbox" onclick="checkAll(this,'InvitationOutBoxCheckBoxGroup')" />
        <label class="tn-check-all" for="TopCheckBox">
            <%=GetResourceString("Label_SelectAllOrNo")%></label>
        <%=SPBHtmlHelper.Instance().LinkButton("delete", GetResourceString("Action_Delete", ApplicationIDs.Instance().User()),"javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary { { "onclick", "deleteInvitation()" } }, null)%>
    </div>
</div>
<table class="tn-table-grid">
    <tbody>
        <% foreach (Invitation invitation in ViewData.Model.Records)
           {
               if (invitation.InvitationID > 0)
               {%>
        <tr class="tn-table-grid-row">
            <td class="tn-border-gray tn-border-bottom tn-width-check">
                <input type="checkbox" name="InvitationOutBoxCheckBoxGroup" class="tn-checkbox" value="<%=invitation.InvitationID %>" />
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-avatar">
                <div class="tn-avatar">
                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(invitation.SenderUserID, true, HyperLinkTarget._self, AvatarSizeTypes.Small,null)%>
                </div>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-user-name">
                <cite>
                    <%=GetResourceString("Label_InvitTo",ApplicationIDs.Instance().User()) %>
                    <% if (invitation.ReceiverUserID > 0)
                       { %>
                    <a class="tn-user-name" href="<%=SiteUrls.Instance().UserDomainHome(invitation.ReceiverUserID) %>"
                        title="<%=string.Format(GetResourceString("Description_Pattern_ViewUserDomain"), invitation.Receiver)%>">
                        <%=invitation.Receiver%></a>
                    <%}
                       else Response.Write(invitation.Receiver); %>
                </cite><em class="tn-date tn-text-note">
                    <%=Formatter.FormatFriendlyDate(invitation.DateCreated)%></em>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-icon1">
                <%  if (invitation.ApplicationID == ApplicationIDs.Instance().Friend())
                        Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.UserInvite));
                    else if (invitation.ApplicationID == ApplicationIDs.Instance().Club())
                        Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.UserGroup));
                    else if (invitation.ApplicationID == ApplicationIDs.Instance().Event())
                        Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Event));
                %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-auto">
                <cite>
                    <%=invitation.Subject%></cite><span class="tn-snippet">
                        <%=invitation.Body %></span>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-action2 tn-nowrap">
                <span class="tn-action">
                    <% if (invitation.Status == InvitationStatuses.Accept)
                           Response.Write(GetResourceString("Lable_Accepted"));
                       else if (invitation.Status == InvitationStatuses.Refuse)
                           Response.Write(GetResourceString("Lable_Ignored"));
                       else if (invitation.Status == InvitationStatuses.Unsettled)
                           Response.Write(GetResourceString("Label_Untreated", ApplicationIDs.Instance().User())); %>
                </span>
                <%=SPBHtmlHelper.Instance().ActionLink("message", GetResourceString("Action_SendPrivateMessage"), SiteUrls.Instance().NewMessage(userDomainName, invitation.ReceiverUserID), IconTypes.TriangleDown, TextIconLayout.MenuButton, null, new RouteValueDictionary { { "menu", "#moreOptions3" + invitation.InvitationID }})%>
                <div id="moreOptions3<%=invitation.InvitationID %>" class="tn-drop-menu ui-widget-content"
                    style="display: none;">
                    <ul class="tn-menu-drop-list">
                        <li class="tn-menu-drop-item">
                            <% int returnToPageIndex = ViewData.Model.PageIndex;
                               if ((ViewData.Model.TotalRecords == ViewData.Model.PageSize * (returnToPageIndex - 1) + 1) && (ViewData.Model.PageIndex > 1))
                               {
                                   returnToPageIndex = ViewData.Model.PageIndex - 1;
                               }
                            %>
                            <a href="javascript:void(0)" name="deleteButton" value="<%=SPBUrlHelper.Action("DeleteOutBoxInvitation","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"invitationID",invitation.InvitationID},{"pageIndex",returnToPageIndex}}) %>">
                                <%=GetResourceString("Action_Delete")%></a> </li>
                        <%if (invitation.ApplicationID == ApplicationIDs.Instance().Club())
                              Response.Write(string.Format("<li  class=\"tn-menu-drop-item\" id=\"browseLi\"><a href=\"{0}\" target=\"_blank\" >" + GetResourceString("Action_ViewClub") + "</a></li>", SiteUrls.Instance().ClubDomainHome(invitation.RelativeItemID)));

                          if (invitation.ApplicationID == ApplicationIDs.Instance().Event())
                              Response.Write(string.Format("<li class=\"tn-menu-drop-item\" id=\"browseLi\"><a href=\"{0}\" target=\"_blank\" >" + GetResourceString("Action_ViewEvent") + "</a></li>", SiteUrls.Instance().ShowEvent(invitation.RelativeItemID)));
                        %>
                    </ul>
                </div>
            </td>
        </tr>
        <%}
           } %>
    </tbody>
</table>
<div class="tn-pagination tn-helper-align-center">
    <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11, SPBUrlHelper.Action("Control_ListInvitationOutBox","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"pageIndex","{0}"}}), "pageIndexChange")%>
    <div class="tn-page-results tn-text-note">
        <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"),ViewData.Model.TotalRecords) %></div>
</div>
</form>

<script type="text/javascript">
    $(document).ready(function() {

        $("span[menu]").menuButton();
        $("tr span[menu]").menuButton({ buttonHoverClass: 'ui-widget-content tn-action-hover' });


        $("a[name='deleteButton']").click(function() {
            if (confirm('<%=GetResourceString("Message_ConfirmDeleteInvit",ApplicationIDs.Instance().User()) %>')) {
                $('#ListInvitationOutBoxDiv').load($(this).attr("value"), { salt: new Date() });
                return false;
            }
        });
    });
    function deleteInvitation() {
        if (confirm('<%=GetResourceString("Message_ConfirmDeleteInvit",ApplicationIDs.Instance().User()) %>'))
        { $('#ListInvitationOutBoxForm').ajaxSubmit({ target: '#ListInvitationOutBoxDiv', url: '<%=SPBUrlHelper.Action("DeleteOutBoxInvitations","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>' }); }
    }
    function pageIndexChange(url) {
        $('#ListInvitationOutBoxDiv').load(url);
    }
</script>

