﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<ClubActivity>>" %>
<% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   int applicationID = ApplicationIDs.Instance().Club();

   if (Model.Records.Count > 0)
   {%>
<div id="ListClubActivities">
    <% 
        if (TempData["StatusMessageData"] != null)
        {
            StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
            TempData["StatusMessageData"] = null;
        }
        int returnPageIndex = Model.PageIndex;
        if (Model.TotalRecords == (returnPageIndex * Model.PageSize + 1))
            returnPageIndex = returnPageIndex - 1;

    %>
    <ul class="tn-list tn-helper-reset">
        <% 
            Dictionary<int, Application> applications = Applications.GetApplications();
            string applicationKey = "default";
            string applicationName = GetResourceString("Description_ClubDynamic", applicationID);

            foreach (ClubActivity clubActivity in Model.Records)
            {
                if (clubActivity.Club == null)
                    continue;
        %>
        <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
            <%
                if (applications.ContainsKey(clubActivity.ApplicationID))
                {
                    applicationKey = applications[clubActivity.ApplicationID].ApplicationKey;
                    applicationName = applications[clubActivity.ApplicationID].GetMultilingualApplicationName(CurrentUserLanguage);
                }
                string filePath = WebUtils.ResolveUrl(string.Format("~/Themes/Shared/Styles/Icons/activity_{0}.gif", applicationKey.ToLower()));
            %>
            <div class="tn-list-item-area-left">
                <img src="<%=filePath %>" title="<%=string.Format(GetResourceString("Description_Pattern_ClubDynamic", applicationID),applicationName)%>"
                    alt="<%=string.Format(GetResourceString("Description_Pattern_ClubDynamic", applicationID),applicationName)%>"
                    width="16" height="16" />
            </div>
            <% if (CurrentUser != null && (Globals.GetCurrentUser().UserName == userDomainName || Globals.GetCurrentUser().IsContentAdministrator))
               {%>
            <div class="tn-list-item-area-right">
                <div class="spb-list-icon-actions">
                    <div class="spb-icon-action">
                        <a class="tn-icon tn-icon-cross" href="javascript:;" onclick="DeleteThisActivity('<%=SPBUrlHelper.Action("DeleteClubActivity","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"activityID",clubActivity.ActivityID},{"applicationID",clubActivity.ApplicationID},{"pageIndex",returnPageIndex }}) %>')">
                        </a>
                    </div>
                </div>
            </div>
            <%} %>
            <div class="tn-list-item-area-main">
                <div class="tn-list-item-row tn-list-item-heading">
                    <a href="<%=SiteUrls.Instance().UserDomainHome(clubActivity.LeadingActorUserID) %>">
                       <%=SPBHtmlHelper.Instance().UserDisplayName(clubActivity.LeadingActorUserID,true) %></a>
                    <%=string.Format(GetResourceString("Description_Pattern_ClubDynamicMessage", applicationID), "<a href=" + SiteUrls.Instance().ClubDomainHome(clubActivity.Club.DomainName) + " target='_blank'> "+clubActivity.Club.ClubName+"</a>", clubActivity.Subject, Formatter.FormatFriendlyDate(clubActivity.DateCreated))%>
                    <div class="tn-list-item-row tn-list-item-summary">
                        <% if (!string.IsNullOrEmpty(clubActivity.Body))
                           {%>
                        <p class="tn-helper-reset">
                            <%=clubActivity.Body%></p>
                        <%} %>
                    </div>
                </div>
            </div>
        </li>
        <%} %>
    </ul>
    <div class="tn-pagination tn-helper-align-center">
        <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex, 11, SPBUrlHelper.Action("Control_ListReceivedClubActivities", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
    </div>

    <script type="text/javascript">
        function DeleteThisActivity(url) {
            $('#ListClubActivities').parent().load(url);
        }
        function pageIndexChange(url) {
            $('#ListClubActivities').parent().load(url);
        }

    </script>

</div>
<%} %>