﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<UserActivity>>" %>
<div id="siteUserActive">
    <% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    %>
    <ul class="tn-list tn-helper-reset">
        <% 

            if (Model.Records.Count > 0)
            {
                Dictionary<int, Application> applications = Applications.GetApplications();
                string applicationKey = "default";
                string applicationName = GetResourceString("Title_ActivityApplicationName", ApplicationIDs.Instance().User());

                foreach (UserActivity userActivity in Model.Records)
                {
                    if (applications.ContainsKey(userActivity.ApplicationID))
                    {
                        applicationKey = applications[userActivity.ApplicationID].ApplicationKey;
                        applicationName = applications[userActivity.ApplicationID].GetMultilingualApplicationName(CurrentUserLanguage);
                    }
                    string filePath = WebUtils.ResolveUrl(string.Format("~/Themes/Shared/Styles/Icons/activity_{0}.gif", applicationKey.ToLower()));
        %>
        <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
            <div class="tn-list-item-area-left">
                <img src="<%=filePath %>" title="<%=applicationName %>" alt="<%=applicationName %>"
                    width="16" height="16" />
            </div>
            <div class="tn-list-item-area-right">
            </div>
            <div class="tn-list-item-area-main">
                <div class="tn-list-item-row tn-list-item-heading">
                    <%=userActivity.Subject%><em class="tn-text-note tn-date"><%= Convert.ToString(Formatter.FormatFriendlyDate(userActivity.DateCreated))%></em></div>
                <div class="tn-list-item-row tn-list-item-summary">
                    <p class="tn-helper-reset">
                        <%=userActivity.Body%></p>
                </div>
            </div>
        </li>
        <%} %>
    </ul>
    <div class="tn-pagination tn-helper-align-center">
        <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex, 11, SPBUrlHelper.Action("Control_ListSiteActivities", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
    </div>

    <script type="text/javascript">
        function DeleteThisStory(url) {
            if (confirm('<%=GetResourceString("Message_ConfirmDeleteActivity",ApplicationIDs.Instance().User()) %>'))
            { $('#siteUserActive').load(url); }
        }

        function pageIndexChange(url) {
            $('#siteUserActive').load(url);
        }
                  
    </script>

    <%} %>
</div>

<script type="text/javascript">
    $(document).ready(function() {
    $('#BatchDeleteButton').nyroModal({
            resizeable: true
        });
    });

    function toggleMicroBlogComments(showMicroBlogComments, microBlogThreadID, url) {
        if (showMicroBlogComments) {
            $('#microBlogReplyContainer-' + microBlogThreadID).load(url);
            $("#showMicroBlogCommentsToggler-" + microBlogThreadID).hide();
            $("#hideMicroBlogCommentsToggler-" + microBlogThreadID).show();
        }
        else {
            $('#microBlogReplyContainer-' + microBlogThreadID).html("");
            $("#showMicroBlogCommentsToggler-" + microBlogThreadID).show();
            $("#hideMicroBlogCommentsToggler-" + microBlogThreadID).hide();
        }
    }
</script>

