﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<UserActivity>>" %>
<%bool isMyActivity = ViewData.GetBool("isMyActivity", false); %>
<div id="userActiveForLoad<%=isMyActivity %>">
    <%
        bool isUserDomainOwner = ViewData.GetBool("isUserDomainOwner", false);
        string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
        int topNumber = ViewData.GetInt("topNumber", 0);
        int totalRecords = ViewData.GetInt("totalRecords", 0);
        int? applicationID = ViewData.GetInt("applicationID");
        if (applicationID == 0)
            applicationID = null;

        Dictionary<int, Application> applications = Applications.GetApplications(); %>
    <%if (TempData["StatusMessageType"] != null)
      {
          StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
          Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
          TempData["StatusMessageType"] = null;
      } %>
    <div class="tn-directory">
        <div class="tn-directory-level tn-border-gray tn-border-bottom">
            <span class="tn-directory-item <%if (applicationID == null) Response.Write(" tn-text-note tn-selected"); %>">
                <a href="#" onclick="$('#userActiveForLoad<%=isMyActivity %>').parent().load('<%=SPBUrlHelper.Action("Control_ListUserActivitiesForTab", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName },{"topNumber",topNumber},{"isMyActivity",isMyActivity} })%>')">
                    <%=GetResourceString("Enum_AccountStatuses_All")%></a>
            </span>
            <%if (applications != null)
              {
                  foreach (var appPair in applications)
                  {

                      if (!Applications.IsEnabled(appPair.Key))
                          continue;%>
            <span class="tn-directory-item <%if (applicationID == appPair.Key) Response.Write(" tn-text-note tn-selected"); %>">
                <a href="#<%=appPair.Value.ApplicationKey %>" onclick="$('#userActiveForLoad<%=isMyActivity %>').parent().load('<%=SPBUrlHelper.Action("Control_ListUserActivitiesForTab", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName },{"topNumber",topNumber},{"isMyActivity",isMyActivity}, { "applicationID",appPair.Key} })%>')">
                    <%=appPair.Value.GetMultilingualApplicationName(CurrentUserLanguage) %></a></span>
            <%}
              } %>
        </div>
    </div>
    <% if (Model.Count > 0)
       {%>
    <ul class="tn-list">
        <%  ActivityItem activityItem = Activities.GetActivityItem(ActivityItemKeys.Instance().NewMicroBlogThread());
            string applicationKey = "default";
            string applicationName = GetResourceString("Title_ActivityApplicationName", ApplicationIDs.Instance().User());
            foreach (UserActivity userActivity in Model)
            {%>
        <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
            <div class="tn-list-item-area-left">
                <% if (applications.ContainsKey(userActivity.ApplicationID))
                   {
                       applicationKey = applications[userActivity.ApplicationID].ApplicationKey;
                       applicationName = applications[userActivity.ApplicationID].GetMultilingualApplicationName(CurrentUserLanguage);
                   }
                   string filePath = WebUtils.ResolveUrl(string.Format("~/Themes/Shared/Styles/Icons/activity_{0}.gif", applicationKey.ToLower()));
                %>
                <img src="<%=filePath %>" title="<%=applicationName %>" alt="<%=applicationName %>"
                    width="16" height="16" />
            </div>
            <% if (CurrentUser != null && (CurrentUser.IsContentAdministrator) || CurrentUser.UserName == userDomainName && isMyActivity == true)
               {%>
            <div class="tn-list-item-area-right">
                <div class="spb-list-icon-actions">
                    <div class="spb-icon-action">
                        <a class="tn-icon tn-icon-cross" href="javascript:;" onclick=" DeleteThisStory('<%=SPBUrlHelper.Action("DeleteUserActivityForTab", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName },{"topNumber",topNumber}, { "activityID", userActivity.ActivityID }, { "isMyActivity", isMyActivity } })%>')">
                        </a>
                    </div>
                </div>
            </div>
            <%} %>
            <div class="tn-list-item-area-main">
                <div class="tn-list-item-row tn-list-item-heading">
                    <%=userActivity.Subject %>
                    <em class="tn-text-note tn-date">
                        <%= Convert.ToString(Formatter.FormatFriendlyDate(userActivity.DateCreated))%></em>
                </div>
                <div class="tn-list-item-row tn-list-item-summary">
                    <% if (!string.IsNullOrEmpty(userActivity.Body))
                       {%>
                    <p class="tn-helper-reset">
                        <%=userActivity.Body%>
                    </p>
                    <%}%>
                </div>
                <%if (CurrentUser != null && userActivity.ApplicationID == ApplicationIDs.Instance().MicroBlog() && (activityItem != null && userActivity.ActivityItemID == activityItem.ItemID))
                  {
                      MicroBlogThread thread = MicroBlogThreads.GetThread(userActivity.RelativeItemID, false);
                      if (thread == null)
                          thread = new MicroBlogThread();%>
                <div class="tn-list-item-row">
                    &nbsp &nbsp<a href="javascript:;" name="replay_<%=userActivity.RelativeItemID%>"
                        id="<%=userActivity.RelativeItemID %>" onclick="toggleMicroBlogComments(this,'<%=SPBUrlHelper.Action("Control_ListMicroBlogCommentsInActive", "UserDomainMicroBlog", new RouteValueDictionary { {"userDomainName",userDomainName},{ "threadID", userActivity.RelativeItemID } })%>',<%=thread.ReplyCount %>);"><%=GetResourceString("Common_Reply")%>(<%=thread.ReplyCount %>)</a>
                </div>
                <%} %>
            </div>
            <%if (CurrentUser != null && userActivity.ApplicationID == ApplicationIDs.Instance().MicroBlog() && (activityItem != null && userActivity.ActivityItemID == activityItem.ItemID))
              { %>
            <div class="tn-simple-comments" id="showMicroBlogCommentsToggler_<%=userActivity.RelativeItemID%>"
                style="display: none">
                <div class="tn-widget tn-bubble-box tn-bubble-box-arrow-top">
                    <div class="tn-bubble-box-arrow">
                        <b class="tn-arrow-b1 tn-widget-content tn-bg-light"></b>
                        <b class="tn-arrow-b2 tn-widget-content tn-bg-light"></b>
                        <b class="tn-arrow-b3 tn-widget-content tn-bg-light"></b>
                        <b class="tn-arrow-b4 tn-widget-content tn-bg-light"></b>
                        <b class="tn-arrow-b5 tn-widget-content tn-bg-light"></b>
                    </div>
                    <div class="tn-bubble-box-content tn-widget-content tn-bg-light tn-corner-all" id="microBlogReplyContainer_<%=userActivity.RelativeItemID%>">
                        <div class="tn-loading">
                        </div>
                    </div>
                </div>
            </div>
            <%} %>
        </li>
        <%} %>
    </ul>
    <%if (topNumber < totalRecords)
      {%>
    <div class="spb-show-more">
        <%=SPBHtmlHelper.Instance().LinkButton("showMore",GetResourceString("Button_ShowMore"), "javascript:;", ButtonSizes.Large, HighlightStyles.Default, IconTypes.CollapseOpen, TextIconLayout.IconText, new RouteValueDictionary { { "onclick", "ShowMore()" } }, null)%>
    </div>
    <%} %>
    <%} %>

    <script type="text/javascript">

        function DeleteThisStory(url) {
            $('#userActiveForLoad<%=isMyActivity %>').parent().load(url);
        }

        function ShowMore() {

            $('#userActiveForLoad<%=isMyActivity %>').parent().load('<%=SPBUrlHelper.Action("Control_ListUserActivitiesForTab","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"topNumber",topNumber+10},{"isMyActivity",isMyActivity},{"applicationID",applicationID}}) %>');
        }
        function toggleMicroBlogComments(obj, url, count) {
            if ($('#showMicroBlogCommentsToggler_' + obj.id).is(':hidden')) {
                $("a[name='replay_" + obj.id + "']").text('收起回复(' + count + ')');
                $("#showMicroBlogCommentsToggler_" + obj.id).show();
                if (!$("#microBlogReplyContainer_" + obj.id).children().length || $("#microBlogReplyContainer_" + obj.id).find("div.tn-loading").length) {
                    $("#microBlogReplyContainer_" + obj.id).load(encodeURI(url));
                }
            }
            else {
                $("#showMicroBlogCommentsToggler_" + obj.id).hide();
                $("a[name='replay_" + obj.id + "']").text('<%=GetResourceString("Common_Reply")%>(' + count + ')');
            }
        }
    </script>

</div>
