﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<User>" %>
<%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName"); %>
<div class="spb-add-friend">
    <%
        User receiver = ViewData.Model;
        if (TempData["StatusMessageData"] != null || ViewData["StatusMessageData"] != null)
        {
            StatusMessageData statusMessageData = null;
            if (TempData["StatusMessageData"] != null)
                statusMessageData = (StatusMessageData)TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
            else
                statusMessageData = (StatusMessageData)ViewData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
            if (statusMessageData.MessageType == StatusMessageType.Success)
            {
                Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
            }
            TempData["StatusMessageData"] = null;
            ViewData["StatusMessageData"] = null;
        }
        else
        {
    %>
    <form class="nyroModal" id="NewFriendInvitationForm" name="NewFriendInvitationForm"
    action="<%=SPBUrlHelper.Action("CreateFriendInvitation","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"toUserID",receiver.UserID}}) %>"
    method="post">
    <input type="hidden" id="Hidden1" name="receiverUserID" value="<%= receiver.UserID %>" />
    <div class="tn-text-heading tn-border-gray tn-border-bottom">
        <strong>加好友请求</strong></div>
    <div class="tn-text-note">
        <%=string.Format(GetResourceString("Description_Pattern_NewFriendInvitDescription", ApplicationIDs.Instance().User()), receiver.DisplayName)%></div>
    <div class="tn-form">
        <div class="tn-form-row tn-helper-clearfix tn-textarea-wrap">
            <div class="tn-helper-left">
                <div class="tn-avatar">
                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(Model.UserID,true,HyperLinkTarget._self,AvatarSizeTypes.Small) %></div>
            </div>
            <textarea name="body" cols="" rows="" id="body" class="tn-textarea tn-border-gray"></textarea>
        </div>
        <div class="tn-form-row-button tn-bg-gray tn-border-gray tn-border-top">
            <%= SPBHtmlHelper.Instance().SubmitButton("sendInvitation", GetResourceString("Button_Send"), ButtonSizes.Default, null, null)%>
            <%=SPBHtmlHelper.Instance().CancelButton(new RouteValueDictionary { { "class", "nyroModalClose" }})%>
        </div>
    </div>
    </form>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        $("#body").watermark("附加信息（选填，不超过64个字）");
        $("#NewFriendInvitationForm").validate({
            rules: {
                body: { maxBlength: 64 }
            },
            messages: {
                body: { maxBlength:"<%=string.Format(GetResourceString("Validate_Pattern_NewMessageBodyMaxLength", ApplicationIDs.Instance().User()), 64)%>"}
            }
        });
        $("#sendInvitation").click(function() {
            if (!$("#NewFriendInvitationForm").valid()) {
                return false;
            }
        });
		$("textarea.tn-textarea").after('<span style="display:none"></span>'); 

    }); 
</script>
<%}%>
