﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<GuestbookPost>>" %>
<spb:script runat="server" id="qtip" src="~/Utility/jquery/plugin/jquery.qtip-1.0.0-rc3.js"
    setexpiredays="30" />
<div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-content tn-widget-content tn-corner-all">
        <ul class="tn-comments">
            <%
                string userDomainName = Html.GetParameterFromRouteDateOrQueryString("UserDomainName");
                //如果当前用户是空间主人或管理员，则具有查看悄悄话的权限
                bool hasManagePermission = CurrentUser != null && (CurrentUser.UserID == UserID2UserNameDictionary.GetUserID(userDomainName) || CurrentUser.IsContentAdministrator);
                Dictionary<int, User> guestBookUsers = ViewData["guestBookUsers"] as Dictionary<int, User>;

                foreach (GuestbookPost post in ViewData.Model.Records)
                {
                    User user = null;
                    guestBookUsers.TryGetValue(post.PostID, out user);
                    //如果当前用户是被回复人或是留言作者
                    bool hasViewPrivatePostPermission = hasManagePermission || CurrentUser != null && (post.ParentUserID == CurrentUser.UserID || post.UserID == CurrentUser.UserID);
                    if (post.IsPrivate && !hasViewPrivatePostPermission)
                        continue;
            %>
            <li class="tn-comment-item tn-border-gray tn-border-bottom">
                <div class="tn-comment tn-helper-clearfix">
                    <div class="tn-comment-avatar">
                        <div class="tn-avatar">
                            <%=SPBHtmlHelper.Instance().ShowUserAvatar(post.UserID, true, HyperLinkTarget._self, AvatarSizeTypes.Small,null)%>
                        </div>
                    </div>
                    <% int returnToPageIndex = ViewData.Model.PageIndex;
                       if ((ViewData.Model.TotalRecords == ViewData.Model.PageSize * (returnToPageIndex - 1) + 1) && (ViewData.Model.PageIndex > 1))
                       {
                           returnToPageIndex = ViewData.Model.PageIndex - 1;
                       }
                       bool isAllowed = ViewData.GetBool("IsAllowed", false);
                       if (isAllowed)
                       {
                    %>
                    <a class="tn-icon tn-icon-cross tn-helper-right" href="javascript:;" onclick="if (confirm('<%=GetResourceString("Message_ConfirmDeleteThisGuestBookPost",ApplicationIDs.Instance().User()) %>')) $('#ShowGuestBookDiv').load('<%=SPBUrlHelper.Action("DeleteGuestBook","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"postID",post.PostID},{"pageIndex",returnToPageIndex}}) %>')">
                    </a>
                    <%} %>
                    <div class="tn-comment-info">
                        <div class="tn-commentator">
                            <h5>
                                <% if (post.UserID > 0)
                                   { %>
                                <a class="tn-author" href="<%=SiteUrls.Instance().UserChannelHome(post.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
                                    title="<%=string.Format(GetResourceString("Description_Pattern_ViewUserDomain"), post.Author)%>">
                                    <%=post.Author%></a>
                                <%}
                                   else Response.Write(post.Author); %>
                            </h5>
                            <em class="tn-text-note tn-date">
                                <%=Formatter.FormatFriendlyDate(post.PostDate)%></em><span class="tn-text-note">
                                    <% if (CurrentUser != null && post.UserID != CurrentUser.UserID)
                                       {  %>
                                    <a href="javascript:;" onclick="$('#body').focus(); $('#body').attr('value','<%=GetResourceString("Common_Reply") %><%=post.Author %><%=GetResourceString("Common_Colon") %>');$('#parentID').attr('value','<%=post.PostID %>'); <%=string.Format("$('#isPrivate').attr('checked',{0}).attr('disabled',{0});",post.IsPrivate.ToString().ToLower()) %>">
                                        <%=GetResourceString("Common_Reply")%></a>
                                    <%} %>
                                </span>
                            <% if (post.IsPrivate)
                               { %>
                            <span class="tn-text-note">
                                <%=GetResourceString("Label_GuestBookPrivatePost",ApplicationIDs.Instance().User()) %></span>
                            <%} %>
                        </div>
                        <%if (post.ParentID > 0)
                          { %>
                        <blockquote class="tn-cue-tips tn-bg-gray tn-border-gray">
                            <p>
                                <%=GetResourceString("Common_Reply")%>
                                <a class="tn-author" href="<%=SiteUrls.Instance().UserDomainHome(post.ParentUserID) %>">
                                    <%=post.ParentAuthor%></a><em class="tn-text-note tn-date"><%=Formatter.FormatDate(post.ParentPostDate, true)%></em></p>
                            <p>
                                <%=post.ParentBody%></p>
                        </blockquote>
                        <%} %>
                        <p>
                            <%=post.Body %></p>
                    </div>
                </div>
            </li>
            <%} %>
        </ul>
        <div class="tn-pagination tn-helper-align-center">
            <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11, SPBUrlHelper.Action("Control_ShowGuestBook","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"pageIndex","{0}"}}), "pageIndexChange")%>
            <%--<div class="tn-page-results tn-text-note">
                <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%>
            </div>--%>
        </div>
        <%
            if (TempData["StatusMessageType"] != null)
            {
                StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                if (messageType == StatusMessageType.Success)
                    Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
                else
                    Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), true));
                TempData["StatusMessageType"] = null;
            }
        %>
        <% SiteSettings settings = SiteSettingsManager.GetSiteSettings();
           if (CurrentUser != null && settings.EnableAnonymousPosting || CurrentUser != null)
           { %>
        <form id="ShowGuestBookForm" class="tn-helper-reset" method="post" action="<%=SPBUrlHelper.Action("CreateGuestBookPost","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"pageIndex",ViewData.Model.PageIndex}}) %>">
        <div class="tn-form tn-label-top">
            <div class="tn-comment-form-wrap tn-emotion-box tn-bg-gray">
                <%  ViewData["textAreaID"] = "body";%>
                <div class="tn-comment-form tn-emotion-box">
                    <div class="tn-comment-text-wrap tn-border-gray tn-form-row-near tn-textarea-wrap">
                        <%  Html.RenderAction<ChannelController>(n => n.Control_SmileySelector("smileySelector", "body"));%>
                        <textarea id="body" name="body" cols="84" rows="5" class="tn-comment-text-area"><%=TempData.GetString("Body", string.Empty)%></textarea>
                        <span style="display: none"></span>
                    </div>
                    <div class="tn-form-row">
                        <span class=" tn-text-note">（<%=GetResourceString("Message_NewGuestBookPostMaxBobyHint",ApplicationIDs.Instance().User()) %>）</span>
                    </div>
                </div>
                <%            
                        if (settings.VerifyCodeOption == VerifyCodeOption.Enabled || CurrentUser == null && settings.VerifyCodeOption == VerifyCodeOption.Anonymous)
                        {
                            if (CurrentUser == null)
                            { %>
                <div class="tn-form-row">
                    <label class="tn-form-label">
                        <%=GetResourceString("Label_CommonName")%><%=GetResourceString("Common_Colon") %>
                    </label>
                    <input type="text" id="author" class="tn-textbox tn-input-long tn-border-gray" name="author"
                        maxlength="30" value="<%=TempData.GetString("Author",string.Empty) %>" title="<%=GetResourceString("Message_EnteYourUserName") %>" />
                </div>
                <%} %>
                <div class="tn-form-row tn-form-row-verifycode">
                    <label>
                        <%=GetResourceString("Label_VerifyCode")%><%=GetResourceString("Common_Colon") %></label>
                    <%=SPBHtmlHelper.Instance().ShowVerificationCode("verifyCode",VerificationCodeDifficultyLevel.Low) %>
                </div>
                <%
                        } %>
                <div class="tn-form-row tn-form-row-button">
                    <%=SPBHtmlHelper.Instance().SubmitButton("submitGuestBookPost",GetResourceString("Button_SubmitGuestBookPost",ApplicationIDs.Instance().User()),ButtonSizes.Default,null,null) %>
                    <% if (CurrentUser != null)
                           { %>
                    <input type="hidden" id="parentID" name="parentID" value="<%=TempData.GetInt("parentID", 0)%>" />
                    <input type="checkbox" id="isPrivate" name="isPrivate" class="tn-checkbox" value="true" />
                    <label for="isPrivate">
                        <%=GetResourceString("Label_GuestBookPrivatePost", ApplicationIDs.Instance().User())%></label>
                    <%} %>
                </div>
            </div>
        </div>
        </form>
        <%} %>
        <% bool isPrivate = TempData.GetBool("isPrivate", false); %>
    </div>
    <script type="text/javascript">
    $(document).ready(function() {
             $("#verifyCode").watermark("<%=GetResourceString("Title_NotCaseSensitive")%>");
             
        $("#ShowGuestBookForm").validate({
            errorLabelContainer:"div.tn-text-note",
            rules: {
                verifyCode: { required: true },
                body: { required: true, rangelength: [1, 300] }
            },
            messages: {
                verifyCode: { required: "<%=GetResourceString("Validate_FillInValidate") %>" },
                body: { required: "<%=GetResourceString("Validate_NewGuestBookPostBodyErrorForEmpty",ApplicationIDs.Instance().User()) %>", rangelength: "<%=string.Format(GetResourceString("Validate_Pattern_NewGuestBookPostBodyErrorForLength", ApplicationIDs.Instance().User()), 300)%>" }
            }
        });
        
        $('#ShowGuestBookForm').ajaxForm({
            beforeSubmit: function() {
                if (!$("#ShowGuestBookForm").valid()) { return false; }
                $('#ShowGuestBookForm').block({
                    message: '<%=GetResourceString("Message_Loading")%>'
                });
            },
            target: '#ShowGuestBookDiv',
            success: function() {
                $('#ShowGuestBookForm').unblock();
            }
        });
        
    <% if(isPrivate) Response.Write("$('#isPrivate').attr('checked',true);"); %>

        $('.nyroModal').nyroModal({
            resizeable: true
        });
    });
    function pageIndexChange(url) {
        $('#ShowGuestBookDiv').load(url);
    }
    </script>
</div>
