﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PrivateMessage>" %>

<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-show-message">
  <div class="tn-box-content tn-widget-content tn-corner-all">
    <div class="tn-text-heading">
      <% PrivateMessage message = ViewData.Model;
               
               string senderName = message.Sender;
               string receiverName = message.Receiver;
            %>
      <h4> <%=message.Subject %></h4>
    </div>
    <% if (message.MessageType != PrivateMessageType.System)
           { %>
    <div class="tn-list-header tn-border-gray tn-border-bottom"> <span class="tn-text-note"> <%=GetResourceString("Label_PrivateMessagePartner", ApplicationIDs.Instance().User())%><%=GetResourceString("Common_Colon")%>
      <% if (message.SenderUserID > 0)
                   { %>
      <a class="tn-user-name" href="<%=SiteUrls.Instance().UserChannelHome(message.SenderUserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
                    id="sender">
      <%if (CurrentUser != null && message.SenderUserID == CurrentUser.UserID) Response.Write(GetResourceString("Lable_your")); else Response.Write(senderName); %>
      </a>
      <%}
                   else Response.Write(senderName); %>
      <%=GetResourceString("Lable_Add")%>
      <% if (message.ReceiverUserID > 0)
                   { %>
      <a class="tn-user-name" href="<%=SiteUrls.Instance().UserChannelHome(message.ReceiverUserID, UserDomainSpecialAppIDs.Instance().Home()) %>">
      <% =receiverName%>
      </a>
      <%}
                   else Response.Write(receiverName);  %>
      </span>
      <div class="tn-blank10"></div>
    </div>
    <%} %>
    <table class="tn-table-grid">
      <tbody>
        <% PrivateMessagePost post = new PrivateMessagePost();
                   post.PostID = message.PostID;
                   post.Subject = message.Subject;
                   post.Author = message.Sender;
                   post.Body = message.Body;
                   post.UserID = message.SenderUserID;
                   post.PostDate = message.PostDate;
                   List<PrivateMessagePost> list = new List<PrivateMessagePost>();
                   list.Add(post);
                   list.AddRange(message.Replies); %>
        <% foreach (PrivateMessagePost item in list)
                   {
                %>
        <tr class="tn-table-grid-row">
          <td class="tn-border-gray tn-border-bottom tn-width-avatar"><div class="tn-avatar">
              <% if (item.UserID == (int)PrivateMessageEspecialUserID.Serve)
                               { %>
              <img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/ServeAvatar.gif") %>"
                                width="46" height="46" />
              <%}
                               else if (item.UserID == (int)PrivateMessageEspecialUserID.System)
                               {%>
              <img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/SystemAvatar.gif") %>"
                                width="46" height="46" />
              <% }
                               else
                               {
                                   if (item.UserID > 0)
                                   { %>
              <%=SPBHtmlHelper.Instance().ShowUserAvatar(item.UserID, true, HyperLinkTarget._self, AvatarSizeTypes.Small)%>
              <%}
                               }%>
            </div></td>
          <td class="tn-border-gray tn-border-bottom tn-width-user-name"><cite>
            <% if (item.UserID > 0)
                               { %>
            <a class="tn-user-name" href="<%=SiteUrls.Instance().UserChannelHome(item.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
                                title="<%=string.Format(GetResourceString("Description_Pattern_ViewUserDomain"), item.Author)%>"> <%=item.Author %></a>
            <%}
                               else Response.Write(item.Author); %>
            </cite><em class="tn-date tn-text-note"> <%=Formatter.FormatFriendlyDate(item.PostDate) %></em></td>
          <td class="tn-border-gray tn-border-bottom tn-width-auto"><%=item.Body%></td>
        </tr>
        <%} %>
      </tbody>
    </table>
    <%   
            if (TempData["StatusMessageType"] != null)
            {
                StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                if (messageType == StatusMessageType.Success)
                    Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
                else
                    Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
                TempData["StatusMessageType"] = null;
            }
        %>
    <%if (!message.IsLocked)
          {  %>
    <form id="replyMessageForm" action="<%=SPBUrlHelper.Action("replyMessage","MessageCenter",new RouteValueDictionary{{"userDomainName",Html.GetParameterFromRouteDateOrQueryString("UserDomainName")},{"threadID",message.ThreadID}}) %>"
        method="post">
      <div class="tn-form tn-label-right spb-message-form">
        <div class="tn-form-row tn-emotion-box">
          <label class="tn-form-label"> <%=GetResourceString("Common_Reply")%><%=GetResourceString("Common_Colon")%></label>
          <div class="tn-emotion-textarea tn-textarea-wrap">
            <%  Html.RenderAction<ChannelController>(n => n.Control_SmileySelector("smiley", "body"));%>
            <textarea class="tn-textarea tn-input-longest tn-border-gray" rows="5"
                        cols="60" name="body" id="body"></textarea>
                        <span style="display:none"></span>
          </div>
          <div class="tn-text-note tn-helper-clear"> <%=GetResourceString("Message_NewMessageMaxBobyHint",ApplicationIDs.Instance().User())%> </div>
        </div>
        <div class="tn-form-row tn-form-row-button">
          <label class="tn-form-label"> &nbsp;</label>
          <%=SPBHtmlHelper.Instance().SubmitButton("submitButtom", GetResourceString("Common_Reply"))%>
          <% if (Request.UrlReferrer != null)
                   {%>
          <%=SPBHtmlHelper.Instance().CancelButton(Request.UrlReferrer.AbsoluteUri)%>
          <%} %>
        </div>
      </div>
    </form>
    <%} %>
  </div>
</div>
<script type="text/javascript">

    $(document).ready(function() {
    
        $("#replyMessageForm").validate({
            rules: {
                body: { required: true, rangelength: [1, 3000] }
            },
            messages: {
                body: { required: "<%=GetResourceString("Validate_NewMessageBodyEmpty",ApplicationIDs.Instance().User()) %>", rangelength: "<%=string.Format(GetResourceString("Validate_Pattern_NewMessageBodyMaxLength",ApplicationIDs.Instance().User()),3000) %>" }
            }
        });

        $('#replyMessageForm').ajaxForm({
            beforeSubmit: function() {
                if (!$("#replyMessageForm").valid()) { return false; }
            },
            target: '#showMessage',
            success: function() {
                $('#body').attr('value', '');
                $('#replyMessageForm').unblock();
            }
        });
        
    }); 
</script>
