﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<MicroBlogComment>>" %>
<% MicroBlogThread thread = ViewData["MicroBlogThread"] as MicroBlogThread;
   if (thread == null)
       thread = new MicroBlogThread();
   string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");%>
<form method="post" id="microBlogReplyForm_<%=thread.ThreadID %>" action="<%=SPBUrlHelper.Action("CreateMicroBlogCommentInActive","UserDomainMicroBlog",new RouteValueDictionary{{"userDomainName", WebUtils.UrlEncode(userDomainName)},{"threadID",thread.ThreadID}})%>">
<div class="tn-comment-form-wrap">
    <div class="tn-comment-form">
        <div class="tn-comment-text-wrap tn-widget-content tn-border-light tn-textarea-wrap">
            <textarea name="microBlogCommentBody" id="microBlogCommentBody_<%=thread.ThreadID %>"
                cols="" rows="" class="tn-textarea"></textarea>
                <span style="display:none"></span>
        </div>
        <div class="tn-send-comments">
            <%=SPBHtmlHelper.Instance().SubmitButton(string.Empty, GetResourceString("Common_Reply"),ButtonSizes.Default,null,null)%>
            <%=SPBHtmlHelper.Instance().Button("postCancel_" + thread.ThreadID, GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Secondary, null, new RouteValueDictionary { { "onclick", "toggleMicroBlogComments(false,'" + thread.ThreadID + "')" } })%>
        </div>
    </div>
</div>
</form>
<%   if (TempData["StatusMessageData"] != null)
     {
         StatusMessageData messageData = TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, "发布微博失败！"));
         Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData, 2000, false));
         TempData["StatusMessageData"] = null;

     } %>
<div class="tn-comment-wrap" id="commentContent_<%=thread.ThreadID %>">
    <%if (Model != null && Model.Count > 0)
      { %>
    <ul class="tn-comments tn-helper-reset">
        <% foreach (var comments in Model)
           {%>
        <li class="tn-comment-item tn-border-gray tn-border-bottom">
            <div class="tn-comment tn-helper-clearfix">
                <div class="tn-comment-avatar">
                    <div class="tn-avatar">
                        <a href="<%=SiteUrls.Instance().MyMicroBlogs(comments.UserID) %>">
                            <%=SPBHtmlHelper.Instance().ShowUserAvatar(comments.UserID,false,HyperLinkTarget._blank,AvatarSizeTypes.Small) %>
                        </a>
                    </div>
                </div>
                <% if (CurrentUser != null && (CurrentUser.IsContentAdministrator || CurrentUser.UserID == comments.UserID || CurrentUser.UserID == comments.OwnerUserID))
                   {%>
                <a class="tn-icon tn-icon-cross tn-helper-right" href="javascript:;" onclick="if(confirm('确认删除当前评论？')) {$('#commentContent_<%=thread.ThreadID %>').parent().load('<%=SPBUrlHelper.Action("DeleteMicroBlogCommentInActive", "UserDomainMicroBlog", new RouteValueDictionary { { "userDomainName", userDomainName },{"threadID",thread.ThreadID}, { "commentID", comments.CommentID} })%>');} return false;">
                </a>
                <%} %>
                <div class="tn-comment-info">
                    <div class="tn-commentator">
                        <h5>
                            <a href="<%=SiteUrls.Instance().MyMicroBlogs(comments.UserID) %>" class="tn-author"
                                title="<%=comments.Author %>" target="_blank">
                                <%=comments.Author %></a></h5>
                        <em class="tn-text-note tn-date">
                            <%=Formatter.FormatFriendlyDate(comments.DateCreated) %></em>
                        <%--<span class="tn-text-note"><a
                                        href="#">回复</a></span>--%>
                    </div>
                    <p>
                        <%=comments.Body %></p>
                </div>
            </div>
        </li>
        <%} %>
        <%if (Model.Count >= 10)
          {%>
        <li class="tn-comment-item">
            <a href="<%=SiteUrls.Instance().ShowMicroBlog(thread.UserID,thread.ThreadID) %>">查看全部<%=thread.ReplyCount %>条评论</a></li>
        <%} %>
    </ul>
    <%} %>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $("#microBlogReplyForm_<%=thread.ThreadID %>").validate({
            rules: {
                microBlogCommentBody: { required: true, maxBlength: 140 }
            },
            messages: {
                microBlogCommentBody: { required: "必须输入回复内容！", maxBlength: "<%=string.Format(GetResourceString("Validate_Pattern_BodyMaxLength", ApplicationIDs.Instance().MicroBlog()), 140)%>" }
            },
            showErrors: $.dialog.showErrors,
            onfocusout: false,
            onclick: false,
            onkeyup:false,
            onsubmit:true
        });

        $("#microBlogReplyForm_<%=thread.ThreadID %> :submit").click(function() {
            if (!$("#microBlogReplyForm_<%=thread.ThreadID %>").valid()) {
                return false;
            }
        });

        $("#microBlogReplyForm_<%=thread.ThreadID %>").ajaxForm({
            target: '#microBlogReplyContainer_<%=thread.ThreadID %>',
            beforeSubmit: function() {
                $('#microBlogReplyForm_<%=thread.ThreadID %>').block({
                    message: '<%=GetResourceString("Message_Loading")%>'
                });
            },
            success: function() {
                $('#microBlogReplyForm_<%=thread.ThreadID %>').unblock();
            }
        });
        
        $("#postCancel_<%=thread.ThreadID %>").click(function(){
            $("#showMicroBlogCommentsToggler_<%=thread.ThreadID %>").hide();
            $("a[name='replay_<%=thread.ThreadID %>']").text('回复');
        });

    });
    
</script>

