﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<User>" %>
<% User currentDomainUser = ViewData.Model;
   string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   int userID = CurrentUser != null ? CurrentUser.UserID : 0;
   int applicationID = ApplicationIDs.Instance().User(); 
%>
<div class="spb-user-panel">
    <div class="tn-avatar-big">
        <%=SPBHtmlHelper.Instance().ShowUserAvatar(currentDomainUser, false, HyperLinkTarget._self, AvatarSizeTypes.Normal, false,null)%>
    </div>
    <ul class="tn-side-menu">
        <% if (CurrentUser != null && CurrentUser.UserID != currentDomainUser.UserID && CurrentUser.UserType == UserTypes.PersonUser)
           {%>
        <% if (currentDomainUser.UserType != UserTypes.CompanyUser)
           { %>
        <li class="tn-border-gray tn-border-bottom">
            <%=SPBHtmlHelper.Instance().Icon(IconTypes.UserRelation)%>
            <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ListConnectPaths", "Friend", new RouteValueDictionary { {"userDomainName",CurrentUser.UserName},{"toUserID",currentDomainUser.UserID}})%>"
                target="_blank" title="<%=GetResourceString("Description_ShowAllConnectPaths",applicationID)%>">
                <% Dictionary<int, CodeItem> friendliness = CodeItems.GetCodeItems(CodeSetCodes.Instance().Friendliness());
                %>
                <%=friendliness[(int)Friends.GetFriendliness(CurrentUser.UserID, currentDomainUser.UserID)].Name%>
            </a></li>
        <%} %>
        <li class="tn-border-gray tn-border-bottom">
            <%=SPBHtmlHelper.Instance().Icon(IconTypes.Favorite) %>
            <%
               if (MicroBlogFollows.IsFollow(CurrentUser.UserID, Model.UserID))
               {%>
            <em class="tn-menu-text">
                <%=GetResourceString("Label_AlreadyCollected",applicationID)%></em>
            <%}
               else
               {
            %>
            <a class="tn-menu-text" id="addFavorite" href="javascript:;">
                <%=GetResourceString("Action_CollecteTheUser",applicationID)%>
            </a>
            <%} %>
        </li>
        <% if (!Friends.IsFriend(CurrentUser.UserID, currentDomainUser.UserID) && currentDomainUser.UserType != UserTypes.CompanyUser)
           {%>
        <li class="tn-border-gray tn-border-bottom">
            <%=SPBHtmlHelper.Instance().Icon(IconTypes.UserAdd) %>
            <a class="tn-menu-text nyroModal" href="<%=SiteUrls.Instance().NewFriendInvitation(CurrentUser.UserName,currentDomainUser.UserID) %>">
                <%= GetResourceString("Action_AddFriend")%></a> </li>
        <%}%>
        <% } %>
        <li class="tn-border-gray tn-border-bottom">
            <%=SPBHtmlHelper.Instance().Icon(IconTypes.UserCard) %>
            <a class="tn-menu-text" href="<%=SiteUrls.Instance().DownloadVCard(currentDomainUser.UserID) %>"
                title="<%=GetResourceString("Description_DownUserCard",applicationID)%>" target="_blank">
                <% if (CurrentUser != null && (CurrentUser.UserName == currentDomainUser.UserName)) { Response.Write(GetResourceString("Action_MyUserCard", applicationID)); } else { Response.Write(GetResourceString("Action_DownloadUserCard", applicationID)); } %>
            </a></li>
        <% if (CurrentUser != null && (currentDomainUser.UserID != CurrentUser.UserID))
           {
               if (Privacys.Validate(currentDomainUser.UserID, CurrentUser, PrivacyItemKeys.Instance().Action_ReceivePrivateMessage()))
               {%>
        <li id="sendMessageLi" class="tn-border-gray tn-border-bottom">
            <%=SPBHtmlHelper.Instance().Icon(IconTypes.Email)%>
            <a class="tn-menu-text" href="<%=SiteUrls.Instance().NewMessage(CurrentUser.UserName,currentDomainUser.UserID) %>"
                target="_blank">
                <%=GetResourceString("Action_SendMessage", applicationID)%></a> </li>
        <%}
               bool isStopedUser = ViewData.GetBool("isStopedUser", false);
               if (CurrentUser.UserType == UserTypes.PersonUser)
               { %>
        <li id="stopUserLi" class="tn-border-gray tn-border-bottom" <% if( isStopedUser) Response.Write("style=\"display: none\""); %>>
            <%=SPBHtmlHelper.Instance().Icon(IconTypes.Stop) %>
            <a class="tn-menu-text" id="stopUser" href="javascript:;" title="<%=string.Format(GetResourceString("Description_Pattern_SetStopUser", applicationID),currentDomainUser.DisplayName) %>">
                <%=GetResourceString("Action_StopUser",applicationID)%></a></li>
        <li id="delStopUserLi" class="tn-border-gray tn-border-bottom" <% if( !isStopedUser) Response.Write("style=\"display: none\""); %>>
            <%=SPBHtmlHelper.Instance().Icon(IconTypes.Stop) %>
            <a class="tn-menu-text" id="delStopUser" href="javascript:;" title="<%=string.Format(GetResourceString("Description_Pattern_SetStopUserOut", applicationID),currentDomainUser.DisplayName) %>">
                <%=GetResourceString("Action_CancelStopUser",applicationID)%></a></li>
        <li class="tn-border-gray tn-border-bottom">
            <%=SPBHtmlHelper.Instance().Icon(IconTypes.UserAllow)%>
            <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("PrivacySpecialSettings","UserDomainSettings",new RouteValueDictionary {{"userDomainName",CurrentUser.UserName},{"toUserID",currentDomainUser.UserID} }) %>"
                title="<%=GetResourceString("Description_SpecialUserSet",applicationID)%>">
                <%=GetResourceString("Action_SpecialSetUser",applicationID)%></a></li>
        <%} %>
        <li class="tn-border-gray tn-border-bottom">
            <%=SPBHtmlHelper.Instance().Icon(IconTypes.Alert)%>
            <a class="tn-menu-text" id="impeachReportModal" href="<%=SiteUrls.Instance().NewImpeachReport() %>">
                <%=GetResourceString("Action_ArtificialReport",applicationID)%></a></li>
        <% }%>
        <% if (CurrentUser != null && CurrentUser.IsContentAdministrator)
           {%>
        <li class="tn-border-gray tn-border-bottom">
            <%=SPBHtmlHelper.Instance().Icon(IconTypes.Flag)%>
            <a class="tn-menu-text" id="managerCommendLink" href="<%=SiteUrls.Instance().RecommendItem(ApplicationIDs.Instance().User(),currentDomainUser.UserID,currentDomainUser.UserID,currentDomainUser.DisplayName )%>">
                <%=GetResourceString("Common_ManagerRecommend")%></a> </li>
        <%} %>
        <% if (CurrentUser != null && currentDomainUser != null && CurrentUser.UserID != currentDomainUser.UserID)
           {%>
        <li class="tn-border-gray tn-border-bottom">
            <%=SPBHtmlHelper.Instance().Icon(IconTypes.Share)%>
            <a class="tn-menu-text nyroModal" id="shareLink" href="<%=SiteUrls.Instance().ShareInModal(false,Request.RawUrl, currentDomainUser.UserDomainTitle, HtmlUtils.TrimHtml(currentDomainUser.UserDomainDescription, 140), SiteUrls.Instance().UserAvatarUrl(currentDomainUser.UserID, AvatarSizeTypes.Small), ApplicationIDs.Instance().User(), currentDomainUser.UserID, currentDomainUser.UserName)%>">
                <%=GetResourceString("Common_Share")%>
            </a></li>
        <%} %>
        <% if (CurrentUser != null && currentDomainUser != null && CurrentUser.UserID == currentDomainUser.UserID)
           {%>
        <li><span class="tn-icon tn-icon-archive"></span><a href="<%=SPBUrlHelper.Action("EditProfile","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}})%>"
            class="tn-menu-text">
            <%=GetResourceString("Title_UpdateProfile", applicationID)%></a> </li>
        <%} %>
    </ul>
    <% UserIdentity userIdentity = Identities.GetUserIdentity(currentDomainUser.UserID, false);
       SiteSettings setting = SiteSettingsManager.GetSiteSettings();
       if (userIdentity != null && setting.EnableUserIdentity == true)
       {                                        %>
    <div class="spb-vip-info tn-border-gray tn-border-top">
        <b>
            <img class="spb-icon-v-big" src="<%=SiteUrls.Instance().IdentityIcon(userIdentity.Identity, IdentityIconTypes.Big) %>"
                alt="认证用户" height="26" width="90" />
        </b>
        <p class="tn-description">
            <%=userIdentity.IdentityDescription %></p>
    </div>
    <%} %>
</div>
<script type="text/javascript">
    $(document).ready(function() {
    
       $('#addFavorite').one("click",function() {
            $.get('<%= SPBUrlHelper.Action("FollowUser", "MicroBlog")%>', { userID: <%=Model.UserID%> }, function(data) {
                  $("#addFavorite").text("<%=GetResourceString("Label_AlreadyCollected",applicationID)%>");
              });
        });
    
        $('#impeachReportModal').nyroModal({
            resizeable: true
        });

        $('#managerCommendLink').nyroModal({
            resizeable: true
        });

        $('#shareLink').nyroModal({
                resizeable: true,
                width:500
        });
        
        $("#stopUser").click(function() {
            if (confirm("<%=GetResourceString("Message_SetStopUserConfirm", applicationID)%>"))
                $.getJSON('<%=SPBUrlHelper.Action("CreateStopedUser", "UserDomain", new RouteValueDictionary { {"userDomainName",currentDomainUser.UserName},{"userID",userID},{"toUserID",currentDomainUser.UserID}})%>',
                function(isSuccess) {
                    if (isSuccess) {
                        $("#stopUserLi").hide();
                        $("#delStopUserLi").show();
                    }
                });
        });
        $("#delStopUserLi").click(function() {
            $.getJSON('<%=SPBUrlHelper.Action("DeleteStopedUser", "UserDomain", new RouteValueDictionary { {"userDomainName",currentDomainUser.UserName},{"userID",userID},{"toUserID",currentDomainUser.UserID} })%>',
                function(isSuccess) {
                    if (isSuccess) {
                        $("#delStopUserLi").hide();
                        $("#stopUserLi").show();
                    }
                });
        });
    }); 
</script>
