﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<User>" %>
<% User currentDomainUser = ViewData.Model;
   int applicationID = ApplicationIDs.Instance().User();
   IList<Application> installedApplications = ViewData.Get<IList<Application>>("InstalledApplications", new List<Application>());
   Dictionary<int, Application> applications = ViewData.Get<Dictionary<int, Application>>("applications", new Dictionary<int, Application>());
   string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
%>

<div class="tn-info-part">
  <div class="spb-basic-info">
    <% string roleIcons = SPBHtmlHelper.Instance().ShowUserRoleIcons(currentDomainUser);
           if (!string.IsNullOrEmpty(roleIcons))
           { %>
    <dl>
      <dt> <%=GetResourceString("Label_PersonUserTitle",applicationID)%><%=GetResourceString("Common_Colon") %></dt>
      <dd> <span class="spb-user-type"> <%=roleIcons %></span></dd>
    </dl>
    <%} %>
    <dl>
      <dt> <%=GetResourceString("Label_Rank")%><%=GetResourceString("Common_Colon") %></dt>
      <dd>
        <%if (CurrentUser != null && (CurrentUser.UserName == userDomainName || CurrentUser.IsContentAdministrator))
                  { %>
        <a href="<%=SPBUrlHelper.Action("TotalUserPoints","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"> <span class="spb-user-type"> <%=SPBHtmlHelper.Instance().ShowUserRankIcons(currentDomainUser)%></span></a>
        <%}
                  else
                  { %>
        <span class="spb-user-type"> <%=SPBHtmlHelper.Instance().ShowUserRankIcons(currentDomainUser)%></span>
        <%} %>
      </dd>
    </dl>
    <dl>
      <dt> <%=GetResourceString("Label_Status") %><%=GetResourceString("Common_Colon") %></dt>
      <dd> <span class="spb-user-type">
        <% if (currentDomainUser.IsOnline)
                       { %>
        <% %>
        <img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Icons/user_IsOnline.gif")%>"
                        title="在线" alt="在线" />
        <% }
                       else
                       { %>
        <img src="<%=WebUtils.FullPath(Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Icons/user_IsOffline.gif"))%>"
                        title="离线" alt="离线" />
        <%} %>
        </span> </dd>
    </dl>
    <dl>
      <dt> <%=GetResourceString("Label_PersonUserRegisterDate",applicationID)%><%=GetResourceString("Common_Colon") %></dt>
      <dd> <%= Formatter.FormatDate(currentDomainUser.DateCreated,true) %></dd>
    </dl>
    <dl>
      <dt> <%=GetResourceString("Label_PersonUserLastLoginTime",applicationID)%><%=GetResourceString("Common_Colon") %></dt>
      <dd> <%=Formatter.FormatDate(currentDomainUser.LastActivity,true) %></dd>
    </dl>
    <dl>
      <dt> <%=GetResourceString("Label_PersonUserHitTimes",applicationID)%><%=GetResourceString("Common_Colon") %></dt>
      <dd> <%=currentDomainUser.HitTimes %></dd>
    </dl>
    <dl>
      <dt> <%=GetResourceString("Label_PersonUserWeekHitTimes",applicationID)%><%=GetResourceString("Common_Colon") %></dt>
      <dd> <%=currentDomainUser.StageHitTimes%></dd>
    </dl>
    <dl>
      <dt> <%=GetResourceString("Enum_UserPointCategory_BasicPoint")%><%=GetResourceString("Common_Colon") %></dt>
      <dd> <%=currentDomainUser.BasicPoints %></dd>
    </dl>
    <dl>
      <dt> <%=GetResourceString("Enum_UserPointCategory_ReportPoint")%><%=GetResourceString("Common_Colon") %></dt>
      <dd> <%=currentDomainUser.ReportPoints %></dd>
    </dl>
    <dl>
      <dt> <%=GetResourceString("Enum_UserPointCategory_TradePoint")%><%=GetResourceString("Common_Colon") %></dt>
      <dd> <%=currentDomainUser.TradePoints %></dd>
    </dl>
    <dl>
      <dt> <%=GetResourceString("Label_PersonPointSum",applicationID)%><%=GetResourceString("Common_Colon") %></dt>
      <dd> <%=ViewData.GetFloat("TotalPoints",0) %></dd>
    </dl>
  </div>
  <div class="spb-published-info tn-border-gray tn-border-top tn-helper-clearfix">
    <% foreach (Application application in installedApplications)
           {
               if (application == null)
                   continue;%>
    <dl>
      <dt><a href="<%=SiteUrls.Instance().UserChannelHome(currentDomainUser.UserID,application.ApplicationID) %>"> <%=application.GetMultilingualApplicationName(CurrentUserLanguage)%></a>：</dt>
      <dd class="tn-count"> <%=application.GetItemCountValue(PresentAreaIDs.Instance().UserDomain(), currentDomainUser.UserID)%> </dd>
    </dl>
    <%
            } %>
  </div>
</div>
