﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");

    User domainUser = Users.GetUser(userDomainName, false);
    int applicationID = ApplicationIDs.Instance().User();
%>
<div class="tn-widget spb-not-open-tip">
    <div class="tn-cue-highlight tn-corner-all tn-message-box">
        <span class="tn-helper-left"><span class="spb-icon-lock tn-img-sprite"></span></span>
        <%
            if (CurrentUser == null)
            {%>
        <div class="tn-helper-flowfix">
            <%=GetResourceString("Description_NoPowerForUserPrivacySetting", applicationID)%>
        </div>
        <%= SPBHtmlHelper.Instance().LinkButton("login", GetResourceString("Action_LoginFirst", applicationID), SiteUrls.Instance().Login(true), ButtonSizes.Large, HighlightStyles.Primary)%>
        <%    
            }
            else
            {
                if (CurrentUser != null && Friends.IsFriend(CurrentUser.UserID, domainUser.UserID))
                {
        %>
        <div class="tn-helper-flowfix">
            <%=GetResourceString("Description_NoPowerForUserPrivacySetting", applicationID)%>
        </div>
        <%= SPBHtmlHelper.Instance().LinkButton("SendMessage", GetResourceString("Action_SendMessage", applicationID), SiteUrls.Instance().NewMessage(CurrentUser.UserName, domainUser.UserID), ButtonSizes.Default, HighlightStyles.Primary,IconTypes.Email,TextIconLayout.IconText)%>
        <%
            }
            else
            {
        %>
        <div class="tn-helper-flowfix">
            <%=string.Format(GetResourceString("Description_Pattern_NoPowerForUserPrivacySetting2", applicationID), domainUser.CommonName)%>
        </div>
        <%
            if (CurrentUser != null && CurrentUser.UserType == UserTypes.PersonUser)
            {
        %>
        <%=SPBHtmlHelper.Instance().LinkButton("AddFriend", GetResourceString("Action_AddFriend"), SiteUrls.Instance().NewFriendInvitation(CurrentUser.UserName, domainUser.UserID), ButtonSizes.Large, HighlightStyles.Primary,IconTypes.UserAdd,TextIconLayout.IconText)%>
        <%} %>
        <%=SPBHtmlHelper.Instance().LinkButton("SendMessage", GetResourceString("Action_SendMessage", applicationID), SiteUrls.Instance().NewMessage(CurrentUser.UserName, domainUser.UserID), ButtonSizes.Large, HighlightStyles.Primary,IconTypes.Email,TextIconLayout.IconText)%>
        <%   
            }

        }
        %>
    </div>
</div>
<div class="tn-blank10">
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $('#AddFriend').nyroModal({
            resizeable: true
        });
    });
      
</script>

