﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%   
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">$.nyroModalRemove();</script>"));
        }
        else if (messageType == StatusMessageType.Error)
        {
            //Response.Write(TempData.GetString("StatusMessageContent", string.Empty));
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
        }
        TempData["StatusMessageType"]=null;
        TempData["StatusMessageContent"]=null;
    }
    string privacyItemKey = ViewData.GetString("PrivacyItemKey", string.Empty);
    int privacyDegree = ViewData.GetInt("PrivacyDegree", (int)PrivacyDegree.Public);
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    string selectedUsersValue = "{}";
    string getUsersUrl = SPBUrlHelper.Action("SearchUsers", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName } });
%>
<form id="editor" class="nyroModal" action="<%=SPBUrlHelper.Action("SetPrivacySettings", "UserDomainSettings", new RouteValueDictionary { {"userDomainName",userDomainName},{"privacyItemKey",privacyItemKey},{"privacyDegree",privacyDegree}})%>"
method="get">
<div>
    <div style="padding: 3px; width: 94%">
        <div class="commonTitle">
            自定义设置
        </div>
        <table class="commonFormArea" cellspacing="1" cellpadding="4" width="100%" border="0">
            <tr>
                <td class="commonFormFieldName" style="width: 120px">
                    <input type="hidden" id="privacyDegree" name="privacyDegree" value="<%=privacyDegree %>" />
                </td>
                <td class="commonFormField">
                    <select name="PrivacyItem" id="<%=privacyItemKey %>">
                        <option <%if (privacyDegree == (int)PrivacyDegree.Public) Response.Write("selected=\"selected\""); %>
                            value="<%=(int)PrivacyDegree.Public %>">公开</option>
                        <option <%if (privacyDegree == (int)PrivacyDegree.Friend) Response.Write("selected=\"selected\""); %>
                            value="<%=(int)PrivacyDegree.Friend %>">仅好友可见</option>
                        <option <%if (privacyDegree == (int)PrivacyDegree.Private) Response.Write("selected=\"selected\""); %>
                            value="<%=(int)PrivacyDegree.Private %>">仅自己可见</option>
                        <option value="0">选择特许好友</option>
                    </select>
                    <div id="userIDs" style="display: none;">
                        <input id="selectedUserIDsInput" name="selectedUserIDs" type="text" style="width: 140px;" />
                    </div>
                </td>
            </tr>
            <tr>
                <td class="commonFormFieldName" style="width: 120px">
                </td>
                <td class="commonFormField">
                    <input id="selectedStopUserIDsInput" name="selectedStopUserIDs" type="text" style="width: 140px" />
                </td>
            </tr>
            <tr>
                <td class="commonFormFieldName" style="width: 120px">
                </td>
                <td class="commonFormField">
                    <input type="submit"  id="EditUserTagSubmitButton" value="<%=GetResourceString("Button_OK")%>" />
                    <input type="button" class="inputCancel nyroModalClose" value="<%=GetResourceString("Button_Cancel")%>" />
                </td>
            </tr>
        </table>
        <br />
    </div>
</div>
</form>

<script type="text/javascript" rel="forceLoad">
 $(document).ready(function() {
     $("#selectedUserIDsInput").autoSuggest("<%=getUsersUrl %>", {
         asHtmlID: "selectedUserIDs",
         selectedItemProp: "displayName",
         selectedValuesProp: "userID",
         searchObjProps: "nickName,commonName",
         queryParam: "term",
         enableManualAdd: true,
         preFill:<%=selectedUsersValue %>
     });
     $("#selectedStopUserIDsInput").autoSuggest("<%=getUsersUrl %>", {
        asHtmlID: "selectedStopUserIDs",
        selectedItemProp: "displayName",
        selectedValuesProp: "userID",
        searchObjProps: "nickName,commonName",
        queryParam: "term",
        preFill:<%=selectedUsersValue %>
     });
    $("select[name=PrivacyItem]").change(function(){
          if(this.value > 0)
          {
               $("#userIDs").attr("style","display:none");
          }
          else
          {
               $("#userIDs").removeAttr("style");
          }
    });
 });
</script>

